/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.gradle.internal.collect.PersistentMap;
import org.gradle.internal.collect.PersistentSet;
import org.gradle.internal.collect.PersistentSetTrie;
import org.gradle.internal.collect.Preconditions;
import org.gradle.internal.collect.SingletonIterator;
import org.jspecify.annotations.Nullable;

final class PersistentSet1<K>
implements PersistentSet<K> {
    private final K key;

    public PersistentSet1(K key) {
        this.key = key;
    }

    @Override
    public PersistentSet<K> plus(K key) {
        Preconditions.keyCannotBeNull(key);
        return this.contains(key) ? this : PersistentSetTrie.ofDistinct(this.key, key);
    }

    @Override
    public PersistentSet<K> minus(K key) {
        return this.clear(this.contains(key));
    }

    @Override
    public PersistentSet<K> minusAll(Iterable<K> keys) {
        if (keys instanceof PersistentSet) {
            return this.clear(((PersistentSet)keys).contains(this.key));
        }
        if (keys instanceof Collection) {
            return this.clear(((Collection)keys).contains(this.key));
        }
        for (K k : keys) {
            if (!this.contains(k)) continue;
            return this.clear(true);
        }
        return this;
    }

    @Override
    public PersistentSet<K> except(PersistentSet<K> other) {
        return this.clear(other.contains(this.key));
    }

    @Override
    public <S extends K> PersistentSet<K> union(PersistentSet<S> other) {
        return other.isEmpty() ? this : other.plus(this.key);
    }

    @Override
    public PersistentSet<K> intersect(PersistentSet<K> other) {
        return this.clear(!other.contains(this.key));
    }

    private PersistentSet<K> clear(boolean removed) {
        return removed ? PersistentSet.of() : this;
    }

    @Override
    public PersistentSet<K> filter(Predicate<? super K> predicate) {
        return predicate.test(this.key) ? this : PersistentSet.of();
    }

    @Override
    public <R> PersistentSet<R> map(Function<? super K, ? extends R> mapper) {
        return PersistentSet.of(mapper.apply(this.key));
    }

    @Override
    public <R> PersistentSet<R> flatMap(Function<? super K, PersistentSet<R>> mapper) {
        return mapper.apply(this.key);
    }

    @Override
    public <G> PersistentMap<G, PersistentSet<K>> groupBy(Function<? super K, ? extends @Nullable G> group) {
        G g = group.apply(this.key);
        return g != null ? PersistentMap.of(g, this) : PersistentMap.of();
    }

    @Override
    public boolean anyMatch(Predicate<? super K> predicate) {
        return predicate.test(this.key);
    }

    @Override
    public boolean noneMatch(Predicate<? super K> predicate) {
        return !predicate.test(this.key);
    }

    @Override
    public boolean contains(K key) {
        return Objects.equals(key, this.key);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<K> iterator() {
        return new SingletonIterator<K>(this.key);
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        action.accept(this.key);
    }

    public String toString() {
        return "{" + this.key + "}";
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PersistentSet)) {
            return false;
        }
        PersistentSet that = (PersistentSet)other;
        return that.size() == 1 && that.contains(this.key);
    }
}

