/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.PerRootInfo;
import org.gradle.api.internal.tasks.testing.report.generic.PerRootTabRenderer;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.TestOutputReader;
import org.gradle.api.tasks.testing.TestFileAttachmentDataEvent;
import org.gradle.api.tasks.testing.TestKeyValueDataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;
import org.gradle.reporting.TabsRenderer;
import org.gradle.util.Path;

final class GenericPageRenderer
extends TabbedPageRenderer<TestTreeModel> {
    private static final URL STYLE_URL = Resources.getResource(GenericPageRenderer.class, (String)"style.css");
    private final List<TestOutputReader> outputReaders;
    private final List<String> rootDisplayNames;

    public static String getUrlTo(Path originatingPath, boolean isOriginatingPathLeaf, Path targetPath, boolean isTargetPathLeaf) {
        if (originatingPath.equals((Object)targetPath) && isOriginatingPathLeaf == isTargetPathLeaf) {
            return "#";
        }
        java.nio.file.Path relativePath = Paths.get("./" + GenericHtmlTestReportGenerator.getFilePath(originatingPath, isOriginatingPathLeaf), new String[0]).getParent().relativize(Paths.get("./" + GenericHtmlTestReportGenerator.getFilePath(targetPath, isTargetPathLeaf), new String[0]));
        StringBuilder url = new StringBuilder();
        for (java.nio.file.Path segment : relativePath) {
            url.append(UrlEscapers.urlPathSegmentEscaper().escape(segment.toString()));
            url.append('/');
        }
        return url.substring(0, url.length() - 1);
    }

    GenericPageRenderer(List<TestOutputReader> outputReaders, List<String> rootDisplayNames) {
        this.outputReaders = outputReaders;
        this.rootDisplayNames = rootDisplayNames;
    }

    private void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        Path path = ((TestTreeModel)this.getModel()).getPath();
        if (path.equals((Object)Path.ROOT)) {
            return;
        }
        htmlWriter.startElement("div").attribute("class", "breadcrumbs");
        for (Path ancestorPath : path.ancestors()) {
            String title = ancestorPath.equals((Object)Path.ROOT) ? "all" : ancestorPath.getName();
            htmlWriter.startElement("a").attribute("class", "breadcrumb").attribute("href", GenericPageRenderer.getUrlTo(path, ((TestTreeModel)this.getModel()).getChildren().isEmpty(), ancestorPath, false)).characters((CharSequence)title).endElement();
            htmlWriter.characters((CharSequence)" > ");
        }
        htmlWriter.startElement("span").attribute("class", "breadcrumb").characters((CharSequence)path.getName()).endElement();
        htmlWriter.endElement();
    }

    protected URL getStyleUrl() {
        return STYLE_URL;
    }

    protected String getTitle() {
        return this.buildTitle("All Results", name -> "");
    }

    protected String getPageTitle() {
        return this.buildTitle("Test results - All Results", name -> "Test results - " + name);
    }

    private String buildTitle(String rootTitle, Function<String, String> buildTitleFromName) {
        String name = ((TestTreeModel)this.getModel()).getPath().getName();
        if (name == null) {
            return rootTitle;
        }
        return buildTitleFromName.apply(name);
    }

    protected ReportRenderer<TestTreeModel, SimpleHtmlWriter> getHeaderRenderer() {
        return new ReportRenderer<TestTreeModel, SimpleHtmlWriter>(){

            public void render(TestTreeModel model, SimpleHtmlWriter htmlWriter) throws IOException {
                GenericPageRenderer.this.renderBreadcrumbs(htmlWriter);
            }
        };
    }

    protected ReportRenderer<TestTreeModel, SimpleHtmlWriter> getContentRenderer() {
        TabsRenderer rootTabsRenderer = new TabsRenderer();
        List<List<PerRootInfo>> perRootInfo = ((TestTreeModel)this.getModel()).getPerRootInfo();
        for (int rootIndex = 0; rootIndex < perRootInfo.size(); ++rootIndex) {
            TabsRenderer directlyBelowRootTabsRenderer;
            final List<PerRootInfo> infos = perRootInfo.get(rootIndex);
            if (infos.isEmpty()) continue;
            ArrayList<TabsRenderer> perRootInfoTabsRenderers = new ArrayList<TabsRenderer>(infos.size());
            for (int perRootInfoIndex = 0; perRootInfoIndex < infos.size(); ++perRootInfoIndex) {
                PerRootInfo info = infos.get(perRootInfoIndex);
                TabsRenderer perRootInfoTabsRenderer = new TabsRenderer();
                perRootInfoTabsRenderer.add("summary", (ReportRenderer)new PerRootTabRenderer.ForSummary(rootIndex, perRootInfoIndex));
                TestOutputReader outputReader = this.outputReaders.get(rootIndex);
                boolean hasStdout = false;
                boolean hasStderr = false;
                for (OutputEntry outputEntry : info.getOutputEntries()) {
                    if (outputReader.hasOutput(outputEntry, TestOutputEvent.Destination.StdOut)) {
                        hasStdout = true;
                    }
                    if (outputReader.hasOutput(outputEntry, TestOutputEvent.Destination.StdErr)) {
                        hasStderr = true;
                    }
                    if (!hasStdout || !hasStderr) continue;
                    break;
                }
                if (hasStdout) {
                    perRootInfoTabsRenderer.add("standard output", (ReportRenderer)new PerRootTabRenderer.ForOutput(rootIndex, perRootInfoIndex, outputReader, TestOutputEvent.Destination.StdOut));
                }
                if (hasStderr) {
                    perRootInfoTabsRenderer.add("error output", (ReportRenderer)new PerRootTabRenderer.ForOutput(rootIndex, perRootInfoIndex, outputReader, TestOutputEvent.Destination.StdErr));
                }
                if (Iterables.any(info.getMetadatas(), event -> event instanceof TestKeyValueDataEvent)) {
                    perRootInfoTabsRenderer.add("data", (ReportRenderer)new PerRootTabRenderer.ForKeyValues(rootIndex, perRootInfoIndex));
                }
                if (Iterables.any(info.getMetadatas(), event -> event instanceof TestFileAttachmentDataEvent)) {
                    perRootInfoTabsRenderer.add("attachments", (ReportRenderer)new PerRootTabRenderer.ForFileAttachments(rootIndex, perRootInfoIndex));
                }
                perRootInfoTabsRenderers.add(perRootInfoTabsRenderer);
            }
            if (perRootInfoTabsRenderers.size() == 1) {
                directlyBelowRootTabsRenderer = (TabsRenderer)perRootInfoTabsRenderers.get(0);
            } else {
                directlyBelowRootTabsRenderer = new TabsRenderer();
                for (int i = 0; i < perRootInfoTabsRenderers.size(); ++i) {
                    directlyBelowRootTabsRenderer.add("run " + (i + 1), (ReportRenderer)perRootInfoTabsRenderers.get(i));
                }
            }
            String rootState = "successGroup";
            for (PerRootInfo info : infos) {
                if (info.getFailedLeafCount() > 0) {
                    rootState = "failureGroup";
                    break;
                }
                if (info.getSkippedLeafCount() != info.getTotalLeafCount()) continue;
                rootState = "skippedGroup";
                break;
            }
            rootTabsRenderer.add(this.rootDisplayNames.get(rootIndex), rootState, (ReportRenderer)new ReportRenderer<TestTreeModel, SimpleHtmlWriter>(){

                public void render(TestTreeModel model, SimpleHtmlWriter output) throws IOException {
                    String displayName = SerializableTestResult.getCombinedDisplayName(((PerRootInfo)infos.get(0)).getResults());
                    output.startElement("h1").characters((CharSequence)displayName).endElement();
                    directlyBelowRootTabsRenderer.render((Object)model, output);
                }
            });
        }
        return rootTabsRenderer;
    }
}

