/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import javax.inject.Inject;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;
import org.gradle.internal.FileUtils;
import org.gradle.internal.scripts.DefaultScriptFileResolver;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.scripts.ScriptResolutionResult;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Global.class})
public class BuildLayoutFactory {
    private final ScriptFileResolver scriptFileResolver;

    @Inject
    public BuildLayoutFactory(ScriptFileResolver scriptFileResolver) {
        this.scriptFileResolver = scriptFileResolver;
    }

    public BuildLayoutFactory() {
        this((ScriptFileResolver)new DefaultScriptFileResolver());
    }

    public BuildLayout getLayoutFor(File currentDir, boolean shouldSearchUpwards) {
        boolean searchUpwards = shouldSearchUpwards && !BuildLayoutFactory.isBuildSrc(currentDir);
        BuildLayout layout = searchUpwards ? this.findLayoutRecursively(currentDir) : this.findLayout(currentDir);
        return layout != null ? layout : this.getLayoutWithDefaultSettingsFile(currentDir);
    }

    public BuildLayout getLayoutFor(BuildLayoutConfiguration configuration) {
        if (configuration.isUseEmptySettings()) {
            return this.layout(configuration.getCurrentDir(), null);
        }
        return this.getLayoutFor(configuration.getCurrentDir(), configuration.isSearchUpwards());
    }

    private @Nullable BuildLayout findLayoutRecursively(File dir) {
        while (dir != null) {
            BuildLayout layout = this.findLayout(dir);
            if (layout != null) {
                return layout;
            }
            dir = dir.getParentFile();
        }
        return null;
    }

    private @Nullable BuildLayout findLayout(File dir) {
        ScriptResolutionResult resolutionResult = this.scriptFileResolver.resolveScriptFile(dir, "settings");
        if (resolutionResult.isScriptFound()) {
            return this.layout(dir, resolutionResult);
        }
        return null;
    }

    private BuildLayout getLayoutWithDefaultSettingsFile(File dir) {
        ScriptResolutionResult resolution = ScriptResolutionResult.fromSingleFile((String)"settings", (File)FileUtils.canonicalize((File)new File(dir, "settings.gradle")));
        return this.layout(dir, resolution);
    }

    private BuildLayout layout(File rootDir, @Nullable ScriptResolutionResult settingsFileResolution) {
        return new BuildLayout(rootDir, settingsFileResolution, this.scriptFileResolver);
    }

    private static boolean isBuildSrc(File dir) {
        return dir.getName().equals("buildSrc");
    }
}

