/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmOverloadFilter;", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "<init>", "()V", "filterPackageMemberOverloads", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "overloads", "getPartFqNameForDeserialized", "Lorg/jetbrains/kotlin/name/FqName;", "descriptor", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "frontend.java"})
public final class JvmOverloadFilter
implements OverloadFilter {
    @NotNull
    public static final JvmOverloadFilter INSTANCE = new JvmOverloadFilter();

    private JvmOverloadFilter() {
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptorNonRoot> filterPackageMemberOverloads(@NotNull Collection<? extends DeclarationDescriptorNonRoot> overloads) {
        Intrinsics.checkNotNullParameter(overloads, (String)"overloads");
        ArrayList<DeclarationDescriptorNonRoot> result2 = new ArrayList<DeclarationDescriptorNonRoot>();
        HashSet<FqName> sourceClassesFQNs = new HashSet<FqName>();
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : overloads) {
            KtFile file;
            if (DescriptorToSourceUtils.getContainingFile(declarationDescriptorNonRoot) == null) continue;
            result2.add(declarationDescriptorNonRoot);
            sourceClassesFQNs.add(JvmFileClassUtil.getFileClassInfoNoResolve(file).getFileClassFqName());
        }
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : overloads) {
            FqName implClassFQN;
            if (declarationDescriptorNonRoot instanceof ConstructorDescriptor || !(declarationDescriptorNonRoot instanceof DeserializedCallableMemberDescriptor) || sourceClassesFQNs.contains(implClassFQN = this.getPartFqNameForDeserialized((DeserializedMemberDescriptor)declarationDescriptorNonRoot))) continue;
            result2.add(declarationDescriptorNonRoot);
        }
        return result2;
    }

    private final FqName getPartFqNameForDeserialized(DeserializedMemberDescriptor descriptor) {
        Object object = UtilKt.getImplClassNameForDeserialized(descriptor);
        if (object == null || (object = ((JvmClassName)object).getFqNameForTopLevelClassMaybeWithDollars()) == null) {
            throw new IllegalStateException(("No implClassName for " + descriptor).toString());
        }
        return object;
    }
}

