/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirArrayOfNothingQualifierCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirTypeVisibilityHelpersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJA\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u0015*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J_\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\b\b\u0002\u0010#\u001a\u00020\u0018H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "validateReturnTypeVisibility", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "callableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/references/FirReference;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "isReifiedTypeParameterOrFromKotlinArray", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "cannotBeReified", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkArgumentAndReport", "typeArgument", "typeParameter", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isExplicit", "isArray", "isPlaceHolder", "fullyExpandedType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;Lorg/jetbrains/kotlin/KtSourceElement;ZZZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReifiedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,155:1\n672#2,11:156\n1807#2,3:167\n1807#2,3:171\n57#3:170\n14060#4,2:174\n*S KotlinDebug\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n*L\n41#1:156,11\n84#1:167,3\n87#1:171,3\n86#1:170\n119#1:174,2\n*E\n"})
public final class FirReifiedChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirReifiedChecker INSTANCE = new FirReifiedChecker();

    private FirReifiedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        FirCallableSymbol varargParameter;
        Object object;
        ConeKotlinType varargElementType;
        FirCallableSymbol firCallableSymbol;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirReference calleeReference = expression2.getCalleeReference();
        List<FirTypeProjection> typeArguments = expression2.getTypeArguments();
        FirCallableSymbol callableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        Object object2 = callableSymbol;
        if (object2 == null || (object2 = ((FirCallableSymbol)object2).getTypeParameterSymbols()) == null) {
            return;
        }
        Object typeParameters2 = object2;
        int count = Math.min(typeArguments.size(), typeParameters2.size());
        FirCallableSymbol firCallableSymbol2 = callableSymbol;
        Object object3 = firCallableSymbol2 instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol2 : null;
        if (object3 != null && (object3 = ((FirFunctionSymbol)object3).getValueParameterSymbols()) != null) {
            Object v2;
            block7: {
                Iterable $this$singleOrNull$iv = (Iterable)object3;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl = false;
                    if (!it.isVararg()) continue;
                    if (found$iv) {
                        v2 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            firCallableSymbol = v2;
        } else {
            firCallableSymbol = null;
        }
        ConeKotlinType coneKotlinType = varargElementType = (object = (varargParameter = firCallableSymbol)) != null && (object = ((FirCallableSymbol)object).getResolvedReturnType()) != null ? FirTypeUtilsKt.arrayElementType$default((ConeKotlinType)object, false, 1, null) : null;
        ConeSimpleKotlinType $i$f$singleOrNull = coneKotlinType != null ? ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(coneKotlinType) : null;
        Object object4 = $i$f$singleOrNull instanceof ConeTypeParameterType ? (ConeTypeParameterType)$i$f$singleOrNull : null;
        FirTypeParameterSymbol varargTypeParameter = object4 != null && (object4 = ((ConeTypeParameterType)object4).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object4).getTypeParameterSymbol() : null;
        for (int index = 0; index < count; ++index) {
            boolean isInferred;
            Object element$iv;
            FirTypeProjection typeArgumentProjection = typeArguments.get(index);
            KtSourceElement ktSourceElement = typeArgumentProjection.getSource();
            if (ktSourceElement == null && (ktSourceElement = calleeReference.getSource()) == null) continue;
            KtSourceElement source = ktSourceElement;
            ConeKotlinType coneKotlinType2 = ConeTypeProjectionKt.getType(FirTypeUtilsKt.toConeTypeProjection(typeArgumentProjection));
            if (coneKotlinType2 == null || (element$iv = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, coneKotlinType2)) == null) continue;
            Object typeArgument = element$iv;
            FirTypeParameterSymbol typeParameter = (FirTypeParameterSymbol)typeParameters2.get(index);
            KtSourceElement ktSourceElement2 = typeArgumentProjection.getSource();
            boolean isExplicit = Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE);
            boolean isPlaceHolder = isExplicit && Intrinsics.areEqual((Object)KtSourceElementKt.getText(typeArgumentProjection.getSource()), (Object)"_");
            boolean bl = isInferred = !isExplicit || isPlaceHolder;
            if (this.isReifiedTypeParameterOrFromKotlinArray(typeParameter)) {
                this.checkArgumentAndReport(context2, reporter, (ConeKotlinType)typeArgument, typeParameter, source, isExplicit, false, isPlaceHolder, (ConeKotlinType)typeArgument);
                continue;
            }
            if (!Intrinsics.areEqual((Object)varargTypeParameter, (Object)typeParameter) || !FirTypeVisibilityHelpersKt.isTypeVisibilityBroken(context2, typeArgument, false) || !isInferred) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINFERRED_INVISIBLE_VARARG_TYPE_ARGUMENT(), (Object)typeParameter, typeArgument, (Object)varargParameter, null, 64, null);
        }
        this.validateReturnTypeVisibility(context2, reporter, expression2, calleeReference, callableSymbol);
    }

    /*
     * WARNING - void declaration
     */
    private final void validateReturnTypeVisibility(CheckerContext context2, DiagnosticReporter reporter, FirQualifiedAccessExpression expression2, FirReference calleeReference, FirCallableSymbol<?> callableSymbol) {
        boolean hasNestedVisibilityErrorsInParameters;
        ConeKotlinType returnType;
        block12: {
            boolean bl;
            void $this$any$iv;
            boolean bl2;
            block11: {
                returnType = FirTypeUtilsKt.getResolvedType(expression2);
                if (calleeReference instanceof FirResolvedErrorReference) {
                    return;
                }
                Iterable $this$any$iv2 = expression2.getTypeArguments();
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        FirTypeProjection it = (FirTypeProjection)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof FirTypeProjectionWithVariance && ((FirTypeProjectionWithVariance)it).getTypeRef() instanceof FirErrorTypeRef)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            if (!(expression2 instanceof FirFunctionCall)) {
                return;
            }
            Object $this$arguments$iv = (FirCall)((Object)expression2);
            boolean $i$f$getArguments = false;
            $this$arguments$iv = CollectionsKt.plus((Collection)FirExpressionUtilKt.getAllReceiverExpressions(expression2), (Iterable)$this$arguments$iv.getArgumentList().getArguments());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl4 = false;
                    if (!(FirTypeUtilsKt.getResolvedType(it) instanceof ConeErrorType || FirTypeVisibilityHelpersKt.isTypeVisibilityBroken(context2, FirTypeUtilsKt.getResolvedType(it), true))) continue;
                    bl = true;
                    break block12;
                }
                bl = hasNestedVisibilityErrorsInParameters = false;
            }
        }
        if (hasNestedVisibilityErrorsInParameters) {
            return;
        }
        if (FirTypeVisibilityHelpersKt.isTypeVisibilityBroken(context2, returnType, true)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunctionCall)expression2).getSource(), FirErrors.INSTANCE.getINFERRED_INVISIBLE_RETURN_TYPE(), callableSymbol, (Object)returnType, null, 32, null);
        }
    }

    private final boolean isReifiedTypeParameterOrFromKotlinArray(FirTypeParameterSymbol $this$isReifiedTypeParameterOrFromKotlinArray) {
        FirBasedSymbol<?> containingDeclaration = $this$isReifiedTypeParameterOrFromKotlinArray.getContainingDeclarationSymbol();
        return $this$isReifiedTypeParameterOrFromKotlinArray.isReified() || containingDeclaration instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)containingDeclaration).getClassId(), (Object)StandardClassIds.INSTANCE.getArray());
    }

    private final boolean cannotBeReified(ConeKotlinType $this$cannotBeReified, LanguageVersionSettings languageVersionSettings) {
        ConeKotlinType coneKotlinType = $this$cannotBeReified;
        return coneKotlinType instanceof ConeCapturedType ? true : (coneKotlinType instanceof ConeDynamicType ? true : FirArrayOfNothingQualifierCheckerKt.unsupportedKindOfNothingAsReifiedOrInArray($this$cannotBeReified, languageVersionSettings) != null);
    }

    private final void checkArgumentAndReport(CheckerContext context2, DiagnosticReporter reporter, ConeKotlinType typeArgument, FirTypeParameterSymbol typeParameter, KtSourceElement source, boolean isExplicit, boolean isArray, boolean isPlaceHolder, ConeKotlinType fullyExpandedType2) {
        if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(fullyExpandedType2), (Object)StandardClassIds.INSTANCE.getArray())) {
            ConeTypeProjection[] $this$forEach$iv = fullyExpandedType2.getTypeArguments();
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$forEach$iv[i2];
                boolean bl = false;
                if (!(it instanceof ConeKotlinType)) continue;
                FirReifiedChecker.checkArgumentAndReport$default(INSTANCE, context2, reporter, (ConeKotlinType)it, typeParameter, source, isExplicit, true, isPlaceHolder, null, 256, null);
            }
            return;
        }
        if (FirTypeVisibilityHelpersKt.isTypeVisibilityBroken(context2, fullyExpandedType2, false) && (!isExplicit || isPlaceHolder)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINFERRED_INVISIBLE_REIFIED_TYPE_ARGUMENT(), (Object)typeParameter, (Object)fullyExpandedType2, null, 32, null);
        }
        if (typeArgument instanceof ConeTypeParameterType) {
            FirTypeParameterSymbol symbol = ((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol();
            if (!symbol.isReified()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, isArray ? FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED_ARRAY_ERROR() : FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED(), (Object)symbol, null, 16, null);
            }
        } else if (typeArgument instanceof ConeDefinitelyNotNullType && isExplicit) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEFINITELY_NON_NULLABLE_AS_REIFIED(), null, 8, null);
        } else if (this.cannotBeReified(typeArgument, context2.getLanguageVersionSettings())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREIFIED_TYPE_FORBIDDEN_SUBSTITUTION(), (Object)typeArgument, null, 16, null);
        } else if (typeArgument instanceof ConeIntersectionType) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTYPE_INTERSECTION_AS_REIFIED(), (Object)typeParameter, ((ConeIntersectionType)typeArgument).getIntersectedTypes(), null, 32, null);
        }
    }

    static /* synthetic */ void checkArgumentAndReport$default(FirReifiedChecker firReifiedChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, ConeKotlinType coneKotlinType, FirTypeParameterSymbol firTypeParameterSymbol, KtSourceElement ktSourceElement, boolean bl, boolean bl2, boolean bl3, ConeKotlinType coneKotlinType2, int n2, Object object) {
        if ((n2 & 0x100) != 0) {
            coneKotlinType2 = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)checkerContext, coneKotlinType);
        }
        firReifiedChecker.checkArgumentAndReport(checkerContext, diagnosticReporter, coneKotlinType, firTypeParameterSymbol, ktSourceElement, bl, bl2, bl3, coneKotlinType2);
    }
}

