/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.failure.DefaultThrowableToTestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.AssertErrorMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.AssertjMultipleAssertionsErrorMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.JUnitComparisonTestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestAssertionFailedMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestMultipleFailuresErrorMapper;
import org.gradle.api.internal.tasks.testing.junit.IgnoredTestDescriptorProvider;
import org.gradle.api.internal.tasks.testing.source.DefaultClassSource;
import org.gradle.api.internal.tasks.testing.source.DefaultMethodSource;
import org.gradle.api.internal.tasks.testing.source.DefaultOtherSource;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.source.TestSource;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@NullMarked
public class JUnitTestEventAdapter
extends RunListener {
    private static final List<TestFailureMapper> MAPPERS;
    private static final DefaultThrowableToTestFailureMapper FAILURE_MAPPER;
    private static final Pattern DESCRIPTOR_PATTERN;
    private final IdGenerator<?> idGenerator;
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final Object lock = new Object();
    private volatile @Nullable PostRunStartData postRunStartData;
    private final Deque<Description> activeParents = new ConcurrentLinkedDeque<Description>();
    private final Map<Description, TestDescriptorInternal> executing = new HashMap<Description, TestDescriptorInternal>();
    private final Set<Description> assumptionFailed = new HashSet<Description>();
    private volatile boolean testsStarted = false;
    private volatile @Nullable String rootName;
    private static final @Nullable Method DESCRIPTION_GET_TEST_CLASS;

    public JUnitTestEventAdapter(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator) {
        this.resultProcessor = resultProcessor;
        this.clock = clock;
        this.idGenerator = idGenerator;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    private PostRunStartData requirePostRunStartData() {
        PostRunStartData data = this.postRunStartData;
        if (data == null) {
            throw new AssertionError((Object)"testRunStarted was not called before test events");
        }
        return data;
    }

    private @Nullable TestNode getParentOf(Description description) {
        return this.requirePostRunStartData().childDescToParentNode.get(description);
    }

    private Object startRequiredParentIfNeeded(Description description) {
        Object parentId = this.startParentIfNeeded(description);
        if (parentId == null) {
            throw new AssertionError((Object)("No parent found for " + description));
        }
        return parentId;
    }

    private @Nullable Object startParentIfNeeded(Description description) {
        TestNode parent = this.getParentOf(description);
        if (parent == null) {
            return null;
        }
        this.startParentByNodeIfNeeded(parent, this.clock.getCurrentTime());
        return parent.resolveId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startParentByNodeIfNeeded(TestNode parent, long now) {
        String rootName;
        Object grandparentId = this.startParentIfNeeded(parent.description);
        Object object = this.lock;
        synchronized (object) {
            if (this.activeParents.contains(parent.description)) {
                return;
            }
            this.activeParents.addLast(parent.description);
        }
        String string = rootName = grandparentId == null ? this.rootName : JUnitTestEventAdapter.className(parent.description);
        if (rootName == null) {
            throw new AssertionError((Object)("No class name found for " + parent.description));
        }
        Object parentDescriptor = grandparentId != null && JUnitTestEventAdapter.supportsTestClassMethod() && JUnitTestEventAdapter.getTestClassIfPossible(parent.description) == null ? new DefaultTestSuiteDescriptor(parent.resolveId(), rootName) : new DefaultTestClassDescriptor(parent.resolveId(), rootName, JUnitTestEventAdapter.classDisplayName(rootName));
        this.resultProcessor.started((TestDescriptorInternal)parentDescriptor, new TestStartEvent(now, grandparentId));
    }

    public void testSuiteStarted(Description description) {
        this.testsStarted = true;
        TestNode testNode = this.requirePostRunStartData().descToNode.get(description);
        if (testNode != null) {
            this.startParentByNodeIfNeeded(testNode, this.clock.getCurrentTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSuiteFinished(Description description) {
        TestNode testNode = this.requirePostRunStartData().descToNode.get(description);
        if (testNode == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.activeParents.remove(description)) {
                this.resultProcessor.completed(testNode.resolveId(), new TestCompleteEvent(this.clock.getCurrentTime()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(Description description) {
        this.testsStarted = true;
        Object parentId = this.startRequiredParentIfNeeded(description);
        TestDescriptorInternal descriptor = JUnitTestEventAdapter.nullSafeDescriptor(this.idGenerator.generateId(), description);
        Object object = this.lock;
        synchronized (object) {
            TestDescriptorInternal oldTest = this.executing.put(description, descriptor);
            assert (oldTest == null) : String.format("Unexpected start event for %s", description);
        }
        this.resultProcessor.started(descriptor, this.startEvent(parentId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) {
        TestDescriptorInternal testInternal;
        Object object = this.lock;
        synchronized (object) {
            testInternal = this.executing.get(failure.getDescription());
        }
        if (testInternal != null) {
            Throwable exception = failure.getException();
            this.reportFailure(testInternal.getId(), exception);
        } else {
            this.withPotentiallyMissingParent(JUnitTestEventAdapter.className(failure.getDescription()), this.clock.getCurrentTime(), parentId -> {
                TestDescriptorInternal child = JUnitTestEventAdapter.nullSafeDescriptor(this.idGenerator.generateId(), failure.getDescription());
                this.resultProcessor.started(child, this.startEvent(parentId));
                Throwable exception = failure.getException();
                this.reportFailure(child.getId(), exception);
                this.resultProcessor.completed(child.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
            });
        }
    }

    private void withPotentiallyMissingParent(String parentClassName, long now, Consumer<Object> action) {
        TestNode parent = this.startParentMatchingClassName(parentClassName, now);
        Object syntheticParentId = null;
        if (parent == null) {
            syntheticParentId = this.idGenerator.generateId();
            DefaultTestClassDescriptor syntheticParent = new DefaultTestClassDescriptor(syntheticParentId, parentClassName);
            this.resultProcessor.started((TestDescriptorInternal)syntheticParent, new TestStartEvent(now));
        }
        action.accept(parent != null ? parent.resolveId() : syntheticParentId);
        if (syntheticParentId != null) {
            this.resultProcessor.completed(syntheticParentId, new TestCompleteEvent(now));
        }
    }

    private @Nullable TestNode startParentMatchingClassName(String className, long now) {
        TestNode parent = null;
        for (Map.Entry<Description, TestNode> entry : this.requirePostRunStartData().descToNode.entrySet()) {
            if (!className.equals(JUnitTestEventAdapter.className(entry.getKey()))) continue;
            parent = entry.getValue();
            this.startParentByNodeIfNeeded(entry.getValue(), now);
        }
        return parent;
    }

    private void reportFailure(Object descriptorId, Throwable throwable) {
        TestFailure failure = FAILURE_MAPPER.createFailure(throwable);
        this.resultProcessor.failure(descriptorId, failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        TestDescriptorInternal testInternal;
        Object object = this.lock;
        synchronized (object) {
            testInternal = this.executing.get(failure.getDescription());
            this.assumptionFailed.add(failure.getDescription());
        }
        if (testInternal != null) {
            Throwable exception = failure.getException();
            this.reportAssumptionFailure(testInternal.getId(), exception);
        } else {
            this.withPotentiallyMissingParent(JUnitTestEventAdapter.className(failure.getDescription()), this.clock.getCurrentTime(), parentId -> {
                TestDescriptorInternal child = JUnitTestEventAdapter.nullSafeDescriptor(this.idGenerator.generateId(), failure.getDescription());
                this.resultProcessor.started(child, this.startEvent(parentId));
                Throwable exception = failure.getException();
                this.reportAssumptionFailure(child.getId(), exception);
                this.resultProcessor.completed(child.getId(), new TestCompleteEvent(this.clock.getCurrentTime(), TestResult.ResultType.SKIPPED));
            });
        }
    }

    private void reportAssumptionFailure(Object descriptorId, Throwable throwable) {
        TestFailure assumptionFailure = DefaultTestFailure.fromTestAssumptionFailure((Throwable)throwable);
        this.resultProcessor.failure(descriptorId, assumptionFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecutionFailure(ClassTestDefinition testClassDefinition, TestFailure failure) {
        try {
            long now = this.clock.getCurrentTime();
            if (this.executing.isEmpty()) {
                String testName = this.testsStarted ? "executionError" : "initializationError";
                this.withPotentiallyMissingParent(testClassDefinition.getTestClassName(), now, parentId -> {
                    DefaultTestDescriptor initializationError = new DefaultTestDescriptor(this.idGenerator.generateId(), testClassDefinition.getTestClassName(), testName);
                    this.resultProcessor.started((TestDescriptorInternal)initializationError, new TestStartEvent(now, parentId));
                    this.resultProcessor.failure(initializationError.getId(), failure);
                    this.resultProcessor.completed(initializationError.getId(), new TestCompleteEvent(now));
                });
            } else {
                for (Map.Entry<Description, TestDescriptorInternal> test : this.executing.entrySet()) {
                    this.resultProcessor.failure(test.getValue().getId(), failure);
                    this.resultProcessor.completed(test.getValue().getId(), new TestCompleteEvent(now));
                }
            }
        }
        finally {
            this.handleRunFinished();
        }
    }

    public void testIgnored(Description description) throws Exception {
        if (JUnitTestEventAdapter.methodName(description) == null) {
            this.processIgnoredClass(description);
        } else {
            Object parentId = this.startRequiredParentIfNeeded(description);
            TestDescriptorInternal descriptor = JUnitTestEventAdapter.descriptor(this.idGenerator.generateId(), description);
            this.resultProcessor.started(descriptor, this.startEvent(parentId));
            long endTime = this.clock.getCurrentTime();
            this.resultProcessor.completed(descriptor.getId(), new TestCompleteEvent(endTime, TestResult.ResultType.SKIPPED));
        }
    }

    private void processIgnoredClass(Description description) {
        TestNode classNode = this.requirePostRunStartData().descToNode.get(description);
        if (classNode == null) {
            throw new AssertionError((Object)("No class node found for " + description));
        }
        this.startParentByNodeIfNeeded(classNode, this.clock.getCurrentTime());
        String className = JUnitTestEventAdapter.className(description);
        for (Description childDescription : IgnoredTestDescriptorProvider.getAllDescriptions(description, className)) {
            Object parentId = classNode.resolveId();
            TestDescriptorInternal descriptor = JUnitTestEventAdapter.descriptor(this.idGenerator.generateId(), childDescription);
            this.resultProcessor.started(descriptor, this.startEvent(parentId));
            this.resultProcessor.completed(descriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime(), TestResult.ResultType.SKIPPED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) {
        TestResult.ResultType resultType;
        TestDescriptorInternal testInternal;
        long endTime = this.clock.getCurrentTime();
        Object object = this.lock;
        synchronized (object) {
            testInternal = this.executing.remove(description);
            if (testInternal == null && this.executing.size() == 1) {
                testInternal = this.executing.values().iterator().next();
                this.executing.clear();
            }
            assert (testInternal != null) : String.format("Unexpected end event for %s", description);
            resultType = this.assumptionFailed.remove(description) ? TestResult.ResultType.SKIPPED : null;
        }
        this.resultProcessor.completed(testInternal.getId(), new TestCompleteEvent(endTime, resultType));
    }

    private static TestDescriptorInternal descriptor(Object id, Description description) {
        String className = JUnitTestEventAdapter.className(description);
        String methodName = JUnitTestEventAdapter.methodName(description);
        Object source = className != null && methodName != null ? new DefaultMethodSource(className, methodName) : (className != null && methodName == null ? new DefaultClassSource(className) : DefaultOtherSource.getInstance());
        return new DefaultTestDescriptor(id, className, methodName, (TestSource)source);
    }

    private static TestDescriptorInternal nullSafeDescriptor(Object id, Description description) {
        String methodName = JUnitTestEventAdapter.methodName(description);
        String className = JUnitTestEventAdapter.className(description);
        if (methodName != null) {
            return new DefaultTestDescriptor(id, className, methodName, (TestSource)new DefaultMethodSource(className, methodName));
        }
        return new DefaultTestDescriptor(id, className, "classMethod", (TestSource)new DefaultMethodSource(className, "classMethod"));
    }

    private static boolean supportsTestClassMethod() {
        return DESCRIPTION_GET_TEST_CLASS != null;
    }

    private static @Nullable Class<?> getTestClassIfPossible(Description description) {
        if (!JUnitTestEventAdapter.supportsTestClassMethod()) {
            return null;
        }
        try {
            return (Class)DESCRIPTION_GET_TEST_CLASS.invoke((Object)description, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Should always have access to getTestClass when present", e);
        }
    }

    public static @Nullable String methodName(Description description) {
        return JUnitTestEventAdapter.methodName(description.toString());
    }

    public static @Nullable String methodName(String description) {
        Matcher matcher = JUnitTestEventAdapter.methodStringMatcher(description);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String className(Description description) {
        return JUnitTestEventAdapter.className(description.toString());
    }

    public static String className(String description) {
        Matcher matcher = JUnitTestEventAdapter.methodStringMatcher(description);
        return matcher.matches() ? matcher.group(2) : description;
    }

    private static String classDisplayName(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            return className.substring(lastDot + 1);
        }
        return className;
    }

    private static Matcher methodStringMatcher(String description) {
        return DESCRIPTOR_PATTERN.matcher(description);
    }

    private TestStartEvent startEvent(@Nullable Object parentId) {
        return new TestStartEvent(this.clock.getCurrentTime(), parentId);
    }

    public void testRunStarted(Description description) {
        HashMap<Description, TestNode> descToNode = new HashMap<Description, TestNode>();
        HashMap<Description, TestNode> childDescToParentNode = new HashMap<Description, TestNode>();
        this.addParentIds(description, descToNode, childDescToParentNode);
        this.postRunStartData = new PostRunStartData(Collections.unmodifiableMap(descToNode), Collections.unmodifiableMap(childDescToParentNode));
        this.startParentByNodeIfNeeded(Objects.requireNonNull((TestNode)descToNode.get(description)), this.clock.getCurrentTime());
    }

    private void addParentIds(Description description, Map<Description, TestNode> descToNode, Map<Description, TestNode> childDescToParentNode) {
        TestNode thisNode = new TestNode(this.idGenerator, description);
        descToNode.put(description, thisNode);
        for (Description child : description.getChildren()) {
            childDescToParentNode.put(child, thisNode);
            if (JUnitTestEventAdapter.methodName(child) != null) continue;
            this.addParentIds(child, descToNode, childDescToParentNode);
        }
    }

    public void testRunFinished(Result result) {
        this.handleRunFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRunFinished() {
        Object object = this.lock;
        synchronized (object) {
            Description parent;
            long now = this.clock.getCurrentTime();
            PostRunStartData postRunStartData = this.requirePostRunStartData();
            while ((parent = this.activeParents.pollLast()) != null) {
                Object parentId = Objects.requireNonNull(postRunStartData.descToNode.get(parent)).resolveId();
                this.resultProcessor.completed(parentId, new TestCompleteEvent(now));
            }
            this.executing.clear();
            this.assumptionFailed.clear();
        }
    }

    static {
        Method getTestClass;
        MAPPERS = Arrays.asList(new JUnitComparisonTestFailureMapper(), new OpenTestAssertionFailedMapper(), new OpenTestMultipleFailuresErrorMapper(), new AssertjMultipleAssertionsErrorMapper(), new AssertErrorMapper());
        FAILURE_MAPPER = new DefaultThrowableToTestFailureMapper(MAPPERS);
        DESCRIPTOR_PATTERN = Pattern.compile("(.*)\\((.*)\\)(\\[\\d+])?", 32);
        try {
            getTestClass = Description.class.getDeclaredMethod("getTestClass", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getTestClass = null;
        }
        DESCRIPTION_GET_TEST_CLASS = getTestClass;
    }

    private static final class PostRunStartData {
        final Map<Description, TestNode> descToNode;
        final Map<Description, TestNode> childDescToParentNode;

        PostRunStartData(Map<Description, TestNode> descToNode, Map<Description, TestNode> childDescToParentNode) {
            this.descToNode = descToNode;
            this.childDescToParentNode = childDescToParentNode;
        }
    }

    private static final class TestNode {
        private final IdGenerator<?> idGenerator;
        private volatile @Nullable Object resolvedId;
        final Description description;

        TestNode(IdGenerator<?> idGenerator, Description description) {
            this.idGenerator = idGenerator;
            this.description = description;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object resolveId() {
            Object localId = this.resolvedId;
            if (localId == null) {
                TestNode testNode = this;
                synchronized (testNode) {
                    localId = this.resolvedId;
                    if (localId == null) {
                        this.resolvedId = localId = this.idGenerator.generateId();
                    }
                }
            }
            return localId;
        }
    }
}

