/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.AssertionFailureDetails;
import org.gradle.api.internal.tasks.testing.AssumptionFailureDetails;
import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.DefaultNestedTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultParameterizedTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.DefaultTestFailureDetails;
import org.gradle.api.internal.tasks.testing.DefaultTestFileAttachmentDataEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestKeyValueDataEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestMethodDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.DirectoryBasedTestDefinition;
import org.gradle.api.internal.tasks.testing.FileComparisonFailureDetails;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestFailureSerializationException;
import org.gradle.api.internal.tasks.testing.TestMetadataEvent;
import org.gradle.api.internal.tasks.testing.TestSources;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.worker.WorkerTestDefinitionProcessor;
import org.gradle.api.tasks.testing.SingleFileSource;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestFailureDetails;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.TestSource;
import org.gradle.api.tasks.testing.UnknownSource;
import org.gradle.internal.id.CompositeIdGenerator;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class TestEventSerializer {
    public static SerializerRegistry create() {
        BaseSerializerFactory factory = new BaseSerializerFactory();
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(ClassTestDefinition.class, (Serializer)new ClassTestDefinitionSerializer());
        registry.register(DirectoryBasedTestDefinition.class, (Serializer)new DirectoryBasedTestDefinitionSerializer());
        registry.register(CompositeIdGenerator.CompositeId.class, (Serializer)new IdSerializer());
        registry.register(DefaultNestedTestSuiteDescriptor.class, (Serializer)new DefaultNestedTestSuiteDescriptorSerializer());
        registry.register(DefaultParameterizedTestDescriptor.class, (Serializer)new DefaultParameterizedTestDescriptorSerializer());
        registry.register(DefaultTestSuiteDescriptor.class, (Serializer)new DefaultTestSuiteDescriptorSerializer());
        registry.register(WorkerTestDefinitionProcessor.WorkerTestSuiteDescriptor.class, (Serializer)new WorkerTestSuiteDescriptorSerializer());
        registry.register(DefaultTestClassDescriptor.class, (Serializer)new DefaultTestClassDescriptorSerializer());
        registry.register(DefaultTestMethodDescriptor.class, (Serializer)new DefaultTestMethodDescriptorSerializer());
        registry.register(DefaultTestDescriptor.class, (Serializer)new DefaultTestDescriptorSerializer());
        registry.register(TestStartEvent.class, (Serializer)new TestStartEventSerializer());
        registry.register(TestCompleteEvent.class, (Serializer)new TestCompleteEventSerializer(factory));
        registry.register(DefaultTestOutputEvent.class, (Serializer)new DefaultTestOutputEventSerializer(factory));
        registry.register(TestMetadataEvent.class, (Serializer)new TestMetadataEventSerializer());
        Serializer throwableSerializer = factory.getSerializerFor(Throwable.class);
        registry.register(Throwable.class, throwableSerializer);
        registry.register(TestFailure.class, (Serializer)new DefaultTestFailureSerializer((Serializer<Throwable>)throwableSerializer));
        return registry;
    }

    private static class ClassTestDefinitionSerializer
    implements Serializer<ClassTestDefinition> {
        private ClassTestDefinitionSerializer() {
        }

        public ClassTestDefinition read(Decoder decoder) throws Exception {
            return new ClassTestDefinition(decoder.readString());
        }

        public void write(Encoder encoder, ClassTestDefinition value) throws Exception {
            encoder.writeString((CharSequence)value.getId());
        }
    }

    @NullMarked
    private static class DirectoryBasedTestDefinitionSerializer
    implements Serializer<DirectoryBasedTestDefinition> {
        private DirectoryBasedTestDefinitionSerializer() {
        }

        public DirectoryBasedTestDefinition read(Decoder decoder) throws Exception {
            return new DirectoryBasedTestDefinition(new File(decoder.readString()));
        }

        public void write(Encoder encoder, DirectoryBasedTestDefinition value) throws Exception {
            encoder.writeString((CharSequence)value.getTestDefinitionsDir().getAbsolutePath());
        }
    }

    private static class IdSerializer
    implements Serializer<CompositeIdGenerator.CompositeId> {
        private IdSerializer() {
        }

        public CompositeIdGenerator.CompositeId read(Decoder decoder) throws Exception {
            return new CompositeIdGenerator.CompositeId((Object)decoder.readLong(), (Object)decoder.readLong());
        }

        public void write(Encoder encoder, CompositeIdGenerator.CompositeId value) throws Exception {
            encoder.writeLong(((Long)value.getScope()).longValue());
            encoder.writeLong(((Long)value.getId()).longValue());
        }
    }

    private static class DefaultNestedTestSuiteDescriptorSerializer
    implements Serializer<DefaultNestedTestSuiteDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultNestedTestSuiteDescriptorSerializer() {
        }

        public DefaultNestedTestSuiteDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            String displayName = decoder.readString();
            CompositeIdGenerator.CompositeId parentId = (CompositeIdGenerator.CompositeId)this.idSerializer.read(decoder);
            return new DefaultNestedTestSuiteDescriptor(id, name, displayName, parentId);
        }

        public void write(Encoder encoder, DefaultNestedTestSuiteDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
            encoder.writeString((CharSequence)value.getDisplayName());
            this.idSerializer.write(encoder, (Object)value.getParentId());
        }
    }

    @NullMarked
    private static class DefaultParameterizedTestDescriptorSerializer
    implements Serializer<DefaultParameterizedTestDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultParameterizedTestDescriptorSerializer() {
        }

        public DefaultParameterizedTestDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            String className = decoder.readNullableString();
            String displayName = decoder.readString();
            CompositeIdGenerator.CompositeId parentId = (CompositeIdGenerator.CompositeId)this.idSerializer.read(decoder);
            return new DefaultParameterizedTestDescriptor(id, name, className, displayName, parentId);
        }

        public void write(Encoder encoder, DefaultParameterizedTestDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
            encoder.writeNullableString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getDisplayName());
            this.idSerializer.write(encoder, (Object)value.getParentId());
        }
    }

    private static class DefaultTestSuiteDescriptorSerializer
    implements Serializer<DefaultTestSuiteDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestSuiteDescriptorSerializer() {
        }

        public DefaultTestSuiteDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            return new DefaultTestSuiteDescriptor(id, name);
        }

        public void write(Encoder encoder, DefaultTestSuiteDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
        }
    }

    private static class WorkerTestSuiteDescriptorSerializer
    implements Serializer<WorkerTestDefinitionProcessor.WorkerTestSuiteDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private WorkerTestSuiteDescriptorSerializer() {
        }

        public WorkerTestDefinitionProcessor.WorkerTestSuiteDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            return new WorkerTestDefinitionProcessor.WorkerTestSuiteDescriptor(id, name);
        }

        public void write(Encoder encoder, WorkerTestDefinitionProcessor.WorkerTestSuiteDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
        }
    }

    private static class DefaultTestClassDescriptorSerializer
    implements Serializer<DefaultTestClassDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestClassDescriptorSerializer() {
        }

        public DefaultTestClassDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            String displayName = decoder.readString();
            return new DefaultTestClassDescriptor(id, name, displayName);
        }

        public void write(Encoder encoder, DefaultTestClassDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
            encoder.writeString((CharSequence)value.getDisplayName());
        }
    }

    private static class DefaultTestMethodDescriptorSerializer
    implements Serializer<DefaultTestMethodDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestMethodDescriptorSerializer() {
        }

        public DefaultTestMethodDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String className = decoder.readString();
            String name = decoder.readString();
            return new DefaultTestMethodDescriptor(id, className, name);
        }

        public void write(Encoder encoder, DefaultTestMethodDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getName());
        }
    }

    private static class DefaultTestDescriptorSerializer
    implements Serializer<DefaultTestDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();
        final Serializer<TestSource> testSourceSerializer = new TestSourceSerializer();

        private DefaultTestDescriptorSerializer() {
        }

        public DefaultTestDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String className = decoder.readString();
            String classDisplayName = decoder.readString();
            String name = decoder.readString();
            String displayName = decoder.readString();
            TestSource source = (TestSource)this.testSourceSerializer.read(decoder);
            boolean isKnownClass = decoder.readBoolean();
            return new DefaultTestDescriptor(id, className, name, classDisplayName, displayName, source, isKnownClass);
        }

        public void write(Encoder encoder, DefaultTestDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getClassDisplayName());
            encoder.writeString((CharSequence)value.getName());
            encoder.writeString((CharSequence)value.getDisplayName());
            this.testSourceSerializer.write(encoder, (Object)value.getSource());
            encoder.writeBoolean(value.isKnownClass());
        }
    }

    private static class TestStartEventSerializer
    implements Serializer<TestStartEvent> {
        final NullableSerializer<CompositeIdGenerator.CompositeId> idSerializer = new NullableSerializer(new IdSerializer());

        private TestStartEventSerializer() {
        }

        public TestStartEvent read(Decoder decoder) throws Exception {
            long time = decoder.readLong();
            CompositeIdGenerator.CompositeId id = this.idSerializer.read(decoder);
            return new TestStartEvent(time, id);
        }

        public void write(Encoder encoder, TestStartEvent value) throws Exception {
            encoder.writeLong(value.getStartTime());
            this.idSerializer.write(encoder, (CompositeIdGenerator.CompositeId)value.getParentId());
        }
    }

    private static class TestCompleteEventSerializer
    implements Serializer<TestCompleteEvent> {
        private final NullableSerializer<TestResult.ResultType> typeSerializer;

        TestCompleteEventSerializer(BaseSerializerFactory factory) {
            this.typeSerializer = new NullableSerializer(factory.getSerializerFor(TestResult.ResultType.class));
        }

        public TestCompleteEvent read(Decoder decoder) throws Exception {
            long endTime = decoder.readLong();
            TestResult.ResultType result = this.typeSerializer.read(decoder);
            return new TestCompleteEvent(endTime, result);
        }

        public void write(Encoder encoder, TestCompleteEvent value) throws Exception {
            encoder.writeLong(value.getEndTime());
            this.typeSerializer.write(encoder, value.getResultType());
        }
    }

    private static class DefaultTestOutputEventSerializer
    implements Serializer<DefaultTestOutputEvent> {
        private final Serializer<TestOutputEvent.Destination> destinationSerializer;

        DefaultTestOutputEventSerializer(BaseSerializerFactory factory) {
            this.destinationSerializer = factory.getSerializerFor(TestOutputEvent.Destination.class);
        }

        public DefaultTestOutputEvent read(Decoder decoder) throws Exception {
            long logTime = decoder.readLong();
            TestOutputEvent.Destination destination = (TestOutputEvent.Destination)((Object)this.destinationSerializer.read(decoder));
            String message = decoder.readString();
            return new DefaultTestOutputEvent(logTime, destination, message);
        }

        public void write(Encoder encoder, DefaultTestOutputEvent value) throws Exception {
            encoder.writeLong(value.getLogTime());
            this.destinationSerializer.write(encoder, (Object)value.getDestination());
            encoder.writeString((CharSequence)value.getMessage());
        }
    }

    @NullMarked
    private static class TestMetadataEventSerializer
    implements Serializer<TestMetadataEvent> {
        private final MapSerializer<String, String> mapSerializer = new MapSerializer(BaseSerializerFactory.STRING_SERIALIZER, BaseSerializerFactory.STRING_SERIALIZER);
        private final Serializer<Path> pathSerializer = BaseSerializerFactory.PATH_SERIALIZER;
        private static final int MAP_TYPE = 0;
        private static final int FILE_ATTACHMENT_TYPE = 1;

        private TestMetadataEventSerializer() {
        }

        public TestMetadataEvent read(Decoder decoder) throws Exception {
            Instant logTime = Instant.ofEpochMilli(decoder.readLong());
            int type = decoder.readInt();
            switch (type) {
                case 0: {
                    Map keyValues = this.mapSerializer.read(decoder);
                    return new DefaultTestKeyValueDataEvent(logTime, keyValues);
                }
                case 1: {
                    return new DefaultTestFileAttachmentDataEvent(logTime, (Path)this.pathSerializer.read(decoder), decoder.readNullableString());
                }
            }
            throw new IllegalStateException("Unknown type of test metadata: " + type);
        }

        public void write(Encoder encoder, TestMetadataEvent value) throws Exception {
            encoder.writeLong(value.getLogTime().toEpochMilli());
            if (value instanceof DefaultTestKeyValueDataEvent) {
                encoder.writeInt(0);
                this.mapSerializer.write(encoder, ((DefaultTestKeyValueDataEvent)value).getValues());
            } else if (value instanceof DefaultTestFileAttachmentDataEvent) {
                encoder.writeInt(1);
                this.pathSerializer.write(encoder, (Object)((DefaultTestFileAttachmentDataEvent)value).getPath());
                encoder.writeNullableString((CharSequence)((DefaultTestFileAttachmentDataEvent)value).getMediaType());
            }
        }
    }

    @NullMarked
    private static class DefaultTestFailureSerializer
    implements Serializer<TestFailure> {
        private final Serializer<Throwable> throwableSerializer;

        public DefaultTestFailureSerializer(Serializer<Throwable> throwableSerializer) {
            this.throwableSerializer = throwableSerializer;
        }

        public TestFailure read(Decoder decoder) throws Exception {
            byte[] actualContent;
            byte[] expectedContent;
            Throwable rawFailure = this.readThrowableCatchingFailure(decoder);
            int numOfCauses = decoder.readSmallInt();
            ArrayList<TestFailure> causes = new ArrayList<TestFailure>(numOfCauses);
            for (int i = 0; i < numOfCauses; ++i) {
                causes.add(this.read(decoder));
            }
            String message = decoder.readNullableString();
            String className = decoder.readString();
            String stacktrace = decoder.readString();
            boolean isAssumptionFailure = decoder.readBoolean();
            boolean isAssertionFailure = decoder.readBoolean();
            String expected = decoder.readNullableString();
            String actual = decoder.readNullableString();
            boolean isFileComparisonFailure = decoder.readBoolean();
            int expectedContentSize = decoder.readInt();
            if (expectedContentSize == -1) {
                expectedContent = null;
            } else {
                expectedContent = new byte[expectedContentSize];
                decoder.readBytes(expectedContent);
            }
            int actualContentSize = decoder.readInt();
            if (actualContentSize == -1) {
                actualContent = null;
            } else {
                actualContent = new byte[actualContentSize];
                decoder.readBytes(actualContent);
            }
            DefaultTestFailureDetails details = isFileComparisonFailure ? new FileComparisonFailureDetails(message, className, stacktrace, expected, actual, expectedContent, actualContent) : (isAssertionFailure ? new AssertionFailureDetails(message, className, stacktrace, expected, actual) : (isAssumptionFailure ? new AssumptionFailureDetails(message, className, stacktrace) : (rawFailure instanceof TestFailureSerializationException ? new DefaultTestFailureDetails(rawFailure.getMessage(), rawFailure.getClass().getName(), Throwables.getStackTraceAsString((Throwable)rawFailure)) : new DefaultTestFailureDetails(message, className, stacktrace))));
            return new DefaultTestFailure(rawFailure, details, causes);
        }

        private Throwable readThrowableCatchingFailure(Decoder decoder) throws IOException {
            Object rawFailure;
            String rawFailureName = decoder.readString();
            try {
                rawFailure = (Throwable)this.throwableSerializer.read(decoder);
            }
            catch (Exception e) {
                rawFailure = new TestFailureSerializationException("An exception of type " + rawFailureName + " was thrown by the test, but Gradle was unable to recreate the exception in the build process", e);
            }
            return rawFailure;
        }

        public void write(Encoder encoder, TestFailure value) throws Exception {
            this.writeThrowableWithType(encoder, value, value.getRawFailure());
            encoder.writeSmallInt(value.getCauses().size());
            for (TestFailure cause : value.getCauses()) {
                this.write(encoder, cause);
            }
            TestFailureDetails details = value.getDetails();
            encoder.writeNullableString((CharSequence)details.getMessage());
            encoder.writeString((CharSequence)details.getClassName());
            encoder.writeString((CharSequence)details.getStacktrace());
            encoder.writeBoolean(details.isAssumptionFailure());
            encoder.writeBoolean(details.isAssertionFailure());
            encoder.writeNullableString((CharSequence)details.getExpected());
            encoder.writeNullableString((CharSequence)details.getActual());
            encoder.writeBoolean(details.isFileComparisonFailure());
            byte[] expectedContent = details.getExpectedContent();
            if (expectedContent == null) {
                encoder.writeInt(-1);
            } else {
                encoder.writeInt(expectedContent.length);
                encoder.writeBytes(expectedContent);
            }
            byte[] actualContent = details.getActualContent();
            if (actualContent == null) {
                encoder.writeInt(-1);
            } else {
                encoder.writeInt(actualContent.length);
                encoder.writeBytes(actualContent);
            }
        }

        private void writeThrowableWithType(Encoder encoder, TestFailure value, Throwable rawFailure) throws Exception {
            encoder.writeString((CharSequence)rawFailure.getClass().getName());
            this.throwableSerializer.write(encoder, (Object)value.getRawFailure());
        }
    }

    @NullMarked
    private static class TestSourceSerializer
    implements Serializer<TestSource> {
        private TestSourceSerializer() {
        }

        public TestSource read(Decoder decoder) throws Exception {
            int i = decoder.readSmallInt();
            if (i == 0) {
                return TestSources.unknown();
            }
            if (i == 1) {
                String absolutePath = decoder.readString();
                return TestSources.singleFileSource(new File(absolutePath));
            }
            throw new IllegalArgumentException("Unknown TestSource type id: " + i);
        }

        public void write(Encoder encoder, TestSource value) throws Exception {
            if (value instanceof UnknownSource) {
                encoder.writeSmallInt(0);
            } else if (value instanceof SingleFileSource) {
                encoder.writeSmallInt(1);
                encoder.writeString((CharSequence)((SingleFileSource)value).getFile().getAbsolutePath());
            } else {
                throw new IllegalArgumentException("Unknown TestSource type: " + value.getClass().getName());
            }
        }
    }

    @NullMarked
    private static class NullableSerializer<T>
    implements Serializer<T> {
        private final Serializer<T> serializer;

        private NullableSerializer(Serializer<T> serializer) {
            this.serializer = serializer;
        }

        public @Nullable T read(Decoder decoder) throws Exception {
            if (!decoder.readBoolean()) {
                return null;
            }
            return (T)this.serializer.read(decoder);
        }

        public void write(Encoder encoder, @Nullable T value) throws Exception {
            encoder.writeBoolean(value != null);
            if (value != null) {
                this.serializer.write(encoder, value);
            }
        }
    }
}

