/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import org.gradle.api.internal.tasks.testing.AbstractTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestSources;
import org.gradle.api.tasks.testing.TestSource;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultTestDescriptor
extends AbstractTestDescriptor {
    private final String displayName;
    private final @Nullable String className;
    private final String classDisplayName;
    private final boolean isKnownClass;

    public DefaultTestDescriptor(Object id, @Nullable String className, String name) {
        this(id, className, name, null, name);
    }

    public DefaultTestDescriptor(Object id, @Nullable String className, String name, @Nullable String classDisplayName, String displayName) {
        this(id, className, name, classDisplayName, displayName, TestSources.unknown(), true);
    }

    public DefaultTestDescriptor(Object id, @Nullable String className, String name, @Nullable String classDisplayName, String displayName, TestSource source, boolean isKnownClass) {
        super(id, name, source);
        this.className = className;
        this.classDisplayName = classDisplayName == null ? className : classDisplayName;
        this.displayName = displayName;
        this.isKnownClass = isKnownClass;
    }

    public String toString() {
        return "Test " + this.getName() + (this.className == null || !this.isKnownClass ? "" : "(" + this.className + ")");
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public @Nullable String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.getName();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getClassDisplayName() {
        return this.classDisplayName;
    }

    public boolean isKnownClass() {
        return this.isKnownClass;
    }
}

