/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.testing.AbstractTestDescriptor;
import org.gradle.api.internal.tasks.testing.DecoratingTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultParameterizedTestDescriptor;
import org.gradle.api.internal.tasks.testing.operations.ExecuteTestBuildOperationType;
import org.gradle.api.tasks.testing.SingleFileSource;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.TestSource;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.types.AbstractTestResult;
import org.gradle.internal.build.event.types.DefaultClassBasedTestDescriptor;
import org.gradle.internal.build.event.types.DefaultFileComparisonTestAssertionFailure;
import org.gradle.internal.build.event.types.DefaultSingleFileResourceBasedTestDescriptor;
import org.gradle.internal.build.event.types.DefaultTestAssertionFailure;
import org.gradle.internal.build.event.types.DefaultTestFailureResult;
import org.gradle.internal.build.event.types.DefaultTestFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTestFrameworkFailure;
import org.gradle.internal.build.event.types.DefaultTestSkippedResult;
import org.gradle.internal.build.event.types.DefaultTestStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTestSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.InternalFailure;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.provider.runner.BuildOperationMapper;
import org.gradle.tooling.internal.provider.runner.BuildOperationTracker;
import org.gradle.tooling.internal.provider.runner.TaskForTestEventTracker;
import org.jspecify.annotations.Nullable;

class TestOperationMapper
implements BuildOperationMapper<ExecuteTestBuildOperationType.Details, InternalTestDescriptor> {
    private final TaskForTestEventTracker taskTracker;

    TestOperationMapper(TaskForTestEventTracker taskTracker) {
        this.taskTracker = taskTracker;
    }

    @Override
    public boolean isEnabled(BuildEventSubscriptions subscriptions) {
        return subscriptions.isRequested(OperationType.TEST);
    }

    @Override
    public Class<ExecuteTestBuildOperationType.Details> getDetailsType() {
        return ExecuteTestBuildOperationType.Details.class;
    }

    @Override
    public List<? extends BuildOperationTracker> getTrackers() {
        return ImmutableList.of((Object)this.taskTracker);
    }

    @Override
    public InternalTestDescriptor createDescriptor(ExecuteTestBuildOperationType.Details details, BuildOperationDescriptor buildOperation, @Nullable OperationIdentifier parent) {
        TestDescriptor testDescriptor = details.getTestDescriptor();
        return testDescriptor.isComposite() ? this.toTestDescriptorForSuite(buildOperation.getId(), parent, testDescriptor) : this.toTestDescriptorForTest(buildOperation.getId(), parent, testDescriptor);
    }

    @Override
    public InternalOperationStartedProgressEvent createStartedEvent(InternalTestDescriptor descriptor, ExecuteTestBuildOperationType.Details details, OperationStartEvent startEvent) {
        return new DefaultTestStartedProgressEvent(details.getStartTime(), descriptor);
    }

    @Override
    public InternalOperationFinishedProgressEvent createFinishedEvent(InternalTestDescriptor descriptor, ExecuteTestBuildOperationType.Details details, OperationFinishEvent finishEvent) {
        TestResult testResult = ((ExecuteTestBuildOperationType.Result)finishEvent.getResult()).getResult();
        return new DefaultTestFinishedProgressEvent(testResult.getEndTime(), descriptor, TestOperationMapper.adapt(testResult));
    }

    private InternalTestDescriptor toTestDescriptorForSuite(OperationIdentifier buildOperationId, OperationIdentifier parentId, TestDescriptor suite) {
        String methodName = null;
        String operationDisplayName = suite.toString();
        TestDescriptor originalDescriptor = TestOperationMapper.getOriginalDescriptor(suite);
        if (originalDescriptor instanceof AbstractTestDescriptor) {
            methodName = ((AbstractTestDescriptor)originalDescriptor).getMethodName();
            operationDisplayName = this.adjustOperationDisplayNameForIntelliJ(operationDisplayName, (AbstractTestDescriptor)originalDescriptor);
        } else {
            operationDisplayName = TestOperationMapper.getLegacyOperationDisplayName(operationDisplayName, originalDescriptor);
        }
        return new DefaultClassBasedTestDescriptor(buildOperationId, suite.getName(), operationDisplayName, suite.getDisplayName(), "SUITE", suite.getName(), suite.getClassName(), methodName, parentId, this.taskTracker.getTaskPath(buildOperationId));
    }

    private InternalTestDescriptor toTestDescriptorForTest(OperationIdentifier buildOperationId, OperationIdentifier parentId, TestDescriptor test) {
        String operationDisplayName = test.toString();
        TestDescriptor originalDescriptor = TestOperationMapper.getOriginalDescriptor(test);
        operationDisplayName = originalDescriptor instanceof AbstractTestDescriptor ? this.adjustOperationDisplayNameForIntelliJ(operationDisplayName, (AbstractTestDescriptor)originalDescriptor) : TestOperationMapper.getLegacyOperationDisplayName(operationDisplayName, originalDescriptor);
        TestSource source = test.getSource();
        if (source instanceof SingleFileSource) {
            return new DefaultSingleFileResourceBasedTestDescriptor(buildOperationId, test.getName(), operationDisplayName, test.getDisplayName(), parentId, this.taskTracker.getTaskPath(buildOperationId), ((SingleFileSource)source).getFile());
        }
        return new DefaultClassBasedTestDescriptor(buildOperationId, test.getName(), operationDisplayName, test.getDisplayName(), "ATOMIC", null, test.getClassName(), test.getName(), parentId, this.taskTracker.getTaskPath(buildOperationId));
    }

    private String adjustOperationDisplayNameForIntelliJ(String operationDisplayName, AbstractTestDescriptor descriptor) {
        String displayName = descriptor.getDisplayName();
        if (!(descriptor.getName().equals(displayName) || descriptor.getClassDisplayName() != null && descriptor.getName().endsWith(descriptor.getClassDisplayName()))) {
            return descriptor.getDisplayName();
        }
        if (descriptor instanceof DefaultParameterizedTestDescriptor) {
            return descriptor.getDisplayName();
        }
        return operationDisplayName;
    }

    private static String getLegacyOperationDisplayName(String operationDisplayName, TestDescriptor testDescriptor) {
        if (operationDisplayName.endsWith("@" + Integer.toHexString(testDescriptor.hashCode()))) {
            return testDescriptor.getDisplayName();
        }
        return operationDisplayName;
    }

    private static TestDescriptor getOriginalDescriptor(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof DecoratingTestDescriptor) {
            return TestOperationMapper.getOriginalDescriptor((TestDescriptor)((DecoratingTestDescriptor)testDescriptor).getDescriptor());
        }
        return testDescriptor;
    }

    private static AbstractTestResult adapt(TestResult result) {
        TestResult.ResultType resultType = result.getResultType();
        switch (resultType) {
            case SUCCESS: {
                return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
            }
            case SKIPPED: {
                return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
            }
            case FAILURE: {
                return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), TestOperationMapper.convertExceptions(result.getFailures()));
            }
        }
        throw new IllegalStateException("Unknown test result type: " + resultType);
    }

    private static List<InternalFailure> convertExceptions(List<TestFailure> failures) {
        ArrayList<InternalFailure> result = new ArrayList<InternalFailure>(failures.size());
        for (TestFailure failure : failures) {
            if (failure.getDetails().isAssertionFailure()) {
                if (failure.getDetails().isFileComparisonFailure()) {
                    result.add((InternalFailure)DefaultFileComparisonTestAssertionFailure.create((Throwable)failure.getRawFailure(), (String)failure.getDetails().getMessage(), (String)failure.getDetails().getClassName(), (String)failure.getDetails().getStacktrace(), (String)failure.getDetails().getExpected(), (String)failure.getDetails().getActual(), TestOperationMapper.convertExceptions(failure.getCauses()), (byte[])failure.getDetails().getExpectedContent(), (byte[])failure.getDetails().getActualContent()));
                    continue;
                }
                result.add((InternalFailure)DefaultTestAssertionFailure.create((Throwable)failure.getRawFailure(), (String)failure.getDetails().getMessage(), (String)failure.getDetails().getClassName(), (String)failure.getDetails().getStacktrace(), (String)failure.getDetails().getExpected(), (String)failure.getDetails().getActual(), TestOperationMapper.convertExceptions(failure.getCauses())));
                continue;
            }
            result.add((InternalFailure)DefaultTestFrameworkFailure.create((Throwable)failure.getRawFailure(), (String)failure.getDetails().getMessage(), (String)failure.getDetails().getClassName(), (String)failure.getDetails().getStacktrace()));
        }
        return result;
    }
}

