/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.fileevents.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.gradle.fileevents.FileWatchEvent;
import org.gradle.fileevents.internal.AbstractFileEventFunctions;
import org.gradle.fileevents.internal.AbstractNativeFileEventFunctions;

public class LinuxFileEventFunctions
extends AbstractNativeFileEventFunctions<LinuxFileWatcher> {
    public WatcherBuilder newWatcher(BlockingQueue<FileWatchEvent> eventQueue) {
        return new WatcherBuilder(eventQueue);
    }

    private static native Object startWatcher0(AbstractFileEventFunctions.NativeFileWatcherCallback var0);

    public static class WatcherBuilder
    extends AbstractFileEventFunctions.AbstractWatcherBuilder<LinuxFileWatcher> {
        WatcherBuilder(BlockingQueue<FileWatchEvent> eventQueue) {
            super(eventQueue);
        }

        @Override
        protected LinuxFileWatcher createWatcher(AbstractFileEventFunctions.NativeFileWatcherCallback callback) {
            Object server = LinuxFileEventFunctions.startWatcher0(callback);
            return new LinuxFileWatcher(server, callback);
        }
    }

    public static class LinuxFileWatcher
    extends AbstractNativeFileEventFunctions.NativeFileWatcher {
        public LinuxFileWatcher(Object server, AbstractFileEventFunctions.NativeFileWatcherCallback callback) {
            super(server, callback);
        }

        public List<File> stopWatchingMovedPaths(Collection<File> pathsToCheck) {
            String[] absolutePathsToCheck = LinuxFileWatcher.toAbsolutePaths(pathsToCheck);
            ArrayList<String> droppedPathStrings = new ArrayList<String>();
            this.stopWatchingMovedPaths0(this.server, absolutePathsToCheck, droppedPathStrings);
            ArrayList<File> droppedPaths = new ArrayList<File>(droppedPathStrings.size());
            for (String droppedPath : droppedPathStrings) {
                droppedPaths.add(new File(droppedPath));
            }
            return droppedPaths;
        }

        private native void stopWatchingMovedPaths0(Object var1, String[] var2, List<String> var3);
    }
}

