/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.cli.CommandLineParser;
import org.gradle.configuration.DefaultBuildClientMetaData;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.launcher.cli.converter.BuildLayoutConverter;
import org.gradle.launcher.cli.converter.BuildOptionBackedConverter;
import org.gradle.launcher.cli.converter.InitialPropertiesConverter;
import org.gradle.launcher.cli.converter.StartParameterConverter;
import org.gradle.launcher.daemon.configuration.DaemonBuildOptions;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class HelpRenderer {
    private HelpRenderer() {
    }

    public static String render(@Nullable String suggestedTaskSelector, boolean includeHintToExecuteHelpTaskOnProject) {
        return HelpRenderer.render(HelpRenderer.commandLineParser(), suggestedTaskSelector, includeHintToExecuteHelpTaskOnProject);
    }

    public static String render(CommandLineParser parser, @Nullable String suggestedTaskSelector, boolean includeHintToExecuteHelpTaskOnProject) {
        DefaultBuildClientMetaData metaData = new DefaultBuildClientMetaData(new GradleLauncherMetaData());
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        if (includeHintToExecuteHelpTaskOnProject) {
            out.println();
            out.print("To see help contextual to the project, use ");
            metaData.describeCommand((Appendable)out, new String[]{"help"});
            out.println();
        }
        out.println();
        out.print("To see more detail about a task, run ");
        metaData.describeCommand((Appendable)out, new String[]{"help --task <task>"});
        out.println();
        if (suggestedTaskSelector != null && !suggestedTaskSelector.isEmpty()) {
            out.print("For example, ");
            metaData.describeCommand((Appendable)out, new String[]{"help --task " + suggestedTaskSelector});
            out.println();
        }
        out.println();
        out.print("To see a list of available tasks, run ");
        metaData.describeCommand((Appendable)out, new String[]{"tasks"});
        out.println();
        out.println();
        out.print("USAGE: ");
        metaData.describeCommand((Appendable)out, new String[]{"[option...]", "[task...]"});
        out.println();
        out.println();
        parser.printUsage((Appendable)out);
        out.println();
        out.flush();
        return sw.toString();
    }

    private static CommandLineParser commandLineParser() {
        CommandLineParser parser = new CommandLineParser();
        new InitialPropertiesConverter().configure(parser);
        new BuildLayoutConverter().configure(parser);
        new StartParameterConverter().configure(parser);
        new BuildOptionBackedConverter<DaemonParameters>(new DaemonBuildOptions()).configure(parser);
        parser.option(new String[]{"h", "?", "help"}).hasDescription("Shows this help message.");
        parser.option(new String[]{"v", "version"}).hasDescription("Print version info and exit.");
        parser.option(new String[]{"V", "show-version"}).hasDescription("Print version info and continue.");
        return parser;
    }
}

