/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.jspecify.annotations.Nullable;

public class DependencyState {
    private final ComponentSelector requested;
    private final DependencyMetadata dependency;
    private final ImmutableList<ComponentSelectionDescriptorInternal> ruleDescriptors;
    private final @Nullable ModuleVersionResolveException substitutionFailure;
    private @Nullable ModuleIdentifier moduleIdentifier;

    public DependencyState(DependencyMetadata dependency, ComponentSelector requested, ImmutableList<ComponentSelectionDescriptorInternal> ruleDescriptors, @Nullable ModuleVersionResolveException substitutionFailure) {
        this.dependency = dependency;
        this.requested = requested;
        this.ruleDescriptors = ruleDescriptors;
        this.substitutionFailure = substitutionFailure;
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public DependencyMetadata getDependency() {
        return this.dependency;
    }

    public ImmutableList<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
        return this.ruleDescriptors;
    }

    public @Nullable ModuleVersionResolveException getSubstitutionFailure() {
        return this.substitutionFailure;
    }

    public ModuleIdentifier getModuleIdentifier(ComponentSelectorConverter componentSelectorConverter) {
        if (this.moduleIdentifier == null) {
            ComponentSelector componentSelector = this.dependency.getSelector();
            this.moduleIdentifier = componentSelector instanceof ModuleComponentSelector ? ((ModuleComponentSelector)componentSelector).getModuleIdentifier() : componentSelectorConverter.getModuleVersionId(componentSelector).getModule();
        }
        return this.moduleIdentifier;
    }

    public boolean isForced() {
        if (!this.ruleDescriptors.isEmpty()) {
            for (ComponentSelectionDescriptorInternal ruleDescriptor : this.ruleDescriptors) {
                if (!ruleDescriptor.isEquivalentToForce()) continue;
                return true;
            }
        }
        return this.dependency instanceof ForcingDependencyMetadata && ((ForcingDependencyMetadata)this.dependency).isForce();
    }

    public boolean isFromLock() {
        return this.dependency instanceof LocalOriginDependencyMetadata && ((LocalOriginDependencyMetadata)this.dependency).isFromLock();
    }

    public String toString() {
        if (this.requested.equals(this.dependency.getSelector())) {
            return this.dependency.toString();
        }
        return this.dependency + " (requested " + this.requested + ")";
    }
}

