/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0096\u0080\u0004\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\r\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\r\u0010\u001d\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0015\u0010\u0004\u001a\u00020\u0005X\u0096\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/gradle/kotlin/dsl/concurrent/FutureContinuation;", "T", "Ljava/util/concurrent/Future;", "Lkotlin/coroutines/Continuation;", "context", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lkotlin/coroutines/CoroutineContext;)V", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "result", "Lkotlin/Result;", "outcomeLatch", "Ljava/util/concurrent/CountDownLatch;", "resumeWith", "", "(Ljava/lang/Object;)V", "isCancelled", "", "cancel", "mayInterruptIfRunning", "isDone", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getOrThrow", "kotlin-dsl"})
final class FutureContinuation<T>
implements Future<T>,
Continuation<T> {
    @NotNull
    private final CoroutineContext context;
    @Nullable
    private Result<? extends T> result;
    @NotNull
    private final CountDownLatch outcomeLatch;

    public FutureContinuation(@NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.outcomeLatch = new CountDownLatch(1);
    }

    @NotNull
    public CoroutineContext getContext() {
        return this.context;
    }

    public void resumeWith(@NotNull Object result) {
        this.result = Result.box-impl((Object)result);
        this.outcomeLatch.countDown();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    @Override
    public T get() {
        this.outcomeLatch.await();
        return this.getOrThrow();
    }

    @Override
    public T get(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!this.outcomeLatch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.getOrThrow();
    }

    private final T getOrThrow() {
        Object object = this.result.unbox-impl();
        ResultKt.throwOnFailure((Object)object);
        return (T)object;
    }
}

