/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentRejectedMessageBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformGraphResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleSelectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictResolutionDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.internal.Pair;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphSpecificResolveState;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.jspecify.annotations.Nullable;

public class ComponentState
implements ComponentResolutionState,
DependencyGraphComponent {
    private final ComponentIdentifier componentIdentifier;
    private final ModuleVersionIdentifier id;
    private final ComponentMetaDataResolver resolver;
    private final List<NodeState> nodes = new LinkedList<NodeState>();
    private final Long resultId;
    private final ModuleResolveState module;
    private final List<ComponentSelectionDescriptorInternal> selectionCauses = new ArrayList<ComponentSelectionDescriptorInternal>();
    private final int hashCode;
    private volatile ComponentGraphResolveState resolveState;
    private volatile ComponentGraphSpecificResolveState graphResolveState;
    private ComponentSelectionState state = ComponentSelectionState.Selectable;
    private ModuleVersionResolveException metadataResolveFailure;
    private ModuleSelectors<SelectorState> selectors;
    private DependencyGraphBuilder.VisitState visitState = DependencyGraphBuilder.VisitState.NotSeen;
    private boolean rejected;
    private boolean root;
    private Pair<Capability, Collection<NodeState>> capabilityReject;
    private @Nullable ComponentSelectionReasonInternal cachedReason;

    ComponentState(long resultId, ModuleResolveState module, ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier, ComponentMetaDataResolver resolver) {
        this.resultId = resultId;
        this.module = module;
        this.id = id;
        this.componentIdentifier = componentIdentifier;
        this.resolver = resolver;
        this.hashCode = 31 * id.hashCode() ^ Long.hashCode(resultId);
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public String getVersion() {
        return this.id.getVersion();
    }

    @Override
    public long getResultId() {
        return this.resultId;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public @Nullable String getRepositoryName() {
        return this.graphResolveState.getRepositoryName();
    }

    @Override
    public ModuleVersionIdentifier getModuleVersion() {
        return this.id;
    }

    public @Nullable ModuleVersionResolveException getMetadataResolveFailure() {
        return this.metadataResolveFailure;
    }

    public DependencyGraphBuilder.VisitState getVisitState() {
        return this.visitState;
    }

    public void setVisitState(DependencyGraphBuilder.VisitState visitState) {
        this.visitState = visitState;
    }

    public List<NodeState> getNodes() {
        return this.nodes;
    }

    public ModuleResolveState getModule() {
        return this.module;
    }

    @Override
    public @Nullable ComponentGraphResolveMetadata getMetadataOrNull() {
        this.resolve();
        if (this.resolveState == null) {
            return null;
        }
        return this.resolveState.getMetadata();
    }

    public ComponentGraphResolveMetadata getMetadata() {
        this.resolve();
        return this.resolveState.getMetadata();
    }

    @Override
    public ComponentGraphResolveState getResolveState() {
        this.resolve();
        assert (this.resolveState != null);
        return this.resolveState;
    }

    public @Nullable ComponentGraphResolveState getResolveStateOrNull() {
        this.resolve();
        return this.resolveState;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        if (this.resolveState != null) {
            return this.resolveState.getId();
        }
        return this.componentIdentifier;
    }

    public void setSelectors(ModuleSelectors<SelectorState> selectors) {
        this.selectors = selectors;
    }

    public boolean alreadyResolved() {
        return this.resolveState != null || this.metadataResolveFailure != null;
    }

    public void resolve() {
        ComponentOverrideMetadata componentOverrideMetadata;
        if (this.alreadyResolved()) {
            return;
        }
        if (this.selectors != null && this.selectors.size() > 0) {
            SelectorState firstSelector = this.selectors.first();
            componentOverrideMetadata = DefaultComponentOverrideMetadata.forDependency(firstSelector.isChanging(), this.selectors.getFirstDependencyArtifact());
        } else {
            componentOverrideMetadata = DefaultComponentOverrideMetadata.EMPTY;
        }
        if (this.tryResolveVirtualPlatform()) {
            return;
        }
        DefaultBuildableComponentResolveResult result = new DefaultBuildableComponentResolveResult();
        this.resolver.resolve(this.componentIdentifier, componentOverrideMetadata, result);
        if (result.getFailure() != null) {
            this.metadataResolveFailure = result.getFailure();
            return;
        }
        this.resolveState = result.getState();
        this.graphResolveState = result.getGraphState();
    }

    private boolean tryResolveVirtualPlatform() {
        if (this.module.isVirtualPlatform()) {
            for (ComponentState version : this.module.getAllVersions()) {
                ComponentGraphResolveState versionState;
                if (version == this || !((versionState = version.getResolveStateOrNull()) instanceof LenientPlatformGraphResolveState)) continue;
                LenientPlatformGraphResolveState lenientState = (LenientPlatformGraphResolveState)versionState;
                ComponentGraphResolveState withIds = lenientState.copyWithIds((ModuleComponentIdentifier)this.componentIdentifier, this.id);
                this.setState(withIds, ComponentGraphSpecificResolveState.EMPTY_STATE);
                return true;
            }
        }
        return false;
    }

    public void setState(ComponentGraphResolveState state, ComponentGraphSpecificResolveState graphState) {
        this.resolveState = state;
        this.graphResolveState = graphState;
        this.metadataResolveFailure = null;
    }

    public void addNode(NodeState node) {
        this.nodes.add(node);
    }

    @Override
    public ComponentSelectionReasonInternal getSelectionReason() {
        if (this.cachedReason == null) {
            this.cachedReason = this.computeReason();
        }
        return this.cachedReason;
    }

    private ComponentSelectionReasonInternal computeReason() {
        if (this.root) {
            return ComponentSelectionReasons.root();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SelectorState selectorState : this.module.getSelectors()) {
            if (selectorState.getFailure() != null) continue;
            selectorState.visitSelectionReasons(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        for (DependencyGraphEdge dependencyGraphEdge : this.module.getAllIncomingEdges()) {
            dependencyGraphEdge.visitSelectionReasons(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        builder.addAll(VersionConflictResolutionDetails.mergeCauses(this.selectionCauses));
        return ComponentSelectionReasons.of((ImmutableSet<ComponentSelectionDescriptorInternal>)builder.build());
    }

    boolean hasStrongOpinion() {
        return StreamSupport.stream(this.module.getSelectors().spliterator(), false).filter(s -> s.getFailure() == null).anyMatch(SelectorState::hasStrongOpinion);
    }

    @Override
    public void addCause(ComponentSelectionDescriptorInternal componentSelectionDescriptor) {
        this.selectionCauses.add(componentSelectionDescriptor);
    }

    public void setRoot() {
        this.root = true;
    }

    public boolean isRoot() {
        return this.root;
    }

    @Override
    public List<ResolvedGraphVariant> getSelectedVariants() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.addSelectedVariants(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private void addSelectedVariants(Consumer<ResolvedGraphVariant> consumer) {
        for (NodeState node : this.nodes) {
            if (!node.isSelected()) continue;
            consumer.accept(node);
        }
    }

    public List<ComponentState> getDependents() {
        ArrayList<ComponentState> incoming = new ArrayList<ComponentState>(this.nodes.size());
        for (NodeState node : this.nodes) {
            for (EdgeState dependencyEdge : node.getIncomingEdges()) {
                incoming.add(dependencyEdge.getFrom().getComponent());
            }
        }
        return incoming;
    }

    public boolean isSelected() {
        return this.state == ComponentSelectionState.Selected;
    }

    public boolean isCandidateForConflictResolution() {
        return this.state.isCandidateForConflictResolution();
    }

    void evict() {
        this.state = ComponentSelectionState.Evicted;
    }

    void select() {
        this.state = ComponentSelectionState.Selected;
    }

    void makeSelectable() {
        this.state = ComponentSelectionState.Selectable;
    }

    @Override
    public void reject() {
        this.rejected = true;
    }

    public void rejectForCapabilityConflict(Capability capability, Collection<NodeState> conflictedNodes) {
        this.rejected = true;
        if (this.capabilityReject == null) {
            this.capabilityReject = Pair.of((Object)capability, new HashSet<NodeState>(conflictedNodes));
        } else {
            this.mergeCapabilityRejects(capability, conflictedNodes);
        }
    }

    private void mergeCapabilityRejects(Capability capability, Collection<NodeState> conflictedNodes) {
        if (((Capability)this.capabilityReject.getLeft()).equals(capability)) {
            ((Collection)this.capabilityReject.getRight()).addAll(conflictedNodes);
        } else {
            this.capabilityReject = Pair.of((Object)capability, new HashSet<NodeState>(conflictedNodes));
        }
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    public String getRejectedErrorMessage() {
        if (this.capabilityReject != null) {
            return ComponentState.formatCapabilityRejectMessage(this.module.getId(), this.capabilityReject);
        }
        return new ComponentRejectedMessageBuilder().buildFailureMessage(this.module);
    }

    private static String formatCapabilityRejectMessage(ModuleIdentifier id, Pair<Capability, Collection<NodeState>> capabilityConflict) {
        return "Module '" + id + "' has been rejected:\n   Cannot select module with conflict on capability '" + ComponentState.formatCapability((Capability)capabilityConflict.left) + "' also provided by " + ((Collection)capabilityConflict.getRight()).stream().map(NodeState::getDisplayName).sorted().collect(Collectors.toList());
    }

    private static String formatCapability(Capability capability) {
        return capability.getGroup() + ":" + capability.getName() + ":" + capability.getVersion();
    }

    @Override
    public Set<VirtualPlatformState> getPlatformOwners() {
        return this.module.getPlatformOwners();
    }

    @Override
    public VirtualPlatformState getPlatformState() {
        return this.module.getPlatformState();
    }

    public ImmutableCapability getImplicitCapability() {
        return this.resolveState.getDefaultCapability();
    }

    public boolean hasMoreThanOneSelectedNodeUsingVariantAwareResolution() {
        int count = 0;
        for (NodeState node : this.nodes) {
            if (!node.isSelectedByVariantAwareResolution() || ++count != 2) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentState that = (ComponentState)o;
        return that.resultId.equals(this.resultId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    static enum ComponentSelectionState {
        Selectable(true),
        Selected(true),
        Evicted(false);

        private final boolean candidateForConflictResolution;

        private ComponentSelectionState(boolean candidateForConflictResolution) {
            this.candidateForConflictResolution = candidateForConflictResolution;
        }

        boolean isCandidateForConflictResolution() {
            return this.candidateForConflictResolution;
        }
    }
}

