/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.Logger;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.PropertiesFileHandler;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;
import org.jspecify.annotations.NullMarked;

public class GradleWrapperMain {
    public static final String GRADLE_USER_HOME_OPTION = "g";
    public static final String GRADLE_USER_HOME_DETAILED_OPTION = "gradle-user-home";
    public static final String GRADLE_QUIET_OPTION = "q";
    public static final String GRADLE_QUIET_DETAILED_OPTION = "quiet";

    public static void main(String[] args) throws Exception {
        File wrapperJar = GradleWrapperMain.wrapperJar();
        GradleWrapperMain.prepareWrapper(args, wrapperJar).execute();
    }

    private static Action prepareWrapper(String[] args, File wrapperJar) throws Exception {
        File propertiesFile = GradleWrapperMain.wrapperProperties(wrapperJar);
        File rootDir = GradleWrapperMain.rootDir(wrapperJar);
        CommandLineParser parser = new CommandLineParser();
        parser.allowUnknownOptions();
        parser.option(new String[]{GRADLE_USER_HOME_OPTION, GRADLE_USER_HOME_DETAILED_OPTION}).hasArgument();
        parser.option(new String[]{GRADLE_QUIET_OPTION, GRADLE_QUIET_DETAILED_OPTION});
        SystemPropertiesCommandLineConverter converter = new SystemPropertiesCommandLineConverter();
        converter.configure(parser);
        ParsedCommandLine options = parser.parse(args);
        Map commandLineSystemProperties = converter.convert(options, new HashMap());
        Map projectSystemProperties = PropertiesFileHandler.getSystemProperties((File)new File(rootDir, "gradle.properties"));
        GradleWrapperMain.maybeAddGradleUserHomeSystemProperty(projectSystemProperties, commandLineSystemProperties);
        File gradleUserHome = GradleWrapperMain.gradleUserHome(options);
        File userGradleProperties = new File(gradleUserHome, "gradle.properties");
        HashMap<String, String> userSystemProperties = new HashMap<String, String>(PropertiesFileHandler.getSystemProperties((File)userGradleProperties));
        boolean invalidGradleUserHome = userSystemProperties.remove("gradle.user.home") != null;
        GradleWrapperMain.addSystemProperties(projectSystemProperties, userSystemProperties, commandLineSystemProperties);
        Logger logger = GradleWrapperMain.logger(options);
        if (invalidGradleUserHome) {
            logger.log("WARNING Ignored custom Gradle user home location configured in Gradle user home: " + userGradleProperties.getAbsolutePath());
        }
        WrapperExecutor wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile);
        WrapperConfiguration configuration = wrapperExecutor.getConfiguration();
        Download download = new Download(logger, "gradlew", "0", configuration.getNetworkTimeout());
        return () -> GradleWrapperMain.lambda$prepareWrapper$0(wrapperExecutor, args, logger, (IDownload)download, gradleUserHome, rootDir);
    }

    private static void addSystemProperties(Map<String, String> projectSystemProperties, Map<String, String> userSystemProperties, Map<String, String> commandLineSystemProperties) {
        Map<String, String> gradleSystemProperties = GradleWrapperMain.merge(GradleWrapperMain.merge(projectSystemProperties, userSystemProperties), commandLineSystemProperties);
        System.getProperties().putAll(gradleSystemProperties);
    }

    private static void maybeAddGradleUserHomeSystemProperty(Map<String, String> projectSystemProperties, Map<String, String> commandLineSystemProperties) {
        Map<String, String> gradleSystemProperties = GradleWrapperMain.merge(projectSystemProperties, commandLineSystemProperties);
        String property = gradleSystemProperties.get("gradle.user.home");
        if (property != null) {
            System.setProperty("gradle.user.home", property);
        }
    }

    private static Map<String, String> merge(Map<String, String> p1, Map<String, String> p2) {
        HashMap<String, String> result = new HashMap<String, String>(p1);
        result.putAll(p2);
        return result;
    }

    private static File rootDir(File wrapperJar) {
        return wrapperJar.getParentFile().getParentFile().getParentFile();
    }

    private static File wrapperProperties(File wrapperJar) {
        return new File(wrapperJar.getParent(), wrapperJar.getName().replaceFirst("\\.jar$", ".properties"));
    }

    private static File wrapperJar() {
        URI location;
        try {
            location = GradleWrapperMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new RuntimeException(String.format("Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        try {
            return Paths.get(location).toFile();
        }
        catch (NoClassDefFoundError e) {
            return new File(location.getPath());
        }
    }

    private static File gradleUserHome(ParsedCommandLine options) {
        if (options.hasOption(GRADLE_USER_HOME_OPTION)) {
            return new File(options.option(GRADLE_USER_HOME_OPTION).getValue());
        }
        return GradleUserHomeLookup.gradleUserHome();
    }

    private static Logger logger(ParsedCommandLine options) {
        return new Logger(options.hasOption(GRADLE_QUIET_OPTION));
    }

    private static /* synthetic */ void lambda$prepareWrapper$0(WrapperExecutor wrapperExecutor, String[] args, Logger logger, IDownload download, File gradleUserHome, File rootDir) throws Exception {
        wrapperExecutor.execute(args, new Install(logger, download, new PathAssembler(gradleUserHome, rootDir)), new BootstrapMainStarter());
    }

    @NullMarked
    @FunctionalInterface
    private static interface Action {
        public void execute() throws Exception;
    }
}

