/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import javax.annotation.CheckReturnValue;
import org.gradle.internal.collect.PersistentArray0;
import org.gradle.internal.collect.PersistentArray1;
import org.jspecify.annotations.Nullable;

public interface PersistentArray<T>
extends Iterable<T> {
    public static <T> PersistentArray<T> of() {
        return PersistentArray0.INSTANCE;
    }

    public static <T> PersistentArray<T> of(T value) {
        return new PersistentArray1<T>(value);
    }

    @SafeVarargs
    public static <T> PersistentArray<T> of(T ... values) {
        PersistentArray<T> copy = PersistentArray.of();
        for (T value : values) {
            copy = copy.plus(value);
        }
        return copy;
    }

    public static <T> PersistentArray<T> copyOf(Iterable<T> values) {
        if (values instanceof PersistentArray) {
            return (PersistentArray)values;
        }
        PersistentArray<T> copy = PersistentArray.of();
        for (T value : values) {
            copy = copy.plus(value);
        }
        return copy;
    }

    @CheckReturnValue
    public PersistentArray<T> plus(T var1);

    public int size();

    public T get(int var1);

    public @Nullable T getLast();

    public boolean isEmpty();

    public boolean contains(T var1);
}

