/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Collection;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;

public class DefaultDependencyConstraintSet
extends DelegatingDomainObjectSet<DependencyConstraint>
implements DependencyConstraintSet {
    private final Describable displayName;
    private final ConfigurationInternal clientConfiguration;

    public DefaultDependencyConstraintSet(Describable displayName, ConfigurationInternal clientConfiguration, DomainObjectSet<DependencyConstraint> backingSet) {
        super(backingSet);
        this.displayName = displayName;
        this.clientConfiguration = clientConfiguration;
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    public boolean add(DependencyConstraint dependencyConstraint) {
        this.assertConfigurationIsDeclarable();
        this.clientConfiguration.maybeEmitDeclarationDeprecation();
        if (dependencyConstraint instanceof DependencyConstraintInternal) {
            ((DependencyConstraintInternal)dependencyConstraint).addMutationValidator(constraint -> ((MutationValidator)((Object)this.clientConfiguration)).validateMutation(MutationValidator.MutationType.DEPENDENCY_CONSTRAINT_ATTRIBUTES));
        }
        return this.addInternalDependencyConstraint(dependencyConstraint);
    }

    public boolean addInternalDependencyConstraint(DependencyConstraint dependencyConstraint) {
        return super.add((Object)dependencyConstraint);
    }

    private void assertConfigurationIsDeclarable() {
        if (!this.clientConfiguration.isCanBeDeclared()) {
            throw new GradleException("Dependency constraints can not be declared against the `" + this.clientConfiguration.getName() + "` configuration.");
        }
    }

    public boolean addAll(Collection<? extends DependencyConstraint> dependencyConstraints) {
        boolean added = false;
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            added |= this.add(dependencyConstraint);
        }
        return added;
    }
}

