/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.io.File;
import java.net.URI;
import org.gradle.testkit.runner.GradleRunner;
import org.gradle.tooling.GradleConnector;

public abstract class GradleProvider {
    private GradleProvider() {
    }

    public abstract void applyTo(GradleConnector var1);

    public abstract void applyTo(GradleRunner var1);

    public static GradleProvider installation(File gradleHome) {
        return new InstallationGradleProvider(gradleHome);
    }

    public static GradleProvider uri(URI location) {
        return new UriGradleProvider(location);
    }

    public static GradleProvider version(String version) {
        return new VersionGradleProvider(version);
    }

    private static final class InstallationGradleProvider
    extends GradleProvider {
        private final File gradleHome;

        private InstallationGradleProvider(File gradleHome) {
            this.gradleHome = gradleHome;
        }

        @Override
        public void applyTo(GradleConnector gradleConnector) {
            gradleConnector.useInstallation(this.gradleHome);
        }

        @Override
        public void applyTo(GradleRunner gradleRunner) {
            gradleRunner.withGradleInstallation(this.gradleHome);
        }
    }

    private static final class UriGradleProvider
    extends GradleProvider {
        private final URI uri;

        public UriGradleProvider(URI uri) {
            this.uri = uri;
        }

        @Override
        public void applyTo(GradleConnector gradleConnector) {
            gradleConnector.useDistribution(this.uri);
        }

        @Override
        public void applyTo(GradleRunner gradleRunner) {
            gradleRunner.withGradleDistribution(this.uri);
        }
    }

    private static final class VersionGradleProvider
    extends GradleProvider {
        private final String gradleVersion;

        public VersionGradleProvider(String gradleVersion) {
            this.gradleVersion = gradleVersion;
        }

        @Override
        public void applyTo(GradleConnector gradleConnector) {
            gradleConnector.useGradleVersion(this.gradleVersion);
        }

        @Override
        public void applyTo(GradleRunner gradleRunner) {
            gradleRunner.withGradleVersion(this.gradleVersion);
        }
    }
}

