/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;

public class PendingDependencies {
    private final ModuleIdentifier moduleIdentifier;
    private final Set<NodeState> constraintProvidingNodes;
    private int hardEdges;

    PendingDependencies(ModuleIdentifier moduleIdentifier) {
        this.moduleIdentifier = moduleIdentifier;
        this.constraintProvidingNodes = new LinkedHashSet<NodeState>();
        this.hardEdges = 0;
    }

    boolean addIncomingHardEdge() {
        this.increaseHardEdgeCount();
        if (!this.hasConstraintProviders()) {
            return false;
        }
        assert (this.hardEdges == 1);
        for (NodeState node : this.constraintProvidingNodes) {
            node.prepareForConstraintNoLongerPending(this.moduleIdentifier);
        }
        this.constraintProvidingNodes.clear();
        return true;
    }

    void registerConstraintProvider(NodeState nodeState) {
        if (this.hardEdges != 0) {
            throw new IllegalStateException("Cannot add a pending node for a dependency which is not pending");
        }
        this.constraintProvidingNodes.add(nodeState);
    }

    public void unregisterConstraintProvider(NodeState nodeState) {
        if (this.hardEdges != 0) {
            throw new IllegalStateException("Cannot remove a pending node for a dependency which is not pending");
        }
        this.constraintProvidingNodes.remove(nodeState);
    }

    public boolean isPending() {
        return this.hardEdges == 0;
    }

    boolean hasConstraintProviders() {
        return !this.constraintProvidingNodes.isEmpty();
    }

    void increaseHardEdgeCount() {
        ++this.hardEdges;
    }

    void decreaseHardEdgeCount() {
        assert (this.hardEdges > 0) : "Cannot remove a hard edge when none recorded";
        --this.hardEdges;
    }

    public void retarget(PendingDependencies pendingDependencies) {
        this.hardEdges += pendingDependencies.hardEdges;
    }
}

