/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.InputVisitor;
import org.gradle.internal.execution.MutableUnitOfWork;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.changes.DefaultIncrementalInputProperties;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.steps.MutableBeforeExecutionContext;
import org.gradle.internal.execution.steps.MutableChangesContext;
import org.gradle.internal.execution.steps.MutableStep;
import org.gradle.internal.execution.steps.MutableValidationFinishedContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.properties.InputBehavior;
import org.jspecify.annotations.NullMarked;

public class ResolveChangesStep<C extends MutableValidationFinishedContext, R extends Result>
extends MutableStep<C, R> {
    private static final ImmutableList<String> NO_HISTORY = ImmutableList.of((Object)"No history is available.");
    private static final ImmutableList<String> UNTRACKED = ImmutableList.of((Object)"Change tracking is disabled.");
    private static final ImmutableList<String> VALIDATION_FAILED = ImmutableList.of((Object)"Incremental execution has been disabled to ensure correctness. Please consult deprecation warnings for more details.");
    private final ExecutionStateChangeDetector changeDetector;
    private final Step<? super MutableChangesContext, R> delegate;

    public ResolveChangesStep(ExecutionStateChangeDetector changeDetector, Step<? super MutableChangesContext, R> delegate) {
        this.changeDetector = changeDetector;
        this.delegate = delegate;
    }

    @Override
    protected R executeMutable(MutableUnitOfWork work, C context) {
        MutableChangesContext delegateContext = ((MutableBeforeExecutionContext)context).getBeforeExecutionState().map(beforeExecution -> this.resolveExecutionStateChanges(work, (MutableValidationFinishedContext)context, (BeforeExecutionState)beforeExecution)).map(changes -> new MutableChangesContext((MutableValidationFinishedContext)context, changes.getChangeDescriptions(), (ExecutionStateChanges)changes)).orElseGet(() -> {
            ImmutableList<String> rebuildReason = context.getNonIncrementalReason().map(ImmutableList::of).orElse(UNTRACKED);
            return new MutableChangesContext((MutableValidationFinishedContext)context, rebuildReason, null);
        });
        return this.delegate.execute(work, delegateContext);
    }

    @NullMarked
    private ExecutionStateChanges resolveExecutionStateChanges(MutableUnitOfWork work, MutableValidationFinishedContext context, BeforeExecutionState beforeExecution) {
        IncrementalInputProperties incrementalInputProperties = ResolveChangesStep.createIncrementalInputProperties(work);
        return context.getNonIncrementalReason().map(ImmutableList::of).map(nonIncrementalReason -> ExecutionStateChanges.nonIncremental((ImmutableList<String>)nonIncrementalReason, beforeExecution, incrementalInputProperties)).orElseGet(() -> context.getPreviousExecutionState().map(previousExecution -> context.getValidationProblems().isEmpty() ? this.changeDetector.detectChanges(work, (PreviousExecutionState)previousExecution, beforeExecution, incrementalInputProperties, context.getDetectedOverlappingOutputs().isPresent()) : ExecutionStateChanges.nonIncremental(VALIDATION_FAILED, beforeExecution, incrementalInputProperties)).orElseGet(() -> ExecutionStateChanges.nonIncremental(NO_HISTORY, beforeExecution, incrementalInputProperties)));
    }

    private static IncrementalInputProperties createIncrementalInputProperties(MutableUnitOfWork work) {
        switch (work.getExecutionBehavior()) {
            case NON_INCREMENTAL: {
                return IncrementalInputProperties.NONE;
            }
            case INCREMENTAL: {
                final ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
                InputVisitor visitor = new InputVisitor(){

                    @Override
                    public void visitInputFileProperty(String propertyName, InputBehavior behavior, InputVisitor.InputFileValueSupplier valueSupplier) {
                        if (behavior.shouldTrackChanges()) {
                            Object value = valueSupplier.getValue();
                            if (value == null) {
                                throw new InvalidUserDataException("Must specify a value for incremental input property '" + propertyName + "'.");
                            }
                            builder.put((Object)propertyName, value);
                        }
                    }
                };
                work.visitImmutableInputs(visitor);
                work.visitMutableInputs(visitor);
                return new DefaultIncrementalInputProperties((ImmutableBiMap<String, Object>)builder.build());
            }
        }
        throw new AssertionError();
    }
}

