/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class WrapperCredentials {
    private final @Nullable String token;
    private final @Nullable String basicUserInfo;

    private WrapperCredentials(@Nullable String token, @Nullable String basicUserInfo) {
        this.token = token;
        this.basicUserInfo = basicUserInfo;
    }

    public static WrapperCredentials fromToken(String token) {
        return new WrapperCredentials(Objects.requireNonNull(token, "token"), null);
    }

    public static WrapperCredentials fromBasicUserInfo(String basicUserInfo) {
        return new WrapperCredentials(null, Objects.requireNonNull(basicUserInfo, "basicUserInfo"));
    }

    public static WrapperCredentials fromUsernamePassword(String username, String password) {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        return WrapperCredentials.fromBasicUserInfo(username + ':' + password);
    }

    public static @Nullable WrapperCredentials findCredentials(URI distributionUrl, Function<? super String, ? extends @Nullable String> propertyProvider) {
        Objects.requireNonNull(distributionUrl, "distributionUrl");
        Objects.requireNonNull(propertyProvider, "propertyProvider");
        String token = WrapperCredentials.tryGetProperty(distributionUrl.getHost(), "wrapperToken", propertyProvider);
        if (token != null) {
            return WrapperCredentials.fromToken(token);
        }
        return WrapperCredentials.findBasicCredentials(distributionUrl, propertyProvider);
    }

    private static @Nullable WrapperCredentials findBasicCredentials(URI distributionUrl, Function<? super String, ? extends @Nullable String> propertyProvider) {
        String host = distributionUrl.getHost();
        String username = WrapperCredentials.tryGetProperty(host, "wrapperUser", propertyProvider);
        String password = WrapperCredentials.tryGetProperty(host, "wrapperPassword", propertyProvider);
        if (username != null && password != null) {
            return WrapperCredentials.fromUsernamePassword(username, password);
        }
        String userInfo = distributionUrl.getUserInfo();
        return userInfo != null ? WrapperCredentials.fromBasicUserInfo(userInfo) : null;
    }

    private static @Nullable String tryGetProperty(@Nullable String host, String key, Function<? super String, ? extends @Nullable String> propertyProvider) {
        if (host != null) {
            String hostEscaped = host.replace('.', '_').toLowerCase(Locale.ROOT);
            String hostProperty = propertyProvider.apply("gradle." + hostEscaped + '.' + key);
            if (hostProperty != null) {
                return hostProperty;
            }
        }
        return propertyProvider.apply("gradle." + key);
    }

    public @Nullable String token() {
        return this.token;
    }

    private static Map.Entry<String, String> mapEntry(String key, String value) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    public  @Nullable Map.Entry<String, String> usernameAndPassword() {
        if (this.basicUserInfo == null) {
            return null;
        }
        int usernameEnd = this.basicUserInfo.indexOf(58);
        return usernameEnd >= 0 ? WrapperCredentials.mapEntry(this.basicUserInfo.substring(0, usernameEnd), this.basicUserInfo.substring(usernameEnd + 1)) : null;
    }

    public @Nullable String username() {
        Map.Entry<String, String> combined = this.usernameAndPassword();
        return combined != null ? combined.getKey() : null;
    }

    public String authorizationTypeDisplayName() {
        return this.token != null ? "Bearer Token" : "Basic";
    }

    public Map.Entry<String, String> authorizationHeader() {
        return WrapperCredentials.mapEntry("Authorization", this.authorizationHeaderValue());
    }

    private String authorizationHeaderValue() {
        if (this.token != null) {
            return "Bearer " + this.token;
        }
        if (this.basicUserInfo != null) {
            return "Basic " + Base64.getEncoder().encodeToString(this.basicUserInfo.getBytes(StandardCharsets.UTF_8));
        }
        throw new AssertionError((Object)"Internal error: Unexpected credentials state.");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrapperCredentials that = (WrapperCredentials)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.basicUserInfo, that.basicUserInfo);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.basicUserInfo);
    }

    public String toString() {
        return "WrapperCredentials{" + (this.token != null ? "<TOKEN>" : "password for " + this.username()) + '}';
    }
}

