/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.Execution;
import org.gradle.internal.execution.ImmutableUnitOfWork;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.ImmutableWorkspaceMetadata;
import org.gradle.internal.execution.history.ImmutableWorkspaceMetadataStore;
import org.gradle.internal.execution.history.impl.DefaultExecutionOutputState;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.execution.steps.WorkspaceResult;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.vfs.FileSystemAccess;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignImmutableWorkspaceStep<C extends IdentityContext>
implements Step<C, WorkspaceResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssignImmutableWorkspaceStep.class);
    private final Deleter deleter;
    private final FileSystemAccess fileSystemAccess;
    private final ImmutableWorkspaceMetadataStore workspaceMetadataStore;
    private final OutputSnapshotter outputSnapshotter;
    private final Step<? super PreviousExecutionContext, ? extends CachingResult> delegate;

    public AssignImmutableWorkspaceStep(Deleter deleter, FileSystemAccess fileSystemAccess, ImmutableWorkspaceMetadataStore workspaceMetadataStore, OutputSnapshotter outputSnapshotter, Step<? super PreviousExecutionContext, ? extends CachingResult> delegate) {
        this.deleter = deleter;
        this.fileSystemAccess = fileSystemAccess;
        this.workspaceMetadataStore = workspaceMetadataStore;
        this.outputSnapshotter = outputSnapshotter;
        this.delegate = delegate;
    }

    @Override
    public WorkspaceResult execute(UnitOfWork work, C context) {
        String uniqueId;
        ImmutableWorkspaceProvider workspaceProvider = ((ImmutableUnitOfWork)work).getWorkspaceProvider();
        ImmutableWorkspaceProvider.ImmutableWorkspace workspace = workspaceProvider.getWorkspace(uniqueId = ((IdentityContext)context).getIdentity().getUniqueId());
        ImmutableWorkspaceProvider.ConcurrentResult<WorkspaceResult> result = workspace.getOrCompute(() -> this.loadOrCreateWorkspace(work, workspace, context));
        return result.isProducedByCurrentThread() ? result.get() : AssignImmutableWorkspaceStep.mapConcurrentResultToUpToDate(result.get(), work, workspace);
    }

    private static WorkspaceResult mapConcurrentResultToUpToDate(WorkspaceResult result, UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace) {
        if (result.getExecution().isSuccessful()) {
            ExecutionOutputState executionOutputState = result.getAfterExecutionOutputState().get();
            return AssignImmutableWorkspaceStep.getUpToDate(work, workspace.getImmutableLocation(), executionOutputState.getOutputFilesProducedByWork(), executionOutputState.getOriginMetadata());
        }
        return new WorkspaceResult(result, null);
    }

    private WorkspaceResult loadOrCreateWorkspace(UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace, C context) {
        WorkspaceLoad initialLoad = this.loadImmutableWorkspaceIfExists(work, workspace);
        if (initialLoad.isSuccess()) {
            return initialLoad.getResult();
        }
        return workspace.withFileLock(() -> {
            WorkspaceResult result;
            Runnable invalidateSnapshots = () -> this.fileSystemAccess.invalidate((Iterable)ImmutableList.of((Object)workspace.getImmutableLocation().getAbsolutePath()));
            WorkspaceLoad load = this.loadImmutableWorkspaceIfComplete(work, workspace, invalidateSnapshots);
            WorkspaceResult workspaceResult = result = load.isSuccess() ? load.getResult() : this.executeInWorkspace(work, context, workspace);
            if (initialLoad.isSoftDeleted()) {
                workspace.ensureUnSoftDeleted();
            }
            return result;
        });
    }

    private WorkspaceLoad loadImmutableWorkspaceIfExists(UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace) {
        File immutableLocation = workspace.getImmutableLocation();
        FileSystemLocationSnapshot snapshot = this.fileSystemAccess.read(immutableLocation.getAbsolutePath());
        switch (snapshot.getType()) {
            case Directory: {
                if (workspace.isSoftDeleted()) {
                    return WorkspaceLoad.softDeleted();
                }
                return this.loadImmutableWorkspaceIfComplete(work, workspace, () -> {});
            }
            case RegularFile: {
                throw new IllegalStateException("Immutable workspace is occupied by a file: " + immutableLocation.getAbsolutePath() + ". Deleting the file in question can allow the content to be recreated.");
            }
            case Missing: {
                return WorkspaceLoad.missingOrBroken();
            }
        }
        throw new AssertionError();
    }

    private WorkspaceLoad loadImmutableWorkspaceIfComplete(UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace, Runnable snapshotsInvalidation) {
        File immutableLocation = workspace.getImmutableLocation();
        Optional<ImmutableWorkspaceMetadata> metadata = this.workspaceMetadataStore.loadWorkspaceMetadata(immutableLocation);
        if (!metadata.isPresent()) {
            return WorkspaceLoad.missingOrBroken();
        }
        snapshotsInvalidation.run();
        ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots = this.outputSnapshotter.snapshotOutputs(work, immutableLocation);
        ImmutableListMultimap<String, HashCode> outputHashes = AssignImmutableWorkspaceStep.calculateOutputHashes(outputSnapshots);
        if (!metadata.get().getOutputPropertyHashes().equals(outputHashes)) {
            String actualOutputHashes = outputSnapshots.entrySet().stream().map(entry -> (String)entry.getKey() + ":\n" + ((FileSystemSnapshot)entry.getValue()).roots().map(AssignImmutableWorkspaceStep::describeSnapshot).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"));
            LOGGER.warn("The contents of the immutable workspace '{}' have been modified. These workspace directories are not supposed to be modified once they are created. The modification might have been caused by an external process, or could be the result of disk corruption.\n{}", (Object)immutableLocation.getAbsolutePath(), (Object)actualOutputHashes);
            return WorkspaceLoad.missingOrBroken();
        }
        return WorkspaceLoad.success(AssignImmutableWorkspaceStep.getUpToDate(work, workspace.getImmutableLocation(), outputSnapshots, metadata.get().getOriginMetadata()));
    }

    private static WorkspaceResult getUpToDate(UnitOfWork work, File workspace, ImmutableSortedMap<String, FileSystemSnapshot> outputFilesProducedByWork, OriginMetadata originMetadata) {
        DefaultExecutionOutputState afterExecutionOutputState = new DefaultExecutionOutputState(true, outputFilesProducedByWork, originMetadata, true);
        CachingResult cachingResult = CachingResult.shortcutResult(Duration.ZERO, Execution.skipped(Execution.ExecutionOutcome.UP_TO_DATE, work), afterExecutionOutputState, null, originMetadata);
        return new WorkspaceResult(cachingResult, workspace);
    }

    private WorkspaceResult executeInWorkspace(UnitOfWork work, C context, ImmutableWorkspaceProvider.ImmutableWorkspace workspace) {
        File workspaceDir = workspace.getImmutableLocation();
        WorkspaceContext workspaceContext = new WorkspaceContext((IdentityContext)context, workspaceDir);
        PreviousExecutionContext previousExecutionContext = new PreviousExecutionContext(workspaceContext, null);
        this.ensureEmptyDirectory(workspaceDir);
        CachingResult delegateResult = this.delegate.execute(work, previousExecutionContext);
        if (delegateResult.getExecution().isSuccessful()) {
            ExecutionOutputState executionOutputState = delegateResult.getAfterExecutionOutputState().get();
            ImmutableListMultimap<String, HashCode> outputHashes = AssignImmutableWorkspaceStep.calculateOutputHashes(executionOutputState.getOutputFilesProducedByWork());
            ImmutableWorkspaceMetadata metadata = new ImmutableWorkspaceMetadata(executionOutputState.getOriginMetadata(), outputHashes);
            this.workspaceMetadataStore.storeWorkspaceMetadata(workspaceDir, metadata);
            return new WorkspaceResult(delegateResult, workspaceDir);
        }
        return new WorkspaceResult(delegateResult, null);
    }

    private void ensureEmptyDirectory(File workspace) {
        try {
            this.deleter.ensureEmptyDirectory(workspace);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ImmutableListMultimap<String, HashCode> calculateOutputHashes(ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots) {
        return (ImmutableListMultimap)outputSnapshots.entrySet().stream().flatMap(entry -> ((FileSystemSnapshot)entry.getValue()).roots().map(locationSnapshot -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)locationSnapshot.getHash()))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String describeSnapshot(FileSystemLocationSnapshot root) {
        final StringBuilder builder = new StringBuilder();
        root.accept(new FileSystemSnapshotHierarchyVisitor(){
            private int indent = 0;

            public void enterDirectory(DirectorySnapshot directorySnapshot) {
                ++this.indent;
            }

            public void leaveDirectory(DirectorySnapshot directorySnapshot) {
                --this.indent;
            }

            public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
                for (int i = 0; i < this.indent; ++i) {
                    builder.append("  ");
                }
                builder.append(" - ");
                builder.append(snapshot.getName());
                builder.append(" (");
                builder.append(snapshot.getType());
                builder.append(", ");
                builder.append(snapshot.getHash());
                builder.append(")");
                builder.append("\n");
                return SnapshotVisitResult.CONTINUE;
            }
        });
        return builder.toString();
    }

    private static class WorkspaceLoad {
        private final @Nullable WorkspaceResult workspaceResult;
        private final Status status;

        private WorkspaceLoad(@Nullable WorkspaceResult workspaceResult, Status status) {
            this.workspaceResult = workspaceResult;
            this.status = status;
        }

        public WorkspaceResult getResult() {
            return (WorkspaceResult)Preconditions.checkNotNull((Object)this.workspaceResult);
        }

        public boolean isSuccess() {
            return this.status == Status.SUCCESS;
        }

        public boolean isSoftDeleted() {
            return this.status == Status.SOFT_DELETED;
        }

        public static WorkspaceLoad success(WorkspaceResult workspaceResult) {
            return new WorkspaceLoad(workspaceResult, Status.SUCCESS);
        }

        public static WorkspaceLoad softDeleted() {
            return new WorkspaceLoad(null, Status.SOFT_DELETED);
        }

        public static WorkspaceLoad missingOrBroken() {
            return new WorkspaceLoad(null, Status.MISSING_OR_BROKEN);
        }

        static enum Status {
            SUCCESS,
            SOFT_DELETED,
            MISSING_OR_BROKEN;

        }
    }
}

