/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import com.google.common.base.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.artifacts.dsl.dependencies.TargetJVMVersionOnLibraryTooNewFailureDescriber;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenVariantAttributesFactory;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleVariantsFailure;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class})
public class PlatformSupport {
    private final Category library;
    private final Category regularPlatform;
    private final Category enforcedPlatform;

    public PlatformSupport(NamedObjectInstantiator instantiator) {
        this.library = (Category)instantiator.named(Category.class, "library");
        this.regularPlatform = (Category)instantiator.named(Category.class, "platform");
        this.enforcedPlatform = (Category)instantiator.named(Category.class, "enforced-platform");
    }

    public boolean isTargetingPlatform(HasConfigurableAttributes<?> target) {
        Category category = (Category)target.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
        return this.regularPlatform.equals(category) || this.enforcedPlatform.equals(category);
    }

    public Category getRegularPlatformCategory() {
        return this.regularPlatform;
    }

    public void configureSchema(AttributesSchemaInternal attributesSchema) {
        this.configureCategoryDisambiguationRule(attributesSchema);
    }

    public static void configureFailureHandler(ResolutionFailureHandler handler) {
        handler.addFailureDescriber(NoCompatibleVariantsFailure.class, TargetJVMVersionOnLibraryTooNewFailureDescriber.class);
    }

    private void configureCategoryDisambiguationRule(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy categorySchema = attributesSchema.attribute(Category.CATEGORY_ATTRIBUTE);
        categorySchema.getDisambiguationRules().add(ComponentCategoryDisambiguationRule.class, actionConfiguration -> {
            actionConfiguration.params(new Object[]{this.library});
            actionConfiguration.params(new Object[]{this.regularPlatform});
        });
    }

    public <T> void addPlatformAttribute(HasConfigurableAttributes<T> dependency, String category) {
        dependency.attributes(attributeContainer -> attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)attributeContainer.named(Category.class, category))));
    }

    public static boolean hasForcedDependencies(ComponentVariant variant) {
        return Objects.equal((Object)variant.getAttributes().getAttribute(MavenVariantAttributesFactory.CATEGORY_ATTRIBUTE), (Object)"enforced-platform");
    }

    public static class ComponentCategoryDisambiguationRule
    implements AttributeDisambiguationRule<Category> {
        final Category library;
        final Category platform;

        @Inject
        ComponentCategoryDisambiguationRule(Category library, Category regularPlatform) {
            this.library = library;
            this.platform = regularPlatform;
        }

        public void execute(MultipleCandidatesDetails<Category> details) {
            Category consumerValue = (Category)details.getConsumerValue();
            if (consumerValue == null) {
                Set candidateValues = details.getCandidateValues();
                if (candidateValues.contains(this.library)) {
                    details.closestMatch((Object)this.library);
                } else if (candidateValues.contains(this.platform)) {
                    details.closestMatch((Object)this.platform);
                }
            }
        }
    }
}

