/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.execution.FileCollectionSnapshotter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.kotlin.dsl.execution.ClasspathElementChecker;
import org.gradle.kotlin.dsl.execution.DefaultKotlinMetadataCompatibilityChecker;
import org.gradle.kotlin.dsl.execution.KotlinMetadataCompatibilityCache;
import org.gradle.kotlin.dsl.execution.KotlinMetadataCompatibilityChecker;
import org.gradle.kotlin.dsl.execution.KotlinMetadataVersionExtractor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/gradle/kotlin/dsl/execution/DefaultKotlinMetadataCompatibilityChecker;", "Lorg/gradle/kotlin/dsl/execution/KotlinMetadataCompatibilityChecker;", "fileCollectionSnapshotter", "Lorg/gradle/internal/execution/FileCollectionSnapshotter;", "fileCollectionFactory", "Lorg/gradle/api/internal/file/FileCollectionFactory;", "compatibilityCache", "Lorg/gradle/kotlin/dsl/execution/KotlinMetadataCompatibilityCache;", "classpathWalker", "Lorg/gradle/internal/classpath/ClasspathWalker;", "<init>", "(Lorg/gradle/internal/execution/FileCollectionSnapshotter;Lorg/gradle/api/internal/file/FileCollectionFactory;Lorg/gradle/kotlin/dsl/execution/KotlinMetadataCompatibilityCache;Lorg/gradle/internal/classpath/ClasspathWalker;)V", "getFileCollectionSnapshotter", "()Lorg/gradle/internal/execution/FileCollectionSnapshotter;", "getFileCollectionFactory", "()Lorg/gradle/api/internal/file/FileCollectionFactory;", "getCompatibilityCache", "()Lorg/gradle/kotlin/dsl/execution/KotlinMetadataCompatibilityCache;", "getClasspathWalker", "()Lorg/gradle/internal/classpath/ClasspathWalker;", "incompatibleClasspathElements", "", "Ljava/io/File;", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "kotlin-dsl"})
public final class DefaultKotlinMetadataCompatibilityChecker
implements KotlinMetadataCompatibilityChecker {
    @NotNull
    private final FileCollectionSnapshotter fileCollectionSnapshotter;
    @NotNull
    private final FileCollectionFactory fileCollectionFactory;
    @NotNull
    private final KotlinMetadataCompatibilityCache compatibilityCache;
    @NotNull
    private final ClasspathWalker classpathWalker;

    public DefaultKotlinMetadataCompatibilityChecker(@NotNull FileCollectionSnapshotter fileCollectionSnapshotter, @NotNull FileCollectionFactory fileCollectionFactory, @NotNull KotlinMetadataCompatibilityCache compatibilityCache, @NotNull ClasspathWalker classpathWalker) {
        Intrinsics.checkNotNullParameter((Object)fileCollectionSnapshotter, (String)"fileCollectionSnapshotter");
        Intrinsics.checkNotNullParameter((Object)fileCollectionFactory, (String)"fileCollectionFactory");
        Intrinsics.checkNotNullParameter((Object)compatibilityCache, (String)"compatibilityCache");
        Intrinsics.checkNotNullParameter((Object)classpathWalker, (String)"classpathWalker");
        this.fileCollectionSnapshotter = fileCollectionSnapshotter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.compatibilityCache = compatibilityCache;
        this.classpathWalker = classpathWalker;
    }

    @NotNull
    public final FileCollectionSnapshotter getFileCollectionSnapshotter() {
        return this.fileCollectionSnapshotter;
    }

    @NotNull
    public final FileCollectionFactory getFileCollectionFactory() {
        return this.fileCollectionFactory;
    }

    @NotNull
    public final KotlinMetadataCompatibilityCache getCompatibilityCache() {
        return this.compatibilityCache;
    }

    @NotNull
    public final ClasspathWalker getClasspathWalker() {
        return this.classpathWalker;
    }

    @Override
    @NotNull
    public List<File> incompatibleClasspathElements(@NotNull ClassPath classPath) {
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        KotlinMetadataVersionExtractor extractor = new KotlinMetadataVersionExtractor();
        ClasspathElementChecker elementChecker = new ClasspathElementChecker(this.classpathWalker, extractor);
        FileSystemSnapshot fileSystemSnapshot = this.fileCollectionSnapshotter.snapshot((FileCollection)this.fileCollectionFactory.fixed((Collection)classPath.getAsFiles()));
        Intrinsics.checkNotNullExpressionValue((Object)fileSystemSnapshot, (String)"snapshot(...)");
        FileSystemSnapshot fileSystemSnapshot2 = fileSystemSnapshot;
        List incompatibleFiles = new ArrayList();
        fileSystemSnapshot2.accept(new FileSystemSnapshotHierarchyVisitor(this, incompatibleFiles, elementChecker){
            final /* synthetic */ DefaultKotlinMetadataCompatibilityChecker this$0;
            final /* synthetic */ List<File> $incompatibleFiles;
            final /* synthetic */ ClasspathElementChecker $elementChecker;
            {
                this.this$0 = $receiver;
                this.$incompatibleFiles = $incompatibleFiles;
                this.$elementChecker = $elementChecker;
            }

            public final SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
                Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                if (snapshot instanceof MissingFileSnapshot) {
                    return SnapshotVisitResult.CONTINUE;
                }
                if (snapshot instanceof RegularFileSnapshot) {
                    String string = ((RegularFileSnapshot)snapshot).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    if (!StringsKt.endsWith((String)string, (String)".jar", (boolean)true)) {
                        return SnapshotVisitResult.CONTINUE;
                    }
                }
                File file = new File(snapshot.getAbsolutePath());
                KotlinMetadataCompatibilityCache kotlinMetadataCompatibilityCache = this.this$0.getCompatibilityCache();
                HashCode hashCode = snapshot.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)hashCode, (String)"getHash(...)");
                boolean compatible = kotlinMetadataCompatibilityCache.isCompatible(hashCode, (Function0<Boolean>)((Function0)() -> incompatibleClasspathElements.1.visitEntry$lambda$0(this.$elementChecker, file)));
                if (!compatible) {
                    this.$incompatibleFiles.add(file);
                }
                return SnapshotVisitResult.SKIP_SUBTREE;
            }

            private static final boolean visitEntry$lambda$0(ClasspathElementChecker $elementChecker, File $file) {
                return $elementChecker.isCompatible($file);
            }
        });
        return incompatibleFiles;
    }
}

