/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.capability.DefaultSpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.FeatureCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.SpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;

public class DefaultProjectDependency
extends AbstractModuleDependency
implements ProjectDependencyInternal {
    private final ProjectState projectState;

    public DefaultProjectDependency(ProjectState projectState) {
        this.projectState = projectState;
    }

    public String getPath() {
        return this.getTargetProjectIdentity().getProjectPath().asString();
    }

    public String getGroup() {
        return this.unsafeGetProject().getGroup().toString();
    }

    public String getName() {
        return this.getTargetProjectIdentity().getProjectName();
    }

    public String getVersion() {
        return this.unsafeGetProject().getVersion().toString();
    }

    public ProjectIdentity getTargetProjectIdentity() {
        return this.projectState.getIdentity();
    }

    public ProjectDependency copy() {
        DefaultProjectDependency copiedProjectDependency = new DefaultProjectDependency(this.projectState);
        this.copyTo(copiedProjectDependency);
        return copiedProjectDependency;
    }

    public List<Capability> getRequestedCapabilities() {
        return (List)this.getCapabilitySelectors().stream().map(c -> {
            if (c instanceof SpecificCapabilitySelector) {
                return ((DefaultSpecificCapabilitySelector)c).getBackingCapability();
            }
            if (c instanceof FeatureCapabilitySelector) {
                return new ProjectDerivedCapability(this.unsafeGetProject(), ((FeatureCapabilitySelector)c).getFeatureName());
            }
            throw new UnsupportedOperationException("Unsupported capability selector type: " + c.getClass().getName());
        }).collect(ImmutableList.toImmutableList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDependency that = (DefaultProjectDependency)((Object)o);
        return this.getTargetProjectIdentity().equals((Object)that.getTargetProjectIdentity()) && this.isCommonContentEquals((ModuleDependency)that);
    }

    public int hashCode() {
        int hashCode = this.getTargetProjectIdentity().hashCode();
        if (this.getTargetConfiguration() != null) {
            hashCode = 31 * hashCode + this.getTargetConfiguration().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return "project '" + this.getTargetProjectIdentity().getBuildTreePath() + "'";
    }

    @Deprecated
    private ProjectInternal unsafeGetProject() {
        return this.projectState.getMutableModel();
    }
}

