/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scripts;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class ScriptResolutionResult {
    private final File directory;
    private final String basename;
    private final @Nullable File selectedCandidate;
    private final List<File> ignoredCandidates;

    public ScriptResolutionResult(File directory, String basename, @Nullable File selectedCandidate, List<File> ignoredCandidates) {
        this.directory = directory;
        this.basename = basename;
        this.selectedCandidate = selectedCandidate;
        this.ignoredCandidates = Collections.unmodifiableList(ignoredCandidates);
    }

    public @Nullable File getSelectedCandidate() {
        return this.selectedCandidate;
    }

    public boolean isScriptFound() {
        return this.selectedCandidate != null;
    }

    public List<File> getIgnoredCandidates() {
        return this.ignoredCandidates;
    }

    public String getBasename() {
        return this.basename;
    }

    public File getDirectory() {
        return this.directory;
    }

    public static ScriptResolutionResult fromSingleFile(String basename, File scriptFile) {
        Objects.requireNonNull(basename);
        Objects.requireNonNull(scriptFile);
        return new ScriptResolutionResult(scriptFile.getParentFile(), basename, scriptFile, Collections.emptyList());
    }
}

