/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.workspace.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.cache.FineGrainedCacheBuilder;
import org.gradle.cache.FineGrainedCacheCleanupStrategy;
import org.gradle.cache.FineGrainedCacheCleanupStrategyFactory;
import org.gradle.cache.FineGrainedMarkAndSweepCacheCleanupStrategy;
import org.gradle.cache.FineGrainedPersistentCache;
import org.gradle.internal.Cast;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;

public class CacheBasedImmutableWorkspaceProvider
implements ImmutableWorkspaceProvider,
Closeable {
    private final FileAccessTracker fileAccessTracker;
    private final FineGrainedPersistentCache cache;
    private final FineGrainedMarkAndSweepCacheCleanupStrategy.FineGrainedCacheEntrySoftDeleter softDeleter;
    private final Map<String, CompletableFuture<?>> workspaceResults;

    @VisibleForTesting
    public CacheBasedImmutableWorkspaceProvider(SingleDepthFileAccessTracker fileAccessTracker, FineGrainedPersistentCache cache, FineGrainedMarkAndSweepCacheCleanupStrategy cleanupStrategy) {
        this.softDeleter = cleanupStrategy.getSoftDeleter(cache);
        this.cache = cache;
        this.fileAccessTracker = fileAccessTracker;
        this.workspaceResults = new ConcurrentHashMap();
    }

    @Override
    public ImmutableWorkspaceProvider.ImmutableWorkspace getWorkspace(final String path) {
        final File workspace = new File(this.cache.getBaseDir(), path);
        this.fileAccessTracker.markAccessed(workspace);
        return new ImmutableWorkspaceProvider.ImmutableWorkspace(){

            @Override
            public File getImmutableLocation() {
                return workspace;
            }

            @Override
            public <T> T withFileLock(Supplier<T> action) {
                return (T)CacheBasedImmutableWorkspaceProvider.this.cache.withFileLock(path, action);
            }

            @Override
            public <T> ImmutableWorkspaceProvider.ConcurrentResult<T> getOrCompute(Supplier<T> action) {
                CompletableFuture<T> thisOperationFuture = new CompletableFuture<T>();
                CompletableFuture runningOperationFuture = (CompletableFuture)Cast.uncheckedCast(CacheBasedImmutableWorkspaceProvider.this.workspaceResults.putIfAbsent(path, thisOperationFuture));
                if (runningOperationFuture != null) {
                    return ImmutableWorkspaceProvider.ConcurrentResult.producedByOtherThread(runningOperationFuture.join());
                }
                try {
                    T result = action.get();
                    thisOperationFuture.complete(result);
                    ImmutableWorkspaceProvider.ConcurrentResult<T> concurrentResult = ImmutableWorkspaceProvider.ConcurrentResult.producedByCurrentThread(result);
                    return concurrentResult;
                }
                catch (Exception e) {
                    thisOperationFuture.completeExceptionally(e);
                    throw e;
                }
                finally {
                    CacheBasedImmutableWorkspaceProvider.this.workspaceResults.remove(path);
                }
            }

            @Override
            public boolean isSoftDeleted() {
                return CacheBasedImmutableWorkspaceProvider.this.softDeleter.isSoftDeleted(path);
            }

            @Override
            public void ensureUnSoftDeleted() {
                CacheBasedImmutableWorkspaceProvider.this.softDeleter.removeSoftDeleteMarker(path);
            }
        };
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public static CacheBasedImmutableWorkspaceProvider createWorkspaceProvider(FineGrainedCacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, CacheConfigurationsInternal cacheConfigurations, FineGrainedCacheCleanupStrategyFactory cacheCleanupStrategyFactory) {
        FineGrainedMarkAndSweepCacheCleanupStrategy markAndSweepCleanupStrategy = cacheCleanupStrategyFactory.markAndSweepCleanupStrategy(cacheConfigurations.getCreatedResources().getEntryRetentionTimestampSupplier(), () -> ((Provider)cacheConfigurations.getCleanupFrequency()).get());
        FineGrainedPersistentCache cache = cacheBuilder.withCleanupStrategy((FineGrainedCacheCleanupStrategy)markAndSweepCleanupStrategy).open();
        SingleDepthFileAccessTracker fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, cache.getBaseDir(), 1);
        return new CacheBasedImmutableWorkspaceProvider(fileAccessTracker, cache, markAndSweepCleanupStrategy);
    }
}

