/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class FileBasedInstallationFactory {
    public static Set<InstallationLocation> fromDirectory(File rootDirectory, String supplierName, BiFunction<File, String, InstallationLocation> locationFactory) {
        File[] javaCandidates = rootDirectory.listFiles();
        if (javaCandidates == null) {
            return Collections.emptySet();
        }
        return Stream.of(javaCandidates).filter(File::isDirectory).map(d -> (InstallationLocation)locationFactory.apply((File)d, supplierName)).collect(Collectors.toSet());
    }
}

