/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Global.class})
public interface ModuleRegistry {
    public @Nullable Module findModule(String var1);

    public Module getModule(String var1) throws UnknownModuleException;

    default public List<Module> getRuntimeModules(Iterable<Module> roots) {
        HashSet<String> seen = new HashSet<String>();
        ArrayDeque<Module> queue = new ArrayDeque<Module>();
        for (Module root : roots) {
            if (!seen.add(root.getName())) continue;
            queue.add(root);
        }
        ArrayList<Module> result = new ArrayList<Module>();
        while (!queue.isEmpty()) {
            Module module = (Module)queue.remove();
            result.add(module);
            for (String name : module.getDependencyNames()) {
                if (!seen.add(name)) continue;
                Module dependency = this.getModule(name);
                queue.add(dependency);
            }
        }
        return result;
    }

    default public ClassPath getRuntimeClasspath(Iterable<Module> roots) {
        ClassPath cp = ClassPath.EMPTY;
        for (Module module : this.getRuntimeModules(roots)) {
            cp = cp.plus(module.getImplementationClasspath());
        }
        return cp;
    }

    default public ClassPath getRuntimeClasspath(String moduleName) {
        return this.getRuntimeClasspath(Collections.singleton(this.getModule(moduleName)));
    }
}

