/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;

public final class MessageBuilderHelper {
    private MessageBuilderHelper() {
    }

    public static List<String> formattedPathsTo(DependencyGraphEdge edge) {
        return MessageBuilderHelper.findPathsTo(edge).stream().map(path -> {
            String header = ((DependencyGraphEdge)Iterables.getLast((Iterable)path)).getDependencyMetadata().isConstraint() ? "Constraint" : "Dependency";
            String formattedPath = MessageBuilderHelper.streamNodeNames(path).collect(Collectors.joining(" --> "));
            return header + " path: " + formattedPath;
        }).collect(Collectors.toList());
    }

    public static ImmutableList<ImmutableList<String>> findPathNamesTo(DependencyGraphEdge edge) {
        return (ImmutableList)MessageBuilderHelper.findPathsTo(edge).stream().map(p -> (ImmutableList)MessageBuilderHelper.streamNodeNames(p).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
    }

    public static List<List<DependencyGraphEdge>> findPathsTo(DependencyGraphEdge edge) {
        ArrayList<List<DependencyGraphEdge>> acc = new ArrayList<List<DependencyGraphEdge>>(1);
        MessageBuilderHelper.pathTo(edge, new ArrayList<DependencyGraphEdge>(), acc, new HashSet<DependencyGraphNode>());
        return acc;
    }

    private static void pathTo(DependencyGraphEdge edge, List<DependencyGraphEdge> currentPath, List<List<DependencyGraphEdge>> accumulator, Set<DependencyGraphNode> alreadySeen) {
        DependencyGraphNode from = edge.getFrom();
        if (alreadySeen.add(from)) {
            currentPath.add(edge);
            Collection<? extends DependencyGraphEdge> incomingEdges = from.getIncomingEdges();
            if (!incomingEdges.isEmpty()) {
                for (DependencyGraphEdge dependencyGraphEdge : incomingEdges) {
                    ArrayList<DependencyGraphEdge> otherPath = new ArrayList<DependencyGraphEdge>(currentPath);
                    MessageBuilderHelper.pathTo(dependencyGraphEdge, otherPath, accumulator, alreadySeen);
                }
            } else {
                accumulator.add(Lists.reverse(currentPath));
            }
        }
    }

    private static Stream<String> streamNodeNames(List<DependencyGraphEdge> path) {
        return path.stream().map(edge -> edge.getFrom().getDisplayName());
    }
}

