/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u000f\u001a\n\u0010\u0015\u001a\u00020\u000e*\u00020\u0016\u001a\u001b\u0010\u0017\u001a\u00020\u000e*\u00020\u000f\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0004*\u00020\u000f\u001a\n\u0010\u0019\u001a\u00020\u000e*\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u000e*\u00020\u001a\u001a\r\u0010\u001c\u001a\u00020\u001d*\u00020\u000fH\u0086\u0010\u00f2\u0001\u0004\n\u00020\u0001\u00a8\u0006\u001e"}, d2={"resolveClassByFqName", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "lookupLocation", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "findContinuationClassDescriptorOrNull", "findContinuationClassDescriptor", "getContinuationOfTypeOrAny", "Lorg/jetbrains/kotlin/types/SimpleType;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isTopLevelInPackage", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "name", "", "packageName", "getTopLevelContainingClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "isSupportedForCallableReference", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isSealed", "containingPackage", "isTypedEqualsInValueClass", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "overridesEqualsFromAny", "findPackage", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "descriptors"})
@SourceDebugExtension(value={"SMAP\ndescriptorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 descriptorUtil.kt\norg/jetbrains/kotlin/descriptors/DescriptorUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,113:1\n1#2:114\n19#3:115\n*S KotlinDebug\n*F\n+ 1 descriptorUtil.kt\norg/jetbrains/kotlin/descriptors/DescriptorUtilKt\n*L\n38#1:115\n*E\n"})
public final class DescriptorUtilKt {
    @Nullable
    public static final ClassDescriptor resolveClassByFqName(@NotNull ModuleDescriptor $this$resolveClassByFqName, @NotNull FqName fqName, @NotNull LookupLocation lookupLocation) {
        MemberScope memberScope2;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$resolveClassByFqName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        if (fqName.isRoot()) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor = $this$resolveClassByFqName.getPackage(fqName.parent()).getMemberScope().getContributedClassifier(fqName.shortName(), lookupLocation);
        ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor != null) {
            ClassDescriptor it = classDescriptor;
            boolean bl = false;
            return it;
        }
        classifierDescriptor = DescriptorUtilKt.resolveClassByFqName($this$resolveClassByFqName, fqName.parent(), lookupLocation);
        classDescriptor = classifierDescriptor != null && (memberScope2 = classifierDescriptor.getUnsubstitutedInnerClassesScope()) != null ? memberScope2.getContributedClassifier(fqName.shortName(), lookupLocation) : null;
        return classDescriptor instanceof ClassDescriptor ? classDescriptor : null;
    }

    @Nullable
    public static final ClassDescriptor findContinuationClassDescriptorOrNull(@NotNull ModuleDescriptor $this$findContinuationClassDescriptorOrNull, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$findContinuationClassDescriptorOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        return DescriptorUtilKt.resolveClassByFqName($this$findContinuationClassDescriptorOrNull, StandardNames.CONTINUATION_INTERFACE_FQ_NAME, lookupLocation);
    }

    @NotNull
    public static final ClassDescriptor findContinuationClassDescriptor(@NotNull ModuleDescriptor $this$findContinuationClassDescriptor, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$findContinuationClassDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        ClassDescriptor $this$sure$iv = DescriptorUtilKt.findContinuationClassDescriptorOrNull($this$findContinuationClassDescriptor, lookupLocation);
        boolean $i$f$sure = false;
        ClassDescriptor classDescriptor = $this$sure$iv;
        if (classDescriptor == null) {
            boolean bl = false;
            String string = "Continuation interface is not found";
            throw new AssertionError((Object)string);
        }
        return classDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final SimpleType getContinuationOfTypeOrAny(@NotNull ModuleDescriptor $this$getContinuationOfTypeOrAny, @NotNull KotlinType kotlinType) {
        SimpleType simpleType;
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter((Object)$this$getContinuationOfTypeOrAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        ClassDescriptor classDescriptor = DescriptorUtilKt.findContinuationClassDescriptorOrNull(DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny), NoLookupLocation.FROM_DESERIALIZATION);
        if (classDescriptor != null && (simpleType2 = classDescriptor.getDefaultType()) != null) {
            SimpleType it = simpleType2;
            boolean bl = false;
            SimpleType simpleType3 = KotlinTypeFactory.simpleType$default(it, null, null, CollectionsKt.listOf((Object)TypeUtilsKt.asTypeProjection(kotlinType)), false, 22, null);
            if (simpleType3 != null) {
                simpleType = simpleType3;
                return simpleType;
            }
        }
        SimpleType simpleType4 = DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny).getBuiltIns().getNullableAnyType();
        simpleType = simpleType4;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"getNullableAnyType(...)");
        return simpleType;
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage, @NotNull String name2, @NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelInPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        if (!Intrinsics.areEqual((Object)name2, (Object)$this$isTopLevelInPackage.getName().asString())) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = $this$isTopLevelInPackage.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor containingDeclaration = packageFragmentDescriptor;
        String packageFqName = containingDeclaration.getFqName().asString();
        return Intrinsics.areEqual((Object)packageName2, (Object)packageFqName);
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelInPackage, (String)"<this>");
        return $this$isTopLevelInPackage.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    @Nullable
    public static final ClassifierDescriptor getTopLevelContainingClassifier(@NotNull DeclarationDescriptor $this$getTopLevelContainingClassifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelContainingClassifier, (String)"<this>");
        DeclarationDescriptor containingDeclaration = $this$getTopLevelContainingClassifier.getContainingDeclaration();
        if (containingDeclaration == null || $this$getTopLevelContainingClassifier instanceof PackageFragmentDescriptor) {
            return null;
        }
        return !DescriptorUtilKt.isTopLevelInPackage(containingDeclaration) ? DescriptorUtilKt.getTopLevelContainingClassifier(containingDeclaration) : (containingDeclaration instanceof ClassifierDescriptor ? (ClassifierDescriptor)containingDeclaration : null);
    }

    public static final boolean isSupportedForCallableReference(@NotNull CallableDescriptor $this$isSupportedForCallableReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupportedForCallableReference, (String)"<this>");
        return $this$isSupportedForCallableReference instanceof PropertyDescriptor || $this$isSupportedForCallableReference instanceof FunctionDescriptor;
    }

    public static final boolean isSealed(@NotNull DeclarationDescriptor $this$isSealed) {
        Intrinsics.checkNotNullParameter((Object)$this$isSealed, (String)"<this>");
        return DescriptorUtils.isSealedClass($this$isSealed);
    }

    @Nullable
    public static final FqName containingPackage(@NotNull DeclarationDescriptor $this$containingPackage) {
        DeclarationDescriptor container;
        Intrinsics.checkNotNullParameter((Object)$this$containingPackage, (String)"<this>");
        for (container = $this$containingPackage.getContainingDeclaration(); container != null && !(container instanceof PackageFragmentDescriptor); container = container.getContainingDeclaration()) {
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)container;
        return packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTypedEqualsInValueClass(@NotNull FunctionDescriptor $this$isTypedEqualsInValueClass) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isTypedEqualsInValueClass, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$isTypedEqualsInValueClass.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        Annotated annotated = classDescriptor2;
        if (classDescriptor2 == null) return false;
        ClassDescriptor it = classDescriptor = annotated;
        boolean bl = false;
        if (!InlineClassesUtilsKt.isValueClass(it)) return false;
        ClassDescriptor classDescriptor3 = classDescriptor;
        annotated = classDescriptor3;
        if (classDescriptor3 == null) return false;
        SimpleType simpleType = annotated.getDefaultType();
        annotated = simpleType;
        if (simpleType == null) return false;
        if ((annotated = TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)annotated)) == null) {
            return false;
        }
        Annotated annotated2 = annotated;
        KotlinType kotlinType = $this$isTypedEqualsInValueClass.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        if (!Intrinsics.areEqual((Object)$this$isTypedEqualsInValueClass.getName(), (Object)OperatorNameConventions.EQUALS)) return false;
        if (!TypeUtilsKt.isBoolean(returnType)) {
            if (!TypeUtilsKt.isNothing(returnType)) return false;
        }
        if ($this$isTypedEqualsInValueClass.getValueParameters().size() != 1) return false;
        KotlinType kotlinType2 = $this$isTypedEqualsInValueClass.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        if (!Intrinsics.areEqual((Object)TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType2), (Object)annotated2)) return false;
        if (!$this$isTypedEqualsInValueClass.getContextReceiverParameters().isEmpty()) return false;
        if ($this$isTypedEqualsInValueClass.getExtensionReceiverParameter() != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean overridesEqualsFromAny(@NotNull FunctionDescriptor $this$overridesEqualsFromAny) {
        Intrinsics.checkNotNullParameter((Object)$this$overridesEqualsFromAny, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$overridesEqualsFromAny.getName(), (Object)OperatorNameConventions.EQUALS)) return false;
        if ($this$overridesEqualsFromAny.getValueParameters().size() != 1) return false;
        KotlinType kotlinType = $this$overridesEqualsFromAny.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        if (!TypeUtilsKt.isNullableAny(kotlinType)) return false;
        if (!$this$overridesEqualsFromAny.getContextReceiverParameters().isEmpty()) return false;
        if ($this$overridesEqualsFromAny.getExtensionReceiverParameter() != null) return false;
        return true;
    }

    @NotNull
    public static final PackageFragmentDescriptor findPackage(@NotNull DeclarationDescriptor $this$findPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$findPackage, (String)"<this>");
        while (!($this$findPackage instanceof PackageFragmentDescriptor)) {
            Intrinsics.checkNotNull((Object)$this$findPackage.getContainingDeclaration());
        }
        return (PackageFragmentDescriptor)$this$findPackage;
    }
}

