/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0010H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "originalBounds", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "unwrapBound", "extractTypeParamSymbols", "ref", "extractTypeParamSymbol", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCyclicTypeBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCyclicTypeBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n832#2:79\n862#2,2:80\n1915#2,2:83\n777#2:85\n873#2,2:86\n1642#2,10:88\n1915#2:98\n1916#2:100\n1652#2:101\n1915#2,2:102\n1391#2:104\n1480#2,5:105\n1642#2,10:110\n1915#2:120\n1916#2:122\n1652#2:123\n1391#2:124\n1480#2,5:125\n1915#2,2:130\n759#2,10:132\n1#3:82\n1#3:99\n1#3:121\n*S KotlinDebug\n*F\n+ 1 FirCyclicTypeBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker\n*L\n25#1:79\n25#1:80,2\n45#1:83,2\n51#1:85\n51#1:86,2\n51#1:88,10\n51#1:98\n51#1:100\n51#1:101\n55#1:102,2\n62#1:104\n62#1:105,5\n73#1:110,10\n73#1:120\n73#1:122\n73#1:123\n35#1:124\n35#1:125,5\n36#1:130,2\n41#1:132,10\n51#1:99\n73#1:121\n*E\n"})
public final class FirCyclicTypeBoundsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirCyclicTypeBoundsChecker INSTANCE = new FirCyclicTypeBoundsChecker();

    private FirCyclicTypeBoundsChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        if (declaration instanceof FirConstructor || declaration instanceof FirTypeAlias) {
            return;
        }
        Iterable $this$filterNot$iv = ((FirMemberDeclaration)declaration).getTypeParameters();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirTypeParameterRef it = (FirTypeParameterRef)element$iv$iv;
            boolean bl = false;
            if (it instanceof FirOuterClassTypeParameterRef) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable it = $this$filterNot$iv = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = !((Collection)it).isEmpty() ? $this$filterNot$iv : null;
        if (iterable2 == null) {
            return;
        }
        Iterable actualTypeParameters = iterable2;
        Set processed = new LinkedHashSet();
        List typeParameterCycles = new ArrayList();
        List path = new ArrayList();
        Iterable $this$forEach$iv = actualTypeParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameterRef param = (FirTypeParameterRef)element$iv;
            boolean bl2 = false;
            FirCyclicTypeBoundsChecker.check$findCycles(processed, path, typeParameterCycles, param.getSymbol());
        }
        for (List typeParameterCycle : typeParameterCycles) {
            for (FirTypeParameterSymbol typeParameter : typeParameterCycle) {
                List list;
                if (declaration instanceof FirRegularClass) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.originalBounds(typeParameter);
                    boolean $i$f$filter = false;
                    Iterable iterable3 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        FirTypeRef it2 = (FirTypeRef)element$iv$iv;
                        boolean bl3 = false;
                        if (!CollectionsKt.contains((Iterable)typeParameterCycle, (Object)INSTANCE.extractTypeParamSymbol(FirTypeUtilsKt.getConeType(it2)))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        KtSourceElement it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl4 = false;
                        FirTypeRef it3 = (FirTypeRef)element$iv$iv;
                        boolean bl5 = false;
                        if (it3.getSource() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.listOf((Object)typeParameter.getSource());
                }
                List targets = list;
                Iterable $this$forEach$iv2 = targets;
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    KtSourceElement it4 = (KtSourceElement)element$iv;
                    boolean bl7 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it4, FirErrors.INSTANCE.getCYCLIC_GENERIC_UPPER_BOUND(), (Object)typeParameterCycle, null, 16, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeRef> originalBounds(FirTypeParameterSymbol $this$originalBounds) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$originalBounds.getResolvedBounds();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.unwrapBound(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<FirTypeRef> unwrapBound(FirTypeRef $this$unwrapBound) {
        List list;
        if ($this$unwrapBound instanceof FirErrorTypeRef && ((FirErrorTypeRef)$this$unwrapBound).getDiagnostic() instanceof ConeCyclicTypeBound) {
            ConeDiagnostic coneDiagnostic = ((FirErrorTypeRef)$this$unwrapBound).getDiagnostic();
            Intrinsics.checkNotNull((Object)coneDiagnostic, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound");
            list = ((ConeCyclicTypeBound)coneDiagnostic).getBounds();
        } else {
            list = CollectionsKt.listOf((Object)$this$unwrapBound);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeParameterSymbol> extractTypeParamSymbols(FirTypeRef ref) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.unwrapBound(ref);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirTypeParameterSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.extractTypeParamSymbol(FirTypeUtilsKt.getConeType(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final FirTypeParameterSymbol extractTypeParamSymbol(ConeKotlinType type) {
        ConeSimpleKotlinType coneSimpleKotlinType = ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(type);
        Object object = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
        return object != null && (object = ((ConeTypeParameterType)object).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void check$findCycles(Set<FirTypeParameterSymbol> processed, List<FirTypeParameterSymbol> path, List<List<FirTypeParameterSymbol>> typeParameterCycles, FirTypeParameterSymbol typeParameterSymbol) {
        if (processed.add(typeParameterSymbol)) {
            Iterator $this$flatMapTo$iv$iv;
            path.add(typeParameterSymbol);
            Iterable $this$flatMap$iv = typeParameterSymbol.getResolvedBounds();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.extractTypeParamSymbols(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Set resolvedBounds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$forEach$iv = resolvedBounds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                boolean bl = false;
                FirCyclicTypeBoundsChecker.check$findCycles(processed, path, typeParameterCycles, it);
            }
            path.remove(path.size() - 1);
        } else if (!((Collection)path).isEmpty()) {
            void $this$dropWhile$iv;
            Iterable resolvedBounds = path;
            List<List<FirTypeParameterSymbol>> list = typeParameterCycles;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                FirTypeParameterSymbol it = (FirTypeParameterSymbol)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)typeParameterSymbol)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            list.add(list$iv);
        }
    }
}

