/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.LoadedKlibs;
import org.jetbrains.kotlin.backend.common.serialization.CityHashKt;
import org.jetbrains.kotlin.backend.common.serialization.Hash128Bits;
import org.jetbrains.kotlin.backend.common.serialization.IrInterningService;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.LoadWebKlibsKt;
import org.jetbrains.kotlin.ir.backend.js.ic.DirtyFileExports;
import org.jetbrains.kotlin.ir.backend.js.ic.DirtyFileMetadata;
import org.jetbrains.kotlin.ir.backend.js.ic.DirtyFileState;
import org.jetbrains.kotlin.ir.backend.js.ic.FileSignatureProvider;
import org.jetbrains.kotlin.ir.backend.js.ic.ICHash;
import org.jetbrains.kotlin.ir.backend.js.ic.ICHasher;
import org.jetbrains.kotlin.ir.backend.js.ic.ICUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.ic.IdSignatureHashCalculator;
import org.jetbrains.kotlin.ir.backend.js.ic.IdSignatureSource;
import org.jetbrains.kotlin.ir.backend.js.ic.IdSignatureSourceKt;
import org.jetbrains.kotlin.ir.backend.js.ic.ImportedSignaturesState;
import org.jetbrains.kotlin.ir.backend.js.ic.IncrementalCache;
import org.jetbrains.kotlin.ir.backend.js.ic.IncrementalCacheArtifact;
import org.jetbrains.kotlin.ir.backend.js.ic.IrCompilerICInterface;
import org.jetbrains.kotlin.ir.backend.js.ic.IrICProgramFragments;
import org.jetbrains.kotlin.ir.backend.js.ic.JsIrLinkerLoader;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinLibraryFile;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinLoadedLibraryHeader;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinRemovedLibraryHeader;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFile;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileExports;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMap;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMetadata;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMetadataKt;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMetadataNotExist;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFileMutableMap;
import org.jetbrains.kotlin.ir.backend.js.ic.LoadedJsIr;
import org.jetbrains.kotlin.ir.backend.js.ic.ModuleArtifact;
import org.jetbrains.kotlin.ir.backend.js.ic.PlatformDependentICContext;
import org.jetbrains.kotlin.ir.backend.js.ic.StopwatchIC;
import org.jetbrains.kotlin.ir.backend.js.ic.UpdatedDependenciesMetadata;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.loader.KlibPlatformChecker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003ABCB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u001dJ\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0 0\u001fJ.\u0010\"\u001a\u00020#*\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110$2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u0012H\u0002JD\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001f2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020,0+2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00030+2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001dH\u0002JP\u00100\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0302012\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020%090+H\u0002J\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020=H\u0002J4\u0010>\u001a\b\u0012\u0004\u0012\u00020/0\u001d2$\u0010?\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020/030201H\u0002J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020)0\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater;", "", "cacheDir", "", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "icContext", "Lorg/jetbrains/kotlin/ir/backend/js/ic/PlatformDependentICContext;", "checkForClassStructuralChanges", "", "commitIncrementalCache", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/ir/backend/js/ic/PlatformDependentICContext;ZZ)V", "stopwatch", "Lorg/jetbrains/kotlin/ir/backend/js/ic/StopwatchIC;", "dirtyFileStats", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMutableMap;", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/DirtyFileState;", "mainLibraryFile", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryFile;", "Ljava/lang/String;", "icHasher", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHasher;", "irInterner", "Lorg/jetbrains/kotlin/backend/common/serialization/IrInterningService;", "cacheRootDir", "Ljava/io/File;", "getDirtyFileLastStats", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap;", "getStopwatchLastLaps", "", "Lkotlin/Pair;", "", "addDirtFileStat", "", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;", "srcFile", "state", "commitCacheAndBuildModuleArtifacts", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact;", "incrementalCacheArtifacts", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheArtifact;", "moduleNames", "rebuiltFileFragments", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IrICProgramFragments;", "compileDirtyFiles", "", "Lkotlin/Triple;", "Lkotlin/Function0;", "compilerForIC", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IrCompilerICInterface;", "loadedIr", "Lorg/jetbrains/kotlin/ir/backend/js/ic/LoadedJsIr;", "dirtyFiles", "", "loadIrForDirtyFilesAndInitCompiler", "Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater$IrForDirtyFilesAndCompiler;", "loadIrAndMakeIrFragmentGenerators", "Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater$FragmentGenerators;", "generateIrFragments", "generators", "actualizeCaches", "CacheUpdaterInternal", "IrForDirtyFilesAndCompiler", "FragmentGenerators", "backend.js"})
@SourceDebugExtension(value={"SMAP\nCacheUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheUpdater.kt\norg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater\n+ 2 ICUtils.kt\norg/jetbrains/kotlin/ir/backend/js/ic/StopwatchIC\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,877:1\n110#2,2:878\n112#2,2:884\n110#2,2:886\n112#2,2:892\n110#2,4:904\n129#3:880\n158#3,3:881\n1629#4,4:888\n1282#4,4:894\n1205#4,2:898\n1282#4,4:900\n*S KotlinDebug\n*F\n+ 1 CacheUpdater.kt\norg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater\n*L\n652#1:878,2\n652#1:884,2\n674#1:886,2\n674#1:892,2\n796#1:904,4\n653#1:880\n653#1:881,3\n691#1:888,4\n764#1:894,4\n787#1:898,2\n787#1:900,4\n*E\n"})
public final class CacheUpdater {
    @NotNull
    private final CompilerConfiguration compilerConfiguration;
    @NotNull
    private final PlatformDependentICContext icContext;
    private final boolean commitIncrementalCache;
    @NotNull
    private final StopwatchIC stopwatch;
    @NotNull
    private final KotlinSourceFileMutableMap<EnumSet<DirtyFileState>> dirtyFileStats;
    @NotNull
    private final String mainLibraryFile;
    @NotNull
    private final ICHasher icHasher;
    @NotNull
    private final IrInterningService irInterner;
    @NotNull
    private final File cacheRootDir;

    /*
     * WARNING - void declaration
     */
    public CacheUpdater(@NotNull String cacheDir, @NotNull CompilerConfiguration compilerConfiguration, @NotNull PlatformDependentICContext icContext, boolean checkForClassStructuralChanges, boolean commitIncrementalCache) {
        void $this$cacheRootDir_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        this.compilerConfiguration = compilerConfiguration;
        this.icContext = icContext;
        this.commitIncrementalCache = commitIncrementalCache;
        this.stopwatch = new StopwatchIC();
        this.dirtyFileStats = new KotlinSourceFileMutableMap(null, 1, null);
        String string = JSConfigurationKeysKt.getIncludes(this.compilerConfiguration);
        Intrinsics.checkNotNull((Object)string);
        String string2 = new File(string).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
        this.mainLibraryFile = KotlinLibraryFile.constructor-impl(string2);
        this.icHasher = new ICHasher(checkForClassStructuralChanges);
        this.irInterner = new IrInterningService();
        CacheUpdater cacheUpdater = this;
        CacheUpdater cacheUpdater2 = this;
        boolean bl = false;
        Hash128Bits configHash = $this$cacheRootDir_u24lambda_u240.icHasher.calculateConfigHash-TVZkk9w($this$cacheRootDir_u24lambda_u240.compilerConfiguration);
        cacheUpdater2.cacheRootDir = new File(cacheDir, "version." + UStringsKt.toString-JSWoG40((long)configHash.getLowBytes-s-VKNKU(), (int)36));
    }

    public /* synthetic */ CacheUpdater(String string, CompilerConfiguration compilerConfiguration, PlatformDependentICContext platformDependentICContext, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        this(string, compilerConfiguration, platformDependentICContext, bl, bl2);
    }

    @NotNull
    public final KotlinSourceFileMap<EnumSet<DirtyFileState>> getDirtyFileLastStats() {
        return this.dirtyFileStats;
    }

    @NotNull
    public final List<Pair<String, Long>> getStopwatchLastLaps() {
        return this.stopwatch.getLaps();
    }

    private final void addDirtFileStat(Map<KotlinSourceFile, EnumSet<DirtyFileState>> $this$addDirtFileStat, KotlinSourceFile srcFile, DirtyFileState state) {
        EnumSet<DirtyFileState> stats = $this$addDirtFileStat.get(srcFile);
        if (stats == null) {
            $this$addDirtFileStat.put(srcFile, EnumSet.of((Enum)state));
        } else {
            stats.add(state);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModuleArtifact> commitCacheAndBuildModuleArtifacts(Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCacheArtifacts, Map<KotlinLibraryFile, String> moduleNames, KotlinSourceFileMap<? extends IrICProgramFragments> rebuiltFileFragments) {
        void $this$mapTo$iv$iv;
        void this_$iv;
        StopwatchIC stopwatchIC = this.stopwatch;
        String description$iv = "Incremental cache - committing artifacts";
        boolean $i$f$measure = false;
        this_$iv.startNext(description$iv);
        boolean bl = false;
        Map<KotlinLibraryFile, IncrementalCacheArtifact> $this$map$iv = incrementalCacheArtifacts;
        boolean $i$f$map = false;
        Map<KotlinLibraryFile, IncrementalCacheArtifact> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map rebuildFileFragments;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String libFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
            IncrementalCacheArtifact incrementalCacheArtifact = (IncrementalCacheArtifact)entry.getValue();
            Map map2 = rebuiltFileFragments.get-5h9WozY(libFile);
            if (map2 == null) {
                map2 = rebuildFileFragments = MapsKt.emptyMap();
            }
            if (this.commitIncrementalCache) {
                incrementalCacheArtifact.commitCache(rebuildFileFragments, this.icContext);
            }
            String string = moduleNames.get(KotlinLibraryFile.box-impl(libFile));
            if (string == null) {
                ICUtilsKt.notFoundIcError-5vrbIOY$default("module name", libFile, null, 4, null);
                throw new KotlinNothingValueException();
            }
            collection.add(incrementalCacheArtifact.buildModuleArtifact(string, rebuildFileFragments, this.icContext));
        }
        List result$iv = (List)destination$iv$iv;
        StopwatchIC.stop$default((StopwatchIC)this_$iv, null, 1, null);
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> compileDirtyFiles(IrCompilerICInterface compilerForIC, LoadedJsIr loadedIr, Map<KotlinLibraryFile, ? extends Set<KotlinSourceFile>> dirtyFiles) {
        Object srcFile;
        void this_$iv;
        StopwatchIC stopwatchIC = this.stopwatch;
        String description$iv = "Processing IR - lowering";
        boolean $i$f$measure = false;
        this_$iv.startNext(description$iv);
        boolean bl = false;
        List dirtyFilesForCompiling = new ArrayList();
        List dirtyFilesForRestoring = new ArrayList();
        for (Map.Entry<KotlinLibraryFile, IrModuleFragment> object2 : loadedIr.getOrderedFragments().entrySet()) {
            String libFile = object2.getKey().unbox-impl();
            IrModuleFragment libFragment = object2.getValue();
            if (dirtyFiles.get(KotlinLibraryFile.box-impl(libFile)) == null) continue;
            Map<IrFile, KotlinSourceFile> sourceNames = loadedIr.getIrFileNames(libFragment);
            for (IrFile irFile : libFragment.getFiles()) {
                Set<KotlinSourceFile> dirtySrcFiles;
                if (sourceNames.get(irFile) == null) {
                    ICUtilsKt.notFoundIcError-SdI_NTg("source file name", libFile, irFile);
                    throw new KotlinNothingValueException();
                }
                if (!dirtySrcFiles.contains(srcFile)) continue;
                ((Collection)dirtyFilesForCompiling).add(irFile);
                ((Collection)dirtyFilesForRestoring).add(TuplesKt.to((Object)KotlinLibraryFile.box-impl(libFile), (Object)srcFile));
            }
        }
        List<Function0<IrICProgramFragments>> fragmentGenerators = compilerForIC.compile(loadedIr.getOrderedFragments().values(), dirtyFilesForCompiling);
        Iterable iterable = dirtyFilesForRestoring;
        Collection destination$iv = new ArrayList(dirtyFilesForRestoring.size());
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : iterable) {
            void i2;
            void libFileAndSrcFile;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            srcFile = (Pair)item$iv;
            int n3 = n2;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(new Triple(libFileAndSrcFile.getFirst(), libFileAndSrcFile.getSecond(), fragmentGenerators.get((int)i2)));
        }
        ArrayList result$iv = (ArrayList)destination$iv;
        StopwatchIC.stop$default((StopwatchIC)this_$iv, null, 1, null);
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrForDirtyFilesAndCompiler loadIrForDirtyFilesAndInitCompiler() {
        void $this$associateTo$iv;
        Object filesWithUpdatedStubbedSymbolsToRebuild;
        CacheUpdaterInternal updater = new CacheUpdaterInternal();
        this.stopwatch.startNext("Modified files - checking hashes and collecting");
        KotlinSourceFileMap<KotlinSourceFileMetadata> modifiedFiles = updater.loadModifiedFiles();
        this.stopwatch.startNext("Modified files - collecting exported signatures");
        KotlinSourceFileMutableMap<KotlinSourceFileExports> dirtyFileExports = updater.collectExportedSymbolsForDirtyFiles(modifiedFiles);
        Set<IdSignature> stubbedSignatures = updater.collectStubbedSignatures();
        this.stopwatch.startNext("Modified files - loading and linking IR");
        JsIrLinkerLoader jsIrLinkerLoader = new JsIrLinkerLoader(this.compilerConfiguration, updater.getOrderedLibraries(), (Collection<? extends KotlinLibrary>)updater.getMainModuleFriendLibraries(), this.icContext.createIrFactory(), stubbedSignatures);
        LoadedJsIr loadedIr = JsIrLinkerLoader.loadIr$default(jsIrLinkerLoader, dirtyFileExports, false, 2, null);
        int iterations = 0;
        KotlinSourceFileMap<KotlinSourceFileExports> lastDirtyFiles = (KotlinSourceFileMap<KotlinSourceFileExports>)dirtyFileExports;
        while (true) {
            this.stopwatch.startNext("Dependencies (" + iterations + ") - updating a dependency graph");
            KotlinSourceFileMap<DirtyFileMetadata> dirtyMetadata = updater.rebuildDirtySourceMetadata(loadedIr, (KotlinSourceFileMap<? extends KotlinSourceFileExports>)lastDirtyFiles);
            this.stopwatch.startNext("Dependencies (" + iterations + ") - collecting files with updated exports and imports");
            KotlinSourceFileMap<UpdatedDependenciesMetadata> filesWithModifiedExportsOrImports = updater.collectFilesWithModifiedExportsAndImports(dirtyMetadata);
            this.stopwatch.startNext("Dependencies (" + iterations + ") - collecting exported signatures for files with updated exports and imports");
            KotlinSourceFileMap<KotlinSourceFileExports> filesToRebuild = updater.collectFilesToRebuildSignatures(filesWithModifiedExportsOrImports);
            dirtyFileExports.copyFilesFrom(filesToRebuild);
            this.stopwatch.startNext("Dependencies (" + iterations + ") - collecting files that contain updated stubbed symbols");
            filesWithUpdatedStubbedSymbolsToRebuild = updater.collectFilesWithUpdatedStubbedSymbols((KotlinSourceFileMap)dirtyFileExports);
            dirtyFileExports.copyFilesFrom((KotlinSourceFileMap<KotlinSourceFileExports>)filesWithUpdatedStubbedSymbolsToRebuild);
            lastDirtyFiles = KotlinSourceFileMetadataKt.combineWith(filesToRebuild, filesWithUpdatedStubbedSymbolsToRebuild);
            if (lastDirtyFiles.isEmpty()) break;
            this.stopwatch.startNext("Dependencies (" + iterations + ") - loading and linking IR for files with modified exports and imports");
            loadedIr = JsIrLinkerLoader.loadIr$default(jsIrLinkerLoader, lastDirtyFiles, false, 2, null);
            ++iterations;
        }
        if (iterations != 0) {
            this.stopwatch.startNext("Loading and linking all IR");
            loadedIr = JsIrLinkerLoader.loadIr$default(jsIrLinkerLoader, dirtyFileExports, false, 2, null);
        }
        this.stopwatch.startNext("Processing IR - initializing backend context");
        IrModuleFragment irModuleFragment = loadedIr.getOrderedFragments().get(KotlinLibraryFile.box-impl(this.mainLibraryFile));
        if (irModuleFragment == null) {
            ICUtilsKt.notFoundIcError-5vrbIOY$default("main module fragment", this.mainLibraryFile, null, 4, null);
            throw new KotlinNothingValueException();
        }
        IrModuleFragment mainModuleFragment = irModuleFragment;
        IrCompilerICInterface compilerForIC = this.icContext.createCompiler(mainModuleFragment, loadedIr.getIrBuiltIns(), this.compilerConfiguration);
        loadedIr.loadUnboundSymbols();
        filesWithUpdatedStubbedSymbolsToRebuild = dirtyFileExports.entrySet();
        Map destination$iv = org.jetbrains.kotlin.utils.CollectionsKt.newHashMapWithExpectedSize(dirtyFileExports.size());
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map = destination$iv;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), new HashSet(((Map)it.getValue()).keySet()));
            map.put(pair.getFirst(), pair.getSecond());
        }
        HashMap dirtyFiles = (HashMap)destination$iv;
        this.stopwatch.startNext("Processing IR - updating intrinsics and builtins dependencies");
        updater.updateStdlibIntrinsicDependencies(loadedIr, mainModuleFragment, dirtyFiles);
        this.stopwatch.startNext("Incremental cache - building artifacts");
        Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCachesArtifacts = updater.buildAndCommitCacheArtifacts(loadedIr);
        StopwatchIC.stop$default(this.stopwatch, null, 1, null);
        return new IrForDirtyFilesAndCompiler(incrementalCachesArtifacts, loadedIr, dirtyFiles, compilerForIC);
    }

    /*
     * WARNING - void declaration
     */
    private final FragmentGenerators loadIrAndMakeIrFragmentGenerators() {
        void $this$associateTo$iv$iv;
        IrForDirtyFilesAndCompiler irForDirtyFilesAndCompiler = this.loadIrForDirtyFilesAndInitCompiler();
        Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCachesArtifacts = irForDirtyFilesAndCompiler.component1();
        LoadedJsIr loadedIr = irForDirtyFilesAndCompiler.component2();
        Map<KotlinLibraryFile, Set<KotlinSourceFile>> dirtyFiles = irForDirtyFilesAndCompiler.component3();
        IrCompilerICInterface irCompiler = irForDirtyFilesAndCompiler.component4();
        Iterable $this$associate$iv = loadedIr.getOrderedFragments().entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), (Object)((IrModuleFragment)it.getValue()).getName().asString());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map moduleNames = destination$iv$iv;
        List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> rebuiltFragmentGenerators = this.compileDirtyFiles(irCompiler, loadedIr, dirtyFiles);
        return new FragmentGenerators(incrementalCachesArtifacts, moduleNames, rebuiltFragmentGenerators);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinSourceFileMap<IrICProgramFragments> generateIrFragments(List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> generators) {
        void this_$iv;
        StopwatchIC stopwatchIC = this.stopwatch;
        String description$iv = "Processing IR - generating program fragments";
        boolean $i$f$measure = false;
        this_$iv.startNext(description$iv);
        boolean bl = false;
        KotlinSourceFileMutableMap<Object> rebuiltFragments = new KotlinSourceFileMutableMap<Object>(null, 1, null);
        while (!((Collection)generators).isEmpty()) {
            Triple triple = (Triple)CollectionsKt.removeFirst(generators);
            String libFile = ((KotlinLibraryFile)triple.component1()).unbox-impl();
            KotlinSourceFile srcFile = (KotlinSourceFile)triple.component2();
            Function0 fragmentGenerator = (Function0)triple.component3();
            rebuiltFragments.set-wkabOcM(libFile, srcFile, fragmentGenerator.invoke());
        }
        KotlinSourceFileMutableMap<Object> result$iv = rebuiltFragments;
        StopwatchIC.stop$default((StopwatchIC)this_$iv, null, 1, null);
        return result$iv;
    }

    @NotNull
    public final List<ModuleArtifact> actualizeCaches() {
        this.stopwatch.clear();
        this.dirtyFileStats.clear();
        FragmentGenerators fragmentGenerators = this.loadIrAndMakeIrFragmentGenerators();
        Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCachesArtifacts = fragmentGenerators.component1();
        Map<KotlinLibraryFile, String> moduleNames = fragmentGenerators.component2();
        List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> generators = fragmentGenerators.component3();
        KotlinSourceFileMap<IrICProgramFragments> rebuiltFragments = this.generateIrFragments(generators);
        return this.commitCacheAndBuildModuleArtifacts(incrementalCachesArtifacts, moduleNames, rebuiltFragments);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'JI\u0010)\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020*0\u0014*\b\u0012\u0004\u0012\u00020+0 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\r2\u0006\u0010\u0019\u001a\u00020\u00152\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0'H\u0002\u00a2\u0006\u0004\b0\u00101JE\u00102\u001a\u000203*\u00020+2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020*0\u00142\f\u00105\u001a\b\u0012\u0004\u0012\u00020+0\u001d2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u00106\u001a\u00020/H\u0002\u00a2\u0006\u0004\b7\u00108J\"\u00109\u001a\b\u0012\u0004\u0012\u00020+0\u001d2\u0006\u0010:\u001a\u00020;2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020$0\u001dJ1\u0010<\u001a\u000203*\b\u0012\u0004\u0012\u00020=0 2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u00106\u001a\u00020/2\u0006\u0010>\u001a\u00020+H\u0002\u00a2\u0006\u0004\b?\u0010@J1\u0010A\u001a\u000203*\b\u0012\u0004\u0012\u00020=0 2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u00106\u001a\u00020/2\u0006\u0010>\u001a\u00020+H\u0002\u00a2\u0006\u0004\bB\u0010@J1\u0010C\u001a\u000203*\b\u0012\u0004\u0012\u00020=0 2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u00106\u001a\u00020/2\u0006\u0010>\u001a\u00020+H\u0002\u00a2\u0006\u0004\bD\u0010@J\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00020=0\u001d2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020+0\u001dJ\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020$0\u001d2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020=0\u001dJ\u0018\u0010I\u001a\b\u0012\u0004\u0012\u00020$0\u001d2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u001dJ0\u0010J\u001a\u0002032\u0006\u0010:\u001a\u00020;2\u0006\u0010K\u001a\u00020L2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0'0\u0014J\u001a\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020N0\u00142\u0006\u0010:\u001a\u00020;R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O\u00b2\u0006\u0016\u0010P\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001e0QX\u008a\u0084\u0002\u00b2\u0006\u001c\u0010R\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0S0QX\u008a\u0084\u0002\u00b2\u0006\u001c\u0010R\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0S0QX\u008a\u0084\u0002\u00b2\u0006\u0016\u0010U\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020$0QX\u008a\u0084\u0002\u00b2\u0006\u001c\u0010R\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0S0QX\u008a\u0084\u0002\u00b2\u0006\u0016\u0010U\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020$0QX\u008a\u0084\u0002\u00b2\u0006\u001c\u0010R\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0S0QX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater$CacheUpdaterInternal;", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater;)V", "signatureHashCalculator", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IdSignatureHashCalculator;", "getSignatureHashCalculator", "()Lorg/jetbrains/kotlin/ir/backend/js/ic/IdSignatureHashCalculator;", "klibs", "Lorg/jetbrains/kotlin/backend/common/LoadedKlibs;", "getKlibs", "()Lorg/jetbrains/kotlin/backend/common/LoadedKlibs;", "orderedLibraries", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getOrderedLibraries", "()Ljava/util/List;", "mainModuleFriendLibraries", "getMainModuleFriendLibraries", "incrementalCaches", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryFile;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache;", "removedIncrementalCaches", "getLibIncrementalCache", "libFile", "getLibIncrementalCache-5h9WozY", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache;", "addFilesWithRemovedDependencies", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMetadata;", "modifiedFiles", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMutableMap;", "removedFiles", "loadModifiedFiles", "collectExportedSymbolsForDirtyFiles", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileExports;", "dirtyFiles", "collectStubbedSignatures", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getExportedSignaturesAndAddMetadata", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IdSignatureSource;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/DirtyFileMetadata;", "symbolProviders", "Lorg/jetbrains/kotlin/ir/backend/js/ic/FileSignatureProvider;", "dirtySrcFiles", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;", "getExportedSignaturesAndAddMetadata-ctoV0kk", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMutableMap;Ljava/util/List;Ljava/lang/String;Ljava/util/Set;)Ljava/util/Map;", "setAllDependencies", "", "idSignatureToFile", "updatedMetadata", "srcFile", "setAllDependencies-gNUL48g", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/DirtyFileMetadata;Ljava/util/Map;Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap;Ljava/lang/String;Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;)V", "rebuildDirtySourceMetadata", "loadedIr", "Lorg/jetbrains/kotlin/ir/backend/js/ic/LoadedJsIr;", "addDependenciesWithUpdatedSignatures", "Lorg/jetbrains/kotlin/ir/backend/js/ic/UpdatedDependenciesMetadata;", "srcFileMetadata", "addDependenciesWithUpdatedSignatures-xo39iW8", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMutableMap;Ljava/lang/String;Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;Lorg/jetbrains/kotlin/ir/backend/js/ic/DirtyFileMetadata;)V", "addDependenciesWithRemovedInverseDependencies", "addDependenciesWithRemovedInverseDependencies-xo39iW8", "addDependentsWithUpdatedImports", "addDependentsWithUpdatedImports-xo39iW8", "collectFilesWithModifiedExportsAndImports", "loadedDirtyFiles", "collectFilesToRebuildSignatures", "filesWithModifiedExportsOrImports", "collectFilesWithUpdatedStubbedSymbols", "updateStdlibIntrinsicDependencies", "mainModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "buildAndCommitCacheArtifacts", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheArtifact;", "backend.js", "extraModifiedFiles", "", "fileStats", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/DirtyFileState;", "filesToRebuild"})
    @SourceDebugExtension(value={"SMAP\nCacheUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheUpdater.kt\norg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater$CacheUpdaterInternal\n+ 2 ICUtils.kt\norg/jetbrains/kotlin/ir/backend/js/ic/StopwatchIC\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KotlinSourceFileMetadata.kt\norg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFileMap\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,877:1\n110#2,2:878\n112#2,2:895\n391#3,7:880\n800#3:888\n1924#3,2:889\n801#3,2:891\n1926#3:893\n803#3:894\n1205#3,2:897\n1282#3,4:899\n1661#3,3:903\n1282#3,4:909\n1915#3,2:915\n1786#3,2:922\n1788#3:927\n1315#3,4:928\n1807#3,3:935\n1786#3,3:944\n1786#3,3:948\n1915#3,2:958\n1651#3:960\n1915#3:961\n1916#3:963\n1652#3:964\n1300#3,2:965\n1315#3,2:967\n1205#3,2:969\n1282#3,4:971\n1318#3:975\n1915#3,2:976\n1915#3,2:982\n1315#3,4:984\n1#4:887\n1#4:962\n79#5:906\n79#5:913\n82#5:921\n79#5:932\n79#5:938\n79#5:941\n82#5:943\n82#5:947\n79#5:951\n79#5:954\n221#6,2:907\n221#6:914\n222#6:917\n193#6,3:918\n173#6,3:924\n221#6,2:933\n221#6,2:939\n221#6:942\n221#6,2:952\n221#6,2:955\n222#6:957\n221#6,2:978\n221#6,2:980\n*S KotlinDebug\n*F\n+ 1 CacheUpdater.kt\norg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater$CacheUpdaterInternal\n*L\n136#1:878,2\n136#1:895,2\n139#1:880,7\n145#1:888\n145#1:889,2\n145#1:891,2\n145#1:893\n145#1:894\n153#1:897,2\n153#1:899,4\n163#1:903,3\n238#1:909,4\n358#1:915,2\n458#1:922,2\n458#1:927\n475#1:928,4\n541#1:935,3\n579#1:944,3\n583#1:948,3\n613#1:958,2\n620#1:960\n620#1:961\n620#1:963\n620#1:964\n621#1:965,2\n621#1:967,2\n626#1:969,2\n626#1:971,4\n621#1:975\n218#1:976,2\n221#1:982,2\n227#1:984,4\n620#1:962\n202#1:906\n357#1:913\n458#1:921\n491#1:932\n566#1:938\n571#1:941\n579#1:943\n583#1:947\n590#1:951\n598#1:954\n202#1:907,2\n357#1:914\n357#1:917\n448#1:918,3\n459#1:924,3\n491#1:933,2\n566#1:939,2\n571#1:942\n590#1:952,2\n598#1:955,2\n571#1:957\n219#1:978,2\n220#1:980,2\n*E\n"})
    private final class CacheUpdaterInternal {
        @NotNull
        private final IdSignatureHashCalculator signatureHashCalculator;
        @NotNull
        private final LoadedKlibs klibs;
        @NotNull
        private final List<KotlinLibrary> orderedLibraries;
        @NotNull
        private final List<KotlinLibrary> mainModuleFriendLibraries;
        @NotNull
        private final Map<KotlinLibraryFile, IncrementalCache> incrementalCaches;
        @NotNull
        private final List<IncrementalCache> removedIncrementalCaches;

        /*
         * WARNING - void declaration
         */
        public CacheUpdaterInternal() {
            Iterable $this$associateTo$iv$iv;
            void $this$associate$iv;
            Object $this$forEachIndexed$iv$iv;
            List list;
            int n2;
            KotlinLibrary it;
            Object $this$indexOfLast$iv;
            List libraries;
            CacheUpdaterInternal cacheUpdaterInternal;
            Iterable this_$iv;
            CacheUpdater cacheUpdater;
            Object object;
            Object object2;
            block9: {
                void description$iv;
                this.signatureHashCalculator = new IdSignatureHashCalculator(CacheUpdater.this.icHasher);
                this.klibs = LoadWebKlibsKt.loadWebKlibsInProductionPipeline(CacheUpdater.this.compilerConfiguration, JSConfigurationKeysKt.getWasmCompilation(CacheUpdater.this.compilerConfiguration) ? (KlibPlatformChecker)new KlibPlatformChecker.Wasm(null, 1, null) : (KlibPlatformChecker)KlibPlatformChecker.JS.INSTANCE);
                object2 = CacheUpdater.this.stopwatch;
                object = "Loading klib dependencies";
                cacheUpdater = CacheUpdater.this;
                boolean $i$f$measure = false;
                ((StopwatchIC)((Object)this_$iv)).startNext((String)description$iv);
                cacheUpdaterInternal = this;
                boolean bl6 = false;
                libraries = this.klibs.getAll();
                $this$indexOfLast$iv = libraries;
                boolean $i$f$indexOfLast = false;
                ListIterator<KotlinLibrary> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = iterator$iv.previous();
                    boolean bl2 = false;
                    if (!KotlinLibraryFile.equals-impl0(KotlinLibraryFile.constructor-impl(it), cacheUpdater.mainLibraryFile)) continue;
                    n2 = iterator$iv.nextIndex();
                    break block9;
                }
                n2 = -1;
            }
            $this$indexOfLast$iv = n2;
            int it2 = ((Number)$this$indexOfLast$iv).intValue();
            boolean bl = false;
            Object object3 = it2 >= 0 ? $this$indexOfLast$iv : null;
            if (object3 == null) {
                ICUtilsKt.notFoundIcError-5vrbIOY$default("main library", cacheUpdater.mainLibraryFile, null, 4, null);
                throw new KotlinNothingValueException();
            }
            int mainLibraryIndex = (Integer)object3;
            if (mainLibraryIndex == CollectionsKt.getLastIndex(libraries)) {
                list = libraries;
            } else {
                Collection $this$filterIndexedTo$iv;
                $this$indexOfLast$iv = libraries;
                Collection destination$iv = new ArrayList(libraries.size());
                boolean $i$f$filterIndexedTo = false;
                $this$forEachIndexed$iv$iv = $this$filterIndexedTo$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv = 0;
                Iterator iterator2 = $this$forEachIndexed$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void element$iv;
                    int n3;
                    Object item$iv$iv = iterator2.next();
                    if ((n3 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t2 = item$iv$iv;
                    int index$iv = n3;
                    boolean bl3 = false;
                    KotlinLibrary cfr_ignored_0 = (KotlinLibrary)element$iv;
                    int index = index$iv;
                    boolean bl4 = false;
                    if (!(index != mainLibraryIndex)) continue;
                    destination$iv.add(element$iv);
                }
                $this$filterIndexedTo$iv = destination$iv;
                ArrayList $this$orderedLibraries_u24lambda_u240_u243 = (ArrayList)$this$filterIndexedTo$iv;
                boolean bl5 = false;
                $this$orderedLibraries_u24lambda_u240_u243.add(libraries.get(mainLibraryIndex));
                list = (List)$this$filterIndexedTo$iv;
            }
            List result$iv = list;
            StopwatchIC.stop$default((StopwatchIC)((Object)this_$iv), null, 1, null);
            cacheUpdaterInternal.orderedLibraries = result$iv;
            this.mainModuleFriendLibraries = this.klibs.getFriends();
            this_$iv = this.orderedLibraries;
            object = CacheUpdater.this;
            cacheUpdaterInternal = this;
            boolean $i$f$associate22 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void bl6 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                $this$forEachIndexed$iv$iv = destination$iv$iv;
                KotlinLibrary lib = (KotlinLibrary)element$iv$iv;
                boolean bl7 = false;
                String libFile = KotlinLibraryFile.constructor-impl(lib);
                File file = new File(libFile);
                String string = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                String pathHash = CityHashKt.cityHash64String(string);
                File libraryCacheDir = new File(((CacheUpdater)object).cacheRootDir, file.getName() + '.' + pathHash);
                Pair pair = TuplesKt.to((Object)KotlinLibraryFile.box-impl(libFile), (Object)new IncrementalCache(new KotlinLoadedLibraryHeader(lib, ((CacheUpdater)object).irInterner), libraryCacheDir));
                $this$forEachIndexed$iv$iv.put(pair.getFirst(), pair.getSecond());
            }
            cacheUpdaterInternal.incrementalCaches = destination$iv$iv;
            object2 = CacheUpdater.this;
            Object $i$f$associate22 = object = CollectionsKt.createListBuilder();
            cacheUpdaterInternal = this;
            boolean bl8 = false;
            if (((CacheUpdater)object2).cacheRootDir.isDirectory()) {
                void $this$removedIncrementalCaches_u24lambda_u240;
                void $this$mapTo$iv;
                $this$associateTo$iv$iv = this.incrementalCaches.values();
                Collection destination$iv = org.jetbrains.kotlin.utils.CollectionsKt.newHashSetWithExpectedSize(this.incrementalCaches.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    $this$forEachIndexed$iv$iv = (IncrementalCache)item$iv;
                    Collection collection = destination$iv;
                    boolean bl9 = false;
                    collection.add(((IncrementalCache)((Object)it)).getCacheDir());
                }
                HashSet availableCaches = (HashSet)destination$iv;
                Stream<File> allDirs = Files.walk(((CacheUpdater)object2).cacheRootDir.toPath(), 1, new FileVisitOption[0]).map(arg_0 -> CacheUpdaterInternal.removedIncrementalCaches$lambda$0$2(CacheUpdaterInternal::removedIncrementalCaches$lambda$0$1, arg_0));
                allDirs.filter(arg_0 -> CacheUpdaterInternal.removedIncrementalCaches$lambda$0$4(arg_0 -> CacheUpdaterInternal.removedIncrementalCaches$lambda$0$3((CacheUpdater)object2, availableCaches, arg_0), arg_0)).forEach(arg_0 -> CacheUpdaterInternal.removedIncrementalCaches$lambda$0$6(arg_0 -> CacheUpdaterInternal.removedIncrementalCaches$lambda$0$5((List)$this$removedIncrementalCaches_u24lambda_u240, arg_0), arg_0));
            }
            cacheUpdaterInternal.removedIncrementalCaches = CollectionsKt.build((List)object);
        }

        @NotNull
        public final IdSignatureHashCalculator getSignatureHashCalculator() {
            return this.signatureHashCalculator;
        }

        @NotNull
        public final LoadedKlibs getKlibs() {
            return this.klibs;
        }

        @NotNull
        public final List<KotlinLibrary> getOrderedLibraries() {
            return this.orderedLibraries;
        }

        @NotNull
        public final List<KotlinLibrary> getMainModuleFriendLibraries() {
            return this.mainModuleFriendLibraries;
        }

        private final IncrementalCache getLibIncrementalCache-5h9WozY(String string) {
            IncrementalCache incrementalCache = this.incrementalCaches.get(KotlinLibraryFile.box-impl(string));
            if (incrementalCache == null) {
                ICUtilsKt.notFoundIcError-5vrbIOY$default("incremental cache", string, null, 4, null);
                throw new KotlinNothingValueException();
            }
            return incrementalCache;
        }

        /*
         * WARNING - void declaration
         */
        private final KotlinSourceFileMap<KotlinSourceFileMetadata> addFilesWithRemovedDependencies(KotlinSourceFileMutableMap<KotlinSourceFileMetadata> modifiedFiles, KotlinSourceFileMap<? extends KotlinSourceFileMetadata> removedFiles) {
            void this_$iv;
            KotlinSourceFileMutableMap<KotlinSourceFileMetadata> extraModifiedLibFiles = new KotlinSourceFileMutableMap<KotlinSourceFileMetadata>(null, 1, null);
            KotlinSourceFileMap<? extends KotlinSourceFileMetadata> kotlinSourceFileMap = removedFiles;
            CacheUpdater cacheUpdater = CacheUpdater.this;
            boolean $i$f$forEachFile = false;
            Map $this$forEach$iv$iv = (Map)this_$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map files$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator2.next();
                boolean bl = false;
                String lib$iv = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map $this$forEach$iv$iv2 = files$iv = (Map)entry.getValue();
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv$iv2;
                    Map.Entry entry2 = element$iv$iv2 = iterator3.next();
                    boolean bl2 = false;
                    KotlinSourceFile file$iv = (KotlinSourceFile)entry2.getKey();
                    Object data$iv = entry2.getValue();
                    KotlinSourceFileMetadata removedFileMetadata = (KotlinSourceFileMetadata)data$iv;
                    boolean bl3 = false;
                    CacheUpdaterInternal.addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles(this, modifiedFiles, removedFiles, cacheUpdater, extraModifiedLibFiles, removedFileMetadata.getDirectDependencies(), DirtyFileState.REMOVED_INVERSE_DEPENDS);
                    CacheUpdaterInternal.addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles(this, modifiedFiles, removedFiles, cacheUpdater, extraModifiedLibFiles, removedFileMetadata.getInverseDependencies(), DirtyFileState.REMOVED_DIRECT_DEPENDS);
                }
            }
            modifiedFiles.copyFilesFrom((KotlinSourceFileMap<KotlinSourceFileMetadata>)extraModifiedLibFiles);
            return modifiedFiles;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KotlinSourceFileMap<KotlinSourceFileMetadata> loadModifiedFiles() {
            void destination$iv;
            Map libFile;
            HashMap<KotlinLibraryFile, Map<KotlinSourceFile, KotlinSourceFileMetadata>> removedFilesMetadata = new HashMap<KotlinLibraryFile, Map<KotlinSourceFile, KotlinSourceFileMetadata>>();
            for (IncrementalCache incrementalCache : this.removedIncrementalCaches) {
                if (incrementalCache.getLibraryFileFromHeader-y7ymc5g() == null) {
                    ICUtilsKt.notFoundIcError-5vrbIOY$default("removed library name; cache dir: " + incrementalCache.getCacheDir(), null, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                Map<KotlinSourceFile, KotlinSourceFileMetadata> dirtyFiles = CacheUpdaterInternal.loadModifiedFiles$collectDirtyFiles(removedFilesMetadata, CacheUpdater.this, (String)((Object)libFile), incrementalCache);
                if (!(!dirtyFiles.isEmpty())) continue;
                ICUtilsKt.icError-T6xF6yw$default("unexpected dirty file", (String)((Object)libFile), (KotlinSourceFile)CollectionsKt.first((Iterable)dirtyFiles.keySet()), null, 8, null);
                throw new KotlinNothingValueException();
            }
            Iterable iterable = this.incrementalCaches.entrySet();
            libFile = new HashMap();
            CacheUpdater cacheUpdater = CacheUpdater.this;
            boolean $i$f$associateTo = false;
            for (Object element$iv : iterable) {
                void var9_10 = destination$iv;
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                String lib = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                IncrementalCache cache3 = (IncrementalCache)entry.getValue();
                entry = TuplesKt.to((Object)KotlinLibraryFile.box-impl(lib), CacheUpdaterInternal.loadModifiedFiles$collectDirtyFiles(removedFilesMetadata, cacheUpdater, lib, cache3));
                var9_10.put(entry.getFirst(), entry.getSecond());
            }
            HashMap dirtyFiles = (HashMap)destination$iv;
            return this.addFilesWithRemovedDependencies(new KotlinSourceFileMutableMap<KotlinSourceFileMetadata>((Map<KotlinLibraryFile, Map<KotlinSourceFile, KotlinSourceFileMetadata>>)dirtyFiles), new KotlinSourceFileMap((Map)removedFilesMetadata));
        }

        @NotNull
        public final KotlinSourceFileMutableMap<KotlinSourceFileExports> collectExportedSymbolsForDirtyFiles(@NotNull KotlinSourceFileMap<? extends KotlinSourceFileMetadata> dirtyFiles) {
            Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
            KotlinSourceFileMutableMap<KotlinSourceFileExports> exportedSymbols = new KotlinSourceFileMutableMap<KotlinSourceFileExports>(null, 1, null);
            for (Map.Entry entry : ((Map)dirtyFiles).entrySet()) {
                String libFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map srcFiles = (Map)entry.getValue();
                HashMap exportedSymbolFiles = new HashMap(srcFiles.size());
                for (Map.Entry entry2 : srcFiles.entrySet()) {
                    KotlinSourceFile srcFile = (KotlinSourceFile)entry2.getKey();
                    KotlinSourceFileMetadata srcFileMetadata = (KotlinSourceFileMetadata)entry2.getValue();
                    DirtyFileExports loadingFileExports = new DirtyFileExports();
                    for (Map.Entry entry3 : ((Map)srcFileMetadata.getInverseDependencies()).entrySet()) {
                        String dependentLib = ((KotlinLibraryFile)entry3.getKey()).unbox-impl();
                        Map dependentFiles = (Map)entry3.getValue();
                        if (this.incrementalCaches.get(KotlinLibraryFile.box-impl(dependentLib)) == null) continue;
                        Map map = dirtyFiles.get-5h9WozY(dependentLib);
                        if (map == null) {
                            map = MapsKt.emptyMap();
                        }
                        Map dirtyLibFiles = map;
                        for (KotlinSourceFile dependentFile : dependentFiles.keySet()) {
                            Map<IdSignature, ICHash> it;
                            IncrementalCache dependentCache;
                            if (dirtyLibFiles.containsKey(dependentFile)) continue;
                            KotlinSourceFileMetadata dependentSrcFileMetadata = dependentCache.fetchSourceFileFullMetadata(dependentFile);
                            if (dependentSrcFileMetadata.getDirectDependencies().get-BOFFYcU(libFile, srcFile) == null) continue;
                            boolean bl = false;
                            ((KotlinSourceFileMutableMap)loadingFileExports.getInverseDependencies()).set-wkabOcM(dependentLib, dependentFile, it.keySet());
                            CollectionsKt.addAll((Collection)loadingFileExports.getAllExportedSignatures(), (Iterable)it.keySet());
                        }
                    }
                    ((Map)exportedSymbolFiles).put(srcFile, loadingFileExports);
                }
                if (!(!((Map)exportedSymbolFiles).isEmpty())) continue;
                exportedSymbols.set-BOFFYcU(libFile, exportedSymbolFiles);
            }
            return exportedSymbols;
        }

        @NotNull
        public final Set<IdSignature> collectStubbedSignatures() {
            HashSet stubbedSignatures = new HashSet();
            for (IncrementalCache cache2 : this.incrementalCaches.values()) {
                Map<KotlinSourceFile, Set<IdSignature>> fileStubbedSignatures = cache2.collectFilesWithStubbedSignatures();
                for (Set<IdSignature> signatures2 : fileStubbedSignatures.values()) {
                    CollectionsKt.addAll((Collection)stubbedSignatures, (Iterable)signatures2);
                }
            }
            return stubbedSignatures;
        }

        private final Map<IdSignature, IdSignatureSource> getExportedSignaturesAndAddMetadata-ctoV0kk(KotlinSourceFileMutableMap<DirtyFileMetadata> $this$getExportedSignaturesAndAddMetadata_u2dctoV0kk, List<? extends FileSignatureProvider> symbolProviders, String string, Set<KotlinSourceFile> dirtySrcFiles) {
            HashMap idSignatureToFile = new HashMap();
            IncrementalCache incrementalCache = this.getLibIncrementalCache-5h9WozY(string);
            for (FileSignatureProvider fileSignatureProvider : symbolProviders) {
                HashSet maybeImportedSignatures = CollectionsKt.toHashSet((Iterable)fileSignatureProvider.getReachableSignatures());
                Map<IdSignature, IrSymbol> implementedSymbols = fileSignatureProvider.getImplementedSymbols();
                for (Map.Entry<IdSignature, IrSymbol> entry : implementedSymbols.entrySet()) {
                    IdSignature signature = entry.getKey();
                    IrSymbol symbol = entry.getValue();
                    boolean symbolCanBeExported = false;
                    symbolCanBeExported = maybeImportedSignatures.remove(signature);
                    if (IdSignatureSourceKt.resolveFakeOverrideFunction(symbol) != null) {
                        IdSignature resolvedSignature;
                        boolean bl = false;
                        if (!implementedSymbols.containsKey(resolvedSignature)) {
                            maybeImportedSignatures.add(resolvedSignature);
                        }
                        symbolCanBeExported = true;
                    }
                    if (!symbolCanBeExported) continue;
                    ((Map)idSignatureToFile).put(signature, new IdSignatureSource(string, fileSignatureProvider, symbol, null));
                }
                KotlinSourceFile libSrcFile = fileSignatureProvider.getSrcFile();
                if (!dirtySrcFiles.contains(libSrcFile)) continue;
                KotlinSourceFileMetadata metadata = incrementalCache.fetchSourceFileFullMetadata(libSrcFile);
                $this$getExportedSignaturesAndAddMetadata_u2dctoV0kk.set-wkabOcM(string, libSrcFile, new DirtyFileMetadata(maybeImportedSignatures, metadata.getDirectDependencies()));
            }
            return idSignatureToFile;
        }

        private final void setAllDependencies-gNUL48g(DirtyFileMetadata $this$setAllDependencies_u2dgNUL48g, Map<IdSignature, IdSignatureSource> idSignatureToFile, KotlinSourceFileMap<DirtyFileMetadata> updatedMetadata, String string, KotlinSourceFile srcFile) {
            Set<IdSignature> allImportedSignatures = IdSignatureSourceKt.addParentSignatures-ctoV0kk($this$setAllDependencies_u2dgNUL48g.getMaybeImportedSignatures(), idSignatureToFile, string, srcFile);
            for (IdSignature importedSignature : allImportedSignatures) {
                DirtyFileMetadata dirtyFileMetadata;
                Hash128Bits hash128Bits;
                IdSignatureSource dependency;
                if (idSignatureToFile.get(importedSignature) == null) continue;
                if (this.signatureHashCalculator.get-Z1Gnr_Y(importedSignature) == null) {
                    ICUtilsKt.notFoundIcError-5vrbIOY("signature " + importedSignature + " hash", dependency.getLib-dAnkW_k(), dependency.getSrcFile());
                    throw new KotlinNothingValueException();
                }
                Hash128Bits signatureHash = hash128Bits;
                boolean bl = false;
                $this$setAllDependencies_u2dgNUL48g.addDirectDependency-BtF-_Mg(dependency.getLib-dAnkW_k(), dependency.getSrcFile(), importedSignature, signatureHash);
                if (updatedMetadata.get-BOFFYcU(dependency.getLib-dAnkW_k(), dependency.getSrcFile()) == null) continue;
                DirtyFileMetadata dependencyMetadata = dirtyFileMetadata;
                boolean bl2 = false;
                dependencyMetadata.addInverseDependency-wkabOcM(string, srcFile, importedSignature);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KotlinSourceFileMap<DirtyFileMetadata> rebuildDirtySourceMetadata(@NotNull LoadedJsIr loadedIr, @NotNull KotlinSourceFileMap<? extends KotlinSourceFileExports> dirtySrcFiles) {
            Intrinsics.checkNotNullParameter((Object)loadedIr, (String)"loadedIr");
            Intrinsics.checkNotNullParameter(dirtySrcFiles, (String)"dirtySrcFiles");
            HashMap idSignatureToFile = new HashMap();
            KotlinSourceFileMutableMap<DirtyFileMetadata> updatedMetadata = new KotlinSourceFileMutableMap<DirtyFileMetadata>(null, 1, null);
            Iterator<Object> iterator2 = loadedIr.getOrderedFragments().keySet().iterator();
            while (iterator2.hasNext()) {
                String object = iterator2.next().unbox-impl();
                Map<KotlinSourceFile, ? extends KotlinSourceFileExports> map = dirtySrcFiles.get-5h9WozY(object);
                if (map == null || (map = map.keySet()) == null) {
                    map = SetsKt.emptySet();
                }
                Map<KotlinSourceFile, ? extends KotlinSourceFileExports> map2 = map;
                List<FileSignatureProvider> symbolProviders = loadedIr.getSignatureProvidersForLib-5h9WozY(object);
                ((Map)idSignatureToFile).putAll(this.getExportedSignaturesAndAddMetadata-ctoV0kk(updatedMetadata, symbolProviders, object, (Set<KotlinSourceFile>)((Object)map2)));
            }
            this.signatureHashCalculator.addAllSignatureSymbols(idSignatureToFile);
            for (Map.Entry entry : ((Map)updatedMetadata).entrySet()) {
                String string = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map srcFiles = (Map)entry.getValue();
                if (dirtySrcFiles.get-5h9WozY(string) == null) continue;
                for (Map.Entry entry2 : srcFiles.entrySet()) {
                    KotlinSourceFileExports dirtySrcFile;
                    Map<KotlinSourceFile, ? extends KotlinSourceFileExports> libDirtySrcFiles;
                    KotlinSourceFile srcFile = (KotlinSourceFile)entry2.getKey();
                    DirtyFileMetadata updatedHeader = (DirtyFileMetadata)entry2.getValue();
                    if (libDirtySrcFiles.get(srcFile) == null) continue;
                    KotlinSourceFileMap<Set<IdSignature>> this_$iv = dirtySrcFile.getInverseDependencies();
                    boolean $i$f$forEachFile = false;
                    Map $this$forEach$iv$iv = this_$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv$iv.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map files$iv;
                        Map.Entry element$iv$iv;
                        Map.Entry entry3 = element$iv$iv = iterator3.next();
                        boolean bl = false;
                        String lib$iv = ((KotlinLibraryFile)entry3.getKey()).unbox-impl();
                        Map $this$forEach$iv$iv2 = files$iv = (Map)entry3.getValue();
                        boolean $i$f$forEach2 = false;
                        Iterator iterator4 = $this$forEach$iv$iv2.entrySet().iterator();
                        while (iterator4.hasNext()) {
                            void signatures2;
                            Map.Entry element$iv$iv2;
                            Map.Entry entry4 = element$iv$iv2 = iterator4.next();
                            boolean bl2 = false;
                            KotlinSourceFile file$iv = (KotlinSourceFile)entry4.getKey();
                            Object data$iv = entry4.getValue();
                            Set set = (Set)data$iv;
                            KotlinSourceFile kotlinSourceFile = file$iv;
                            String dependentLibFile = lib$iv;
                            boolean bl3 = false;
                            Iterable $this$forEach$iv = (Iterable)signatures2;
                            boolean $i$f$forEach3 = false;
                            for (Object element$iv : $this$forEach$iv) {
                                void dependentSrcFile;
                                DirtyFileMetadata dirtyFileMetadata;
                                Object dependencyFile;
                                IdSignatureSource signatureSrc;
                                IdSignature signature = (IdSignature)element$iv;
                                boolean bl4 = false;
                                IdSignatureSource idSignatureSource = signatureSrc = (IdSignatureSource)idSignatureToFile.get(signature);
                                String dependencyLib = idSignatureSource != null ? idSignatureSource.getLib-dAnkW_k() : string;
                                Object object = signatureSrc;
                                if (object == null || (object = ((IdSignatureSource)object).getSrcFile()) == null) {
                                    object = srcFile;
                                }
                                if ((DirtyFileMetadata)updatedMetadata.get-BOFFYcU(dependencyLib, (KotlinSourceFile)(dependencyFile = object)) == null) continue;
                                DirtyFileMetadata dependencyMetadata = dirtyFileMetadata;
                                boolean bl5 = false;
                                dependencyMetadata.addInverseDependency-wkabOcM(dependentLibFile, (KotlinSourceFile)dependentSrcFile, signature);
                            }
                        }
                    }
                    this.setAllDependencies-gNUL48g(updatedHeader, idSignatureToFile, (KotlinSourceFileMap<DirtyFileMetadata>)updatedMetadata, string, srcFile);
                }
            }
            KotlinSourceFileMutableMap<DirtyFileMetadata> result2 = new KotlinSourceFileMutableMap<DirtyFileMetadata>(null, 1, null);
            for (Map.Entry entry : ((Map)dirtySrcFiles).entrySet()) {
                String libFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map sourceFiles = (Map)entry.getValue();
                IncrementalCache incrementalCache = this.getLibIncrementalCache-5h9WozY(libFile);
                if (updatedMetadata.get-5h9WozY(libFile) == null) {
                    ICUtilsKt.notFoundIcError-5vrbIOY$default("metadata", libFile, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                for (KotlinSourceFile srcFile : sourceFiles.keySet()) {
                    DirtyFileMetadata srcMetadata;
                    Map srcFileUpdatedMetadata;
                    if ((DirtyFileMetadata)srcFileUpdatedMetadata.get(srcFile) == null) {
                        ICUtilsKt.notFoundIcError-5vrbIOY("metadata", libFile, srcFile);
                        throw new KotlinNothingValueException();
                    }
                    incrementalCache.updateSourceFileMetadata(srcFile, srcMetadata);
                    result2.set-wkabOcM(libFile, srcFile, srcMetadata);
                }
            }
            return result2;
        }

        private final void addDependenciesWithUpdatedSignatures-xo39iW8(KotlinSourceFileMutableMap<UpdatedDependenciesMetadata> $this$addDependenciesWithUpdatedSignatures_u2dxo39iW8, String string, KotlinSourceFile srcFile, DirtyFileMetadata srcFileMetadata) {
            for (Map.Entry entry : ((Map)srcFileMetadata.getDirectDependencies()).entrySet()) {
                String dependencyLibFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map dependencySrcFiles = (Map)entry.getValue();
                IncrementalCache dependencyCache = this.getLibIncrementalCache-5h9WozY(dependencyLibFile);
                for (Map.Entry entry2 : dependencySrcFiles.entrySet()) {
                    Set oldSignatures;
                    KotlinSourceFile dependencySrcFile = (KotlinSourceFile)entry2.getKey();
                    Map newSignatures = (Map)entry2.getValue();
                    KotlinSourceFileMetadata dependencySrcMetadata = dependencyCache.fetchSourceFileFullMetadata(dependencySrcFile);
                    Set set = dependencySrcMetadata.getInverseDependencies().get-BOFFYcU(string, srcFile);
                    if (set == null) {
                        set = SetsKt.emptySet();
                    }
                    if (Intrinsics.areEqual((Object)(oldSignatures = set), (Object)newSignatures)) continue;
                    UpdatedDependenciesMetadata newMetadata = KotlinSourceFileMetadataKt.addNewMetadata-xo39iW8($this$addDependenciesWithUpdatedSignatures_u2dxo39iW8, dependencyLibFile, dependencySrcFile, dependencySrcMetadata);
                    ((KotlinSourceFileMutableMap)newMetadata.getInverseDependencies()).set-wkabOcM(string, srcFile, newSignatures.keySet());
                }
            }
        }

        private final void addDependenciesWithRemovedInverseDependencies-xo39iW8(KotlinSourceFileMutableMap<UpdatedDependenciesMetadata> $this$addDependenciesWithRemovedInverseDependencies_u2dxo39iW8, String string, KotlinSourceFile srcFile, DirtyFileMetadata srcFileMetadata) {
            for (Map.Entry entry : ((Map)srcFileMetadata.getOldDirectDependencies()).entrySet()) {
                String oldDependencyLibFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map oldDependencySrcFiles = (Map)entry.getValue();
                if (this.incrementalCaches.get(KotlinLibraryFile.box-impl(oldDependencyLibFile)) == null) continue;
                Map map = srcFileMetadata.getDirectDependencies().get-5h9WozY(oldDependencyLibFile);
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                Map newDirectDependencyFiles = map;
                for (KotlinSourceFile oldDependencySrcFile : oldDependencySrcFiles.keySet()) {
                    IncrementalCache dependencyCache;
                    KotlinSourceFileMetadata dependencySrcMetadata;
                    if (newDirectDependencyFiles.containsKey(oldDependencySrcFile) || (dependencySrcMetadata = dependencyCache.fetchSourceFileFullMetadata(oldDependencySrcFile)).getInverseDependencies().get-BOFFYcU(string, srcFile) == null) continue;
                    UpdatedDependenciesMetadata newMetadata = KotlinSourceFileMetadataKt.addNewMetadata-xo39iW8($this$addDependenciesWithRemovedInverseDependencies_u2dxo39iW8, oldDependencyLibFile, oldDependencySrcFile, dependencySrcMetadata);
                    ((KotlinSourceFileMutableMap)newMetadata.getInverseDependencies()).removeFile-BOFFYcU(string, srcFile);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void addDependentsWithUpdatedImports-xo39iW8(KotlinSourceFileMutableMap<UpdatedDependenciesMetadata> $this$addDependentsWithUpdatedImports_u2dxo39iW8, String string, KotlinSourceFile srcFile, DirtyFileMetadata srcFileMetadata) {
            for (Map.Entry entry : ((Map)srcFileMetadata.getInverseDependencies()).entrySet()) {
                String dependentLibFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map dependentSrcFiles = (Map)entry.getValue();
                if (this.incrementalCaches.get(KotlinLibraryFile.box-impl(dependentLibFile)) == null) continue;
                for (Map.Entry entry2 : dependentSrcFiles.entrySet()) {
                    void $this$associateWithTo$iv;
                    Object this_$iv;
                    UpdatedDependenciesMetadata newMetadata;
                    boolean bl;
                    Map dependentSignatures;
                    KotlinSourceFileMetadata dependentSrcMetadata;
                    Set newSignatures;
                    KotlinSourceFile dependentSrcFile;
                    block19: {
                        IncrementalCache dependentCache;
                        dependentSrcFile = (KotlinSourceFile)entry2.getKey();
                        newSignatures = (Set)entry2.getValue();
                        dependentSrcMetadata = dependentCache.fetchSourceFileFullMetadata(dependentSrcFile);
                        Map map = dependentSrcMetadata.getDirectDependencies().get-BOFFYcU(string, srcFile);
                        if (map == null) {
                            map = MapsKt.emptyMap();
                        }
                        dependentSignatures = map;
                        if (dependentSrcMetadata instanceof DirtyFileMetadata) continue;
                        UpdatedDependenciesMetadata updatedDependenciesMetadata = (UpdatedDependenciesMetadata)$this$addDependentsWithUpdatedImports_u2dxo39iW8.get-BOFFYcU(dependentLibFile, dependentSrcFile);
                        if ((updatedDependenciesMetadata != null ? updatedDependenciesMetadata.getImportedSignaturesState() : null) == ImportedSignaturesState.MODIFIED) continue;
                        Map $this$any$iv = dependentSignatures;
                        boolean $i$f$any = false;
                        if ($this$any$iv.isEmpty()) {
                            bl = false;
                        } else {
                            Iterator iterator2 = $this$any$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry element$iv;
                                Map.Entry it = element$iv = iterator2.next();
                                boolean bl2 = false;
                                Hash128Bits hash128Bits = this.signatureHashCalculator.get-Z1Gnr_Y((IdSignature)it.getKey());
                                Hash128Bits hash128Bits2 = ((ICHash)it.getValue()).unbox-impl();
                                Hash128Bits hash128Bits3 = hash128Bits;
                                if (!(!(hash128Bits3 == null ? false : ICHash.equals-impl0(hash128Bits3, hash128Bits2)))) continue;
                                bl = true;
                                break block19;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        newMetadata = KotlinSourceFileMetadataKt.addNewMetadata-xo39iW8($this$addDependentsWithUpdatedImports_u2dxo39iW8, dependentLibFile, dependentSrcFile, dependentSrcMetadata);
                        newMetadata.setImportedSignaturesState(ImportedSignaturesState.MODIFIED);
                        continue;
                    }
                    if (Intrinsics.areEqual(dependentSignatures.keySet(), (Object)newSignatures)) continue;
                    newMetadata = KotlinSourceFileMetadataKt.addNewMetadata-xo39iW8($this$addDependentsWithUpdatedImports_u2dxo39iW8, dependentLibFile, dependentSrcFile, dependentSrcMetadata);
                    if (newMetadata.getImportedSignaturesState() == ImportedSignaturesState.UNKNOWN) {
                        boolean isNonModified;
                        boolean bl3;
                        block22: {
                            this_$iv = dependentSrcMetadata.getDirectDependencies();
                            boolean $i$f$allFiles = false;
                            Iterable $this$all$iv$iv = ((KotlinSourceFileMap)this_$iv).entrySet();
                            boolean $i$f$all = false;
                            if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
                                bl3 = true;
                            } else {
                                for (Object element$iv$iv : $this$all$iv$iv) {
                                    boolean bl4;
                                    block21: {
                                        Map.Entry entry3 = (Map.Entry)element$iv$iv;
                                        boolean bl5 = false;
                                        String lib$iv = ((KotlinLibraryFile)entry3.getKey()).unbox-impl();
                                        Map files$iv = (Map)entry3.getValue();
                                        Iterable $this$all$iv$iv2 = files$iv.entrySet();
                                        boolean $i$f$all2 = false;
                                        if ($this$all$iv$iv2 instanceof Collection && ((Collection)$this$all$iv$iv2).isEmpty()) {
                                            bl4 = true;
                                        } else {
                                            for (Object element$iv$iv2 : $this$all$iv$iv2) {
                                                boolean bl6;
                                                block20: {
                                                    Map.Entry entry4 = (Map.Entry)element$iv$iv2;
                                                    boolean bl7 = false;
                                                    KotlinSourceFile file$iv = (KotlinSourceFile)entry4.getKey();
                                                    Object data$iv = entry4.getValue();
                                                    Map signatures2 = (Map)data$iv;
                                                    boolean bl8 = false;
                                                    Map $this$all$iv = signatures2;
                                                    boolean $i$f$all3 = false;
                                                    if ($this$all$iv.isEmpty()) {
                                                        bl6 = true;
                                                    } else {
                                                        Iterator iterator3 = $this$all$iv.entrySet().iterator();
                                                        while (iterator3.hasNext()) {
                                                            Hash128Bits hash128Bits;
                                                            Map.Entry element$iv;
                                                            Map.Entry it = element$iv = iterator3.next();
                                                            boolean bl9 = false;
                                                            Hash128Bits newHash = this.signatureHashCalculator.get-Z1Gnr_Y((IdSignature)it.getKey());
                                                            if (newHash == null || ICHash.equals-impl0(newHash, hash128Bits = ((ICHash)it.getValue()).unbox-impl())) continue;
                                                            bl6 = false;
                                                            break block20;
                                                        }
                                                        bl6 = true;
                                                    }
                                                }
                                                if (bl6) continue;
                                                bl4 = false;
                                                break block21;
                                            }
                                            bl4 = true;
                                        }
                                    }
                                    if (bl4) continue;
                                    bl3 = false;
                                    break block22;
                                }
                                bl3 = true;
                            }
                        }
                        newMetadata.setImportedSignaturesState((isNonModified = bl3) ? ImportedSignaturesState.NON_MODIFIED : ImportedSignaturesState.MODIFIED);
                    }
                    if (newMetadata.getImportedSignaturesState() != ImportedSignaturesState.NON_MODIFIED) continue;
                    this_$iv = newSignatures;
                    Map destination$iv = org.jetbrains.kotlin.utils.CollectionsKt.newHashMapWithExpectedSize(newSignatures.size());
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv : $this$associateWithTo$iv) {
                        void it;
                        Object element$iv$iv;
                        element$iv$iv = (IdSignature)element$iv;
                        Object t2 = element$iv;
                        Map map = destination$iv;
                        boolean bl10 = false;
                        Hash128Bits hash128Bits = this.signatureHashCalculator.get-Z1Gnr_Y((IdSignature)it);
                        if (hash128Bits == null) {
                            ICUtilsKt.notFoundIcError-5vrbIOY("signature " + it + " hash", string, srcFile);
                            throw new KotlinNothingValueException();
                        }
                        ICHash iCHash = ICHash.box-impl(hash128Bits);
                        map.put(t2, iCHash);
                    }
                    HashMap newDirectDependencies = (HashMap)destination$iv;
                    ((KotlinSourceFileMutableMap)newMetadata.getDirectDependencies()).set-wkabOcM(string, srcFile, newDirectDependencies);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KotlinSourceFileMap<UpdatedDependenciesMetadata> collectFilesWithModifiedExportsAndImports(@NotNull KotlinSourceFileMap<DirtyFileMetadata> loadedDirtyFiles) {
            Intrinsics.checkNotNullParameter(loadedDirtyFiles, (String)"loadedDirtyFiles");
            KotlinSourceFileMutableMap<UpdatedDependenciesMetadata> filesWithModifiedExportsAndImports = new KotlinSourceFileMutableMap<UpdatedDependenciesMetadata>(null, 1, null);
            KotlinSourceFileMap<DirtyFileMetadata> this_$iv = loadedDirtyFiles;
            boolean $i$f$forEachFile = false;
            Map $this$forEach$iv$iv = this_$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map files$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator2.next();
                boolean bl = false;
                String lib$iv = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map $this$forEach$iv$iv2 = files$iv = (Map)entry.getValue();
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    void srcFileMetadata;
                    void srcFile;
                    Map.Entry element$iv$iv2;
                    Map.Entry entry2 = element$iv$iv2 = iterator3.next();
                    boolean bl2 = false;
                    KotlinSourceFile file$iv = (KotlinSourceFile)entry2.getKey();
                    Object data$iv = entry2.getValue();
                    DirtyFileMetadata dirtyFileMetadata = (DirtyFileMetadata)data$iv;
                    KotlinSourceFile kotlinSourceFile = file$iv;
                    String libFile = lib$iv;
                    boolean bl3 = false;
                    this.addDependenciesWithUpdatedSignatures-xo39iW8(filesWithModifiedExportsAndImports, libFile, (KotlinSourceFile)srcFile, (DirtyFileMetadata)srcFileMetadata);
                    this.addDependenciesWithRemovedInverseDependencies-xo39iW8(filesWithModifiedExportsAndImports, libFile, (KotlinSourceFile)srcFile, (DirtyFileMetadata)srcFileMetadata);
                    this.addDependentsWithUpdatedImports-xo39iW8(filesWithModifiedExportsAndImports, libFile, (KotlinSourceFile)srcFile, (DirtyFileMetadata)srcFileMetadata);
                }
            }
            return filesWithModifiedExportsAndImports;
        }

        @NotNull
        public final KotlinSourceFileMap<KotlinSourceFileExports> collectFilesToRebuildSignatures(@NotNull KotlinSourceFileMap<UpdatedDependenciesMetadata> filesWithModifiedExportsOrImports) {
            Intrinsics.checkNotNullParameter(filesWithModifiedExportsOrImports, (String)"filesWithModifiedExportsOrImports");
            KotlinSourceFileMutableMap libFilesToRebuild = new KotlinSourceFileMutableMap(null, 1, null);
            for (Map.Entry entry : ((Map)filesWithModifiedExportsOrImports).entrySet()) {
                String libFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map srcFiles = (Map)entry.getValue();
                Lazy filesToRebuild$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheUpdaterInternal.collectFilesToRebuildSignatures$lambda$0(libFilesToRebuild, libFile));
                Lazy fileStats$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheUpdaterInternal.collectFilesToRebuildSignatures$lambda$2(CacheUpdater.this, libFile));
                IncrementalCache cache2 = this.getLibIncrementalCache-5h9WozY(libFile);
                for (Map.Entry entry2 : srcFiles.entrySet()) {
                    KotlinSourceFile srcFile = (KotlinSourceFile)entry2.getKey();
                    UpdatedDependenciesMetadata srcFileMetadata = (UpdatedDependenciesMetadata)entry2.getValue();
                    boolean isExportedSignatureUpdated = srcFileMetadata.isExportedSignaturesUpdated();
                    if (isExportedSignatureUpdated || srcFileMetadata.getImportedSignaturesState() == ImportedSignaturesState.MODIFIED) {
                        CacheUpdaterInternal.collectFilesToRebuildSignatures$lambda$1((Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileExports>>)filesToRebuild$delegate).put(srcFile, srcFileMetadata);
                        if (isExportedSignatureUpdated) {
                            CacheUpdater.this.addDirtFileStat(CacheUpdaterInternal.collectFilesToRebuildSignatures$lambda$3((Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>>)fileStats$delegate), srcFile, DirtyFileState.UPDATED_EXPORTS);
                        }
                        if (srcFileMetadata.getImportedSignaturesState() != ImportedSignaturesState.MODIFIED) continue;
                        CacheUpdater.this.addDirtFileStat(CacheUpdaterInternal.collectFilesToRebuildSignatures$lambda$3((Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>>)fileStats$delegate), srcFile, DirtyFileState.UPDATED_IMPORTS);
                        continue;
                    }
                    cache2.updateSourceFileMetadata(srcFile, srcFileMetadata);
                }
            }
            return libFilesToRebuild;
        }

        @NotNull
        public final KotlinSourceFileMap<KotlinSourceFileExports> collectFilesWithUpdatedStubbedSymbols(@NotNull KotlinSourceFileMap<?> dirtyFiles) {
            Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
            KotlinSourceFileMutableMap libFiles = new KotlinSourceFileMutableMap(null, 1, null);
            for (Map.Entry<KotlinLibraryFile, IncrementalCache> entry : this.incrementalCaches.entrySet()) {
                String libFile = entry.getKey().unbox-impl();
                IncrementalCache cache2 = entry.getValue();
                Lazy filesToRebuild$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheUpdaterInternal.collectFilesWithUpdatedStubbedSymbols$lambda$0(libFiles, libFile));
                Lazy fileStats$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheUpdaterInternal.collectFilesWithUpdatedStubbedSymbols$lambda$2(CacheUpdater.this, libFile));
                Map<KotlinSourceFile, ?> map = dirtyFiles.get-5h9WozY(libFile);
                if (map == null || (map = map.keySet()) == null) {
                    map = SetsKt.emptySet();
                }
                Map<KotlinSourceFile, ?> alreadyDirtyFiles = map;
                Map<KotlinSourceFile, Set<IdSignature>> filesWithStubbedSignatures = cache2.collectFilesWithStubbedSignatures();
                for (Map.Entry<KotlinSourceFile, Set<IdSignature>> entry2 : filesWithStubbedSignatures.entrySet()) {
                    boolean bl;
                    KotlinSourceFile srcFile;
                    block6: {
                        srcFile = entry2.getKey();
                        Set<IdSignature> stubbedSignatures = entry2.getValue();
                        if (alreadyDirtyFiles.contains(srcFile)) continue;
                        Iterable $this$any$iv = stubbedSignatures;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                IdSignature it = (IdSignature)element$iv;
                                boolean bl2 = false;
                                if (!this.signatureHashCalculator.contains(it)) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    CacheUpdaterInternal.collectFilesWithUpdatedStubbedSymbols$lambda$1((Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileExports>>)filesToRebuild$delegate).put(srcFile, cache2.fetchSourceFileFullMetadata(srcFile));
                    CacheUpdater.this.addDirtFileStat(CacheUpdaterInternal.collectFilesWithUpdatedStubbedSymbols$lambda$3((Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>>)fileStats$delegate), srcFile, DirtyFileState.UPDATED_IMPORTS);
                }
            }
            return libFiles;
        }

        /*
         * WARNING - void declaration
         */
        public final void updateStdlibIntrinsicDependencies(@NotNull LoadedJsIr loadedIr, @NotNull IrModuleFragment mainModule, @NotNull Map<KotlinLibraryFile, ? extends Set<KotlinSourceFile>> dirtyFiles) {
            DirtyFileMetadata srcFile;
            Object libFile;
            Intrinsics.checkNotNullParameter((Object)loadedIr, (String)"loadedIr");
            Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
            Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
            String stdlibFile = ((KotlinLibraryFile)ICUtilsKt.findStdlib(mainModule, loadedIr.getOrderedFragments()).component1()).unbox-impl();
            Set<KotlinSourceFile> set = dirtyFiles.get(KotlinLibraryFile.box-impl(stdlibFile));
            if (set == null) {
                return;
            }
            Set<KotlinSourceFile> stdlibDirtyFiles = set;
            List<FileSignatureProvider> stdlibSymbolProviders = loadedIr.getSignatureProvidersForLib-5h9WozY(stdlibFile);
            KotlinSourceFileMutableMap<DirtyFileMetadata> updatedMetadata = new KotlinSourceFileMutableMap<DirtyFileMetadata>(null, 1, null);
            Map<IdSignature, IdSignatureSource> idSignatureToFile = this.getExportedSignaturesAndAddMetadata-ctoV0kk(updatedMetadata, stdlibSymbolProviders, stdlibFile, stdlibDirtyFiles);
            this.signatureHashCalculator.addAllSignatureSymbols(idSignatureToFile);
            KotlinSourceFileMap this_$iv = updatedMetadata;
            boolean $i$f$forEachFile = false;
            Map $this$forEach$iv$iv = this_$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map files$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator2.next();
                boolean bl = false;
                String lib$iv = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map $this$forEach$iv$iv2 = files$iv = (Map)entry.getValue();
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    void updatedHeader;
                    Map.Entry element$iv$iv2;
                    Map.Entry entry2 = element$iv$iv2 = iterator3.next();
                    boolean bl2 = false;
                    KotlinSourceFile file$iv = (KotlinSourceFile)entry2.getKey();
                    Object data$iv = entry2.getValue();
                    DirtyFileMetadata dirtyFileMetadata = (DirtyFileMetadata)data$iv;
                    KotlinSourceFile kotlinSourceFile = file$iv;
                    libFile = lib$iv;
                    boolean bl3 = false;
                    this.setAllDependencies-gNUL48g((DirtyFileMetadata)updatedHeader, idSignatureToFile, (KotlinSourceFileMap<DirtyFileMetadata>)updatedMetadata, (String)libFile, (KotlinSourceFile)((Object)srcFile));
                }
            }
            IncrementalCache incrementalCache = this.getLibIncrementalCache-5h9WozY(stdlibFile);
            KotlinSourceFileMap this_$iv2 = updatedMetadata;
            boolean $i$f$forEachFile2 = false;
            Map $this$forEach$iv$iv3 = this_$iv2;
            boolean $i$f$forEach3 = false;
            Iterator iterator4 = $this$forEach$iv$iv3.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map files$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator4.next();
                boolean bl = false;
                String lib$iv = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map $this$forEach$iv$iv4 = files$iv = (Map)entry.getValue();
                boolean $i$f$forEach4 = false;
                Iterator iterator5 = $this$forEach$iv$iv4.entrySet().iterator();
                while (iterator5.hasNext()) {
                    Object updatedDependencies;
                    Iterator<Object> iterator3;
                    boolean bl2;
                    boolean needUpdate;
                    Map invDependencies;
                    Map files$iv2;
                    String lib$iv2;
                    KotlinSourceFileMap<Object> this_$iv3;
                    boolean bl3;
                    Set dependencies;
                    KotlinSourceFile file;
                    String lib;
                    Object data$iv;
                    KotlinSourceFile file$iv;
                    Map.Entry entry2;
                    boolean $i$f$all;
                    Iterable $this$all$iv$iv;
                    Map.Entry entry3;
                    boolean bl4;
                    boolean $i$f$allFiles;
                    void updatedHeader;
                    KotlinSourceFileMetadata cachedHeader;
                    void srcFile2;
                    block27: {
                        Map.Entry element$iv$iv3;
                        Map.Entry entry32 = element$iv$iv3 = iterator5.next();
                        boolean bl9 = false;
                        KotlinSourceFile file$iv2 = (KotlinSourceFile)entry32.getKey();
                        Object data$iv2 = entry32.getValue();
                        srcFile = (DirtyFileMetadata)data$iv2;
                        libFile = file$iv2;
                        String libFile2 = lib$iv;
                        boolean bl10 = false;
                        if (!KotlinLibraryFile.equals-impl0(libFile2, stdlibFile)) {
                            ICUtilsKt.icError-T6xF6yw$default("unexpected lib while parsing stdlib dependencies", libFile2, (KotlinSourceFile)srcFile2, null, 8, null);
                            throw new KotlinNothingValueException();
                        }
                        cachedHeader = incrementalCache.fetchSourceFileFullMetadata((KotlinSourceFile)srcFile2);
                        KotlinSourceFileMap this_$iv32 = updatedHeader.getDirectDependencies();
                        $i$f$allFiles = false;
                        Iterable $this$all$iv$iv2 = this_$iv32.entrySet();
                        boolean $i$f$all2 = false;
                        if ($this$all$iv$iv2 instanceof Collection && ((Collection)$this$all$iv$iv2).isEmpty()) {
                            bl4 = true;
                        } else {
                            for (Object t2 : $this$all$iv$iv2) {
                                boolean bl5;
                                block26: {
                                    entry3 = (Map.Entry)t2;
                                    boolean bl7 = false;
                                    String lib$iv22 = ((KotlinLibraryFile)entry3.getKey()).unbox-impl();
                                    Map files$iv22 = (Map)entry3.getValue();
                                    $this$all$iv$iv = files$iv22.entrySet();
                                    $i$f$all = false;
                                    if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
                                        bl5 = true;
                                    } else {
                                        for (Object t3 : $this$all$iv$iv) {
                                            entry2 = (Map.Entry)t3;
                                            boolean bl6 = false;
                                            file$iv = (KotlinSourceFile)entry2.getKey();
                                            data$iv = entry2.getValue();
                                            Map map = (Map)data$iv;
                                            KotlinSourceFile kotlinSourceFile = file$iv;
                                            lib = lib$iv22;
                                            boolean bl12 = false;
                                            Map<IdSignature, ICHash> map2 = cachedHeader.getDirectDependencies().get-BOFFYcU(lib, file);
                                            if (map2 != null && (map2 = map2.keySet()) != null ? map2.containsAll(dependencies.keySet()) : dependencies.isEmpty()) continue;
                                            bl5 = false;
                                            break block26;
                                        }
                                        bl5 = true;
                                    }
                                }
                                if (bl5) continue;
                                bl4 = false;
                                break block27;
                            }
                            bl4 = true;
                        }
                    }
                    if (!bl4) {
                        bl3 = true;
                    } else {
                        boolean bl6;
                        block29: {
                            this_$iv3 = updatedHeader.getInverseDependencies();
                            $i$f$allFiles = false;
                            Iterable $this$all$iv$iv2 = this_$iv3.entrySet();
                            boolean $i$f$all2 = false;
                            if ($this$all$iv$iv2 instanceof Collection && ((Collection)$this$all$iv$iv2).isEmpty()) {
                                bl6 = true;
                            } else {
                                for (Object object : $this$all$iv$iv2) {
                                    boolean bl7;
                                    block28: {
                                        entry3 = (Map.Entry)object;
                                        boolean bl8 = false;
                                        lib$iv2 = ((KotlinLibraryFile)entry3.getKey()).unbox-impl();
                                        files$iv2 = (Map)entry3.getValue();
                                        $this$all$iv$iv = files$iv2.entrySet();
                                        $i$f$all = false;
                                        if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
                                            bl7 = true;
                                        } else {
                                            for (Object object2 : $this$all$iv$iv) {
                                                entry2 = (Map.Entry)object2;
                                                boolean bl9 = false;
                                                file$iv = (KotlinSourceFile)entry2.getKey();
                                                data$iv = entry2.getValue();
                                                dependencies = (Set)data$iv;
                                                file = file$iv;
                                                lib = lib$iv2;
                                                boolean bl15 = false;
                                                Set<IdSignature> set2 = cachedHeader.getInverseDependencies().get-BOFFYcU(lib, file);
                                                if (set2 != null ? set2.containsAll((Collection)((Object)invDependencies)) : invDependencies.isEmpty()) continue;
                                                bl7 = false;
                                                break block28;
                                            }
                                            bl7 = true;
                                        }
                                    }
                                    if (bl7) continue;
                                    bl6 = false;
                                    break block29;
                                }
                                bl6 = true;
                            }
                        }
                        bl3 = !bl6;
                    }
                    if (!(needUpdate = bl3)) continue;
                    this_$iv3 = cachedHeader.getDirectDependencies();
                    boolean $i$f$forEachFile3 = false;
                    Map $this$forEach$iv$iv6 = this_$iv3;
                    boolean $i$f$forEach6 = false;
                    Iterator<Object> iterator6 = $this$forEach$iv$iv6.entrySet().iterator();
                    while (iterator6.hasNext()) {
                        Map.Entry entry4;
                        entry3 = entry4 = (Map.Entry)iterator6.next();
                        bl2 = false;
                        lib$iv2 = ((KotlinLibraryFile)entry3.getKey()).unbox-impl();
                        Map $this$forEach$iv$iv5 = files$iv2 = (Map)entry3.getValue();
                        boolean $i$f$forEach5 = false;
                        iterator3 = $this$forEach$iv$iv5.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            Map.Entry entry5;
                            entry2 = entry5 = (Map.Entry)iterator3.next();
                            boolean bl42 = false;
                            file$iv = (KotlinSourceFile)entry2.getKey();
                            data$iv = entry2.getValue();
                            invDependencies = (Map)data$iv;
                            file = file$iv;
                            lib = lib$iv2;
                            boolean bl16 = false;
                            updatedDependencies = (Map)updatedHeader.getDirectDependencies().get-BOFFYcU(lib, file);
                            if (updatedDependencies != null) {
                                updatedDependencies.putAll(dependencies);
                                continue;
                            }
                            ((KotlinSourceFileMutableMap)updatedHeader.getDirectDependencies()).set-wkabOcM(lib, file, new HashMap(dependencies));
                        }
                    }
                    this_$iv3 = cachedHeader.getInverseDependencies();
                    boolean $i$f$forEachFile4 = false;
                    Map $this$forEach$iv$iv2 = this_$iv3;
                    boolean $i$f$forEach2 = false;
                    iterator6 = $this$forEach$iv$iv2.entrySet().iterator();
                    while (iterator6.hasNext()) {
                        Map.Entry entry6;
                        entry3 = entry6 = (Map.Entry)iterator6.next();
                        bl2 = false;
                        lib$iv2 = ((KotlinLibraryFile)entry3.getKey()).unbox-impl();
                        Map $this$forEach$iv$iv5 = files$iv2 = (Map)entry3.getValue();
                        boolean $i$f$forEach5 = false;
                        iterator3 = $this$forEach$iv$iv5.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            Map.Entry entry7;
                            entry2 = entry7 = (Map.Entry)iterator3.next();
                            boolean bl10 = false;
                            file$iv = (KotlinSourceFile)entry2.getKey();
                            data$iv = entry2.getValue();
                            dependencies = (Set)data$iv;
                            file = file$iv;
                            lib = lib$iv2;
                            boolean bl17 = false;
                            updatedDependencies = (Set)updatedHeader.getInverseDependencies().get-BOFFYcU(lib, file);
                            if (updatedDependencies != null) {
                                CollectionsKt.addAll((Collection)((Collection)updatedDependencies), (Iterable)dependencies);
                                continue;
                            }
                            ((KotlinSourceFileMutableMap)updatedHeader.getInverseDependencies()).set-wkabOcM(lib, file, new HashSet(dependencies));
                        }
                    }
                    incrementalCache.updateSourceFileMetadata((KotlinSourceFile)srcFile2, (KotlinSourceFileMetadata)updatedHeader);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<KotlinLibraryFile, IncrementalCacheArtifact> buildAndCommitCacheArtifacts(@NotNull LoadedJsIr loadedIr) {
            void $this$associateWithTo$iv$iv;
            void $this$associateWith$iv;
            void destination$iv;
            Object it;
            Iterable $this$mapNotNullTo$iv;
            Intrinsics.checkNotNullParameter((Object)loadedIr, (String)"loadedIr");
            if (CacheUpdater.this.commitIncrementalCache) {
                Iterable $this$forEach$iv = this.removedIncrementalCaches;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IncrementalCache it2 = (IncrementalCache)element$iv;
                    boolean bl = false;
                    if (FilesKt.deleteRecursively((File)it2.getCacheDir())) continue;
                    ICUtilsKt.icError-T6xF6yw$default("can not delete cache directory " + it2.getCacheDir().getAbsolutePath(), null, null, null, 14, null);
                    throw new KotlinNothingValueException();
                }
            }
            Iterable $i$f$forEach = loadedIr.collectSymbolsReplacedWithStubs();
            Object object = new HashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach22 = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IdSignature it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                it = (IrSymbol)element$iv;
                boolean bl2 = false;
                if (it.getSignature() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            HashSet stubbedSignatures = (HashSet)destination$iv;
            $this$mapNotNullTo$iv = loadedIr.getOrderedFragments().keySet();
            object = CacheUpdater.this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $i$f$forEach22 = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                IrModuleFragment libFragment;
                IncrementalCacheArtifact cacheArtifact;
                IncrementalCacheArtifact incrementalCacheArtifact;
                void libFile;
                it = ((KotlinLibraryFile)element$iv$iv).unbox-impl();
                Object t2 = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                IncrementalCache incrementalCache = this.getLibIncrementalCache-5h9WozY((String)libFile);
                List<FileSignatureProvider> providers = loadedIr.getSignatureProvidersForLib-5h9WozY((String)libFile);
                if (((CacheUpdater)object).commitIncrementalCache) {
                    void $this$associateTo$iv$iv;
                    Iterable $this$associate$iv = providers;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associate$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv2;
                        FileSignatureProvider it3 = (FileSignatureProvider)element$iv$iv2;
                        boolean bl4 = false;
                        Pair pair = TuplesKt.to((Object)it3.getSrcFile(), it3.getSignatureToIndexMapping());
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    Map signatureToIndexMapping = destination$iv$iv2;
                    incrementalCacheArtifact = incrementalCache.buildAndCommitCacheArtifact(signatureToIndexMapping, stubbedSignatures);
                } else {
                    incrementalCacheArtifact = cacheArtifact = incrementalCache.buildCacheArtifact();
                }
                if (loadedIr.getOrderedFragments().get(KotlinLibraryFile.box-impl((String)libFile)) == null) {
                    ICUtilsKt.notFoundIcError-5vrbIOY$default("loaded fragment", (String)libFile, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                Map<IrFile, KotlinSourceFile> sourceNames = loadedIr.getIrFileNames(libFragment);
                HashSet<KotlinSourceFile> sourceFilesFromCache = cacheArtifact.getSourceFiles();
                for (IrFile irFile : libFragment.getFiles()) {
                    KotlinSourceFile srcName;
                    if (sourceNames.get(irFile) == null) {
                        ICUtilsKt.notFoundIcError-SdI_NTg("source file name", (String)libFile, irFile);
                        throw new KotlinNothingValueException();
                    }
                    if (sourceFilesFromCache.contains(srcName)) continue;
                    ICUtilsKt.icError-T6xF6yw$default("file " + irFile.getFileEntry().getName() + " is absent in incremental cache and klib", (String)libFile, null, null, 12, null);
                    throw new KotlinNothingValueException();
                }
                IncrementalCacheArtifact incrementalCacheArtifact2 = cacheArtifact;
                map.put(t2, incrementalCacheArtifact2);
            }
            return destination$iv$iv;
        }

        private static final File removedIncrementalCaches$lambda$0$1(Path it) {
            return it.toFile();
        }

        private static final File removedIncrementalCaches$lambda$0$2(Function1 $tmp0, Object p0) {
            return (File)$tmp0.invoke(p0);
        }

        private static final boolean removedIncrementalCaches$lambda$0$3(CacheUpdater this$0, HashSet $availableCaches, File it) {
            return !Intrinsics.areEqual((Object)it, (Object)this$0.cacheRootDir) && !$availableCaches.contains(it);
        }

        private static final boolean removedIncrementalCaches$lambda$0$4(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit removedIncrementalCaches$lambda$0$5(List $this_buildList, File removedCacheDir) {
            Intrinsics.checkNotNull((Object)removedCacheDir);
            $this_buildList.add(new IncrementalCache(new KotlinRemovedLibraryHeader(removedCacheDir), removedCacheDir));
            return Unit.INSTANCE;
        }

        private static final void removedIncrementalCaches$lambda$0$6(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Map<KotlinSourceFile, KotlinSourceFileMetadata> addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$1(Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileMetadata>> $extraModifiedFiles$delegate) {
            Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileMetadata>> lazy = $extraModifiedFiles$delegate;
            return (Map)lazy.getValue();
        }

        private static final Map addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$0(KotlinSourceFileMutableMap $extraModifiedLibFiles, String $dependentLib) {
            return $extraModifiedLibFiles.getOrPutFiles-5h9WozY($dependentLib);
        }

        private static final Map<KotlinSourceFile, EnumSet<DirtyFileState>> addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$3(Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>> $fileStats$delegate) {
            Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>> lazy = $fileStats$delegate;
            return (Map)lazy.getValue();
        }

        private static final Map addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$2(CacheUpdater this$0, String $dependentLib) {
            return this$0.dirtyFileStats.getOrPutFiles-5h9WozY($dependentLib);
        }

        private static final void addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles(CacheUpdaterInternal this$0, KotlinSourceFileMutableMap<KotlinSourceFileMetadata> $modifiedFiles, KotlinSourceFileMap<? extends KotlinSourceFileMetadata> $removedFiles, CacheUpdater this$1, KotlinSourceFileMutableMap<KotlinSourceFileMetadata> extraModifiedLibFiles, KotlinSourceFileMap<?> dependencies, DirtyFileState dirtyState) {
            for (Map.Entry entry : ((Map)dependencies).entrySet()) {
                Map map;
                Map alreadyModifiedFiles;
                String dependentLib = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
                Map dependentFiles = (Map)entry.getValue();
                if (this$0.incrementalCaches.get(KotlinLibraryFile.box-impl(dependentLib)) == null) continue;
                Map map2 = $modifiedFiles.get-5h9WozY(dependentLib);
                if (map2 == null) {
                    map2 = alreadyModifiedFiles = MapsKt.emptyMap();
                }
                if ((map = $removedFiles.get-5h9WozY(dependentLib)) == null) {
                    map = MapsKt.emptyMap();
                }
                Map alreadyRemovedFiles = map;
                Lazy extraModifiedFiles$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheUpdaterInternal.addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$0(extraModifiedLibFiles, dependentLib));
                Lazy fileStats$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheUpdaterInternal.addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$2(this$1, dependentLib));
                for (KotlinSourceFile dependentFile : dependentFiles.keySet()) {
                    IncrementalCache dependentCache;
                    KotlinSourceFile kotlinSourceFile = dependentFile;
                    if (alreadyModifiedFiles.containsKey(kotlinSourceFile) || alreadyRemovedFiles.containsKey(kotlinSourceFile) || CacheUpdaterInternal.addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$1((Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileMetadata>>)extraModifiedFiles$delegate).containsKey(kotlinSourceFile)) continue;
                    KotlinSourceFileMetadata dependentMetadata = dependentCache.fetchSourceFileFullMetadata(dependentFile);
                    CacheUpdaterInternal.addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$1((Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileMetadata>>)extraModifiedFiles$delegate).put(dependentFile, dependentMetadata);
                    this$1.addDirtFileStat(CacheUpdaterInternal.addFilesWithRemovedDependencies$addDependenciesToExtraModifiedFiles$lambda$3((Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>>)fileStats$delegate), dependentFile, dirtyState);
                }
            }
        }

        private static final Map<KotlinSourceFile, EnumSet<DirtyFileState>> loadModifiedFiles$collectDirtyFiles$lambda$1(Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>> $fileStats$delegate) {
            Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>> lazy = $fileStats$delegate;
            return (Map)lazy.getValue();
        }

        private static final Map loadModifiedFiles$collectDirtyFiles$lambda$0(CacheUpdater this$0, String $lib) {
            return this$0.dirtyFileStats.getOrPutFiles-5h9WozY($lib);
        }

        /*
         * WARNING - void declaration
         */
        private static final Map<KotlinSourceFile, KotlinSourceFileMetadata> loadModifiedFiles$collectDirtyFiles(HashMap<KotlinLibraryFile, Map<KotlinSourceFile, KotlinSourceFileMetadata>> removedFilesMetadata, CacheUpdater this$0, String lib, IncrementalCache cache2) {
            void $this$associateWithTo$iv;
            boolean bl;
            Object it;
            IncrementalCache.ModifiedFiles modifiedFiles = cache2.collectModifiedFiles();
            Collection<KotlinSourceFile> addedFiles = modifiedFiles.component1();
            Map<KotlinSourceFile, KotlinSourceFileMetadata> removedFiles = modifiedFiles.component2();
            Map<KotlinSourceFile, KotlinSourceFileMetadata> modifiedFiles2 = modifiedFiles.component3();
            Collection<KotlinSourceFile> nonModifiedFiles = modifiedFiles.component4();
            Lazy fileStats$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheUpdaterInternal.loadModifiedFiles$collectDirtyFiles$lambda$0(this$0, lib));
            Object $this$forEach$iv = addedFiles;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object t2 = iterator2.next();
                it = (KotlinSourceFile)t2;
                bl = false;
                this$0.addDirtFileStat(CacheUpdaterInternal.loadModifiedFiles$collectDirtyFiles$lambda$1((Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>>)fileStats$delegate), (KotlinSourceFile)it, DirtyFileState.ADDED_FILE);
            }
            $this$forEach$iv = removedFiles;
            $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                it = entry;
                bl = false;
                this$0.addDirtFileStat(CacheUpdaterInternal.loadModifiedFiles$collectDirtyFiles$lambda$1((Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>>)fileStats$delegate), (KotlinSourceFile)it.getKey(), DirtyFileState.REMOVED_FILE);
            }
            $this$forEach$iv = modifiedFiles2;
            $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                it = entry;
                bl = false;
                this$0.addDirtFileStat(CacheUpdaterInternal.loadModifiedFiles$collectDirtyFiles$lambda$1((Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>>)fileStats$delegate), (KotlinSourceFile)it.getKey(), DirtyFileState.MODIFIED_IR);
            }
            $this$forEach$iv = nonModifiedFiles;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                it = (KotlinSourceFile)object;
                bl = false;
                this$0.addDirtFileStat(CacheUpdaterInternal.loadModifiedFiles$collectDirtyFiles$lambda$1((Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>>)fileStats$delegate), (KotlinSourceFile)it, DirtyFileState.NON_MODIFIED_IR);
            }
            if (!removedFiles.isEmpty()) {
                ((Map)removedFilesMetadata).put(KotlinLibraryFile.box-impl(lib), removedFiles);
            }
            $this$forEach$iv = addedFiles;
            Map destination$iv = MapsKt.toMutableMap(modifiedFiles2);
            boolean $i$f$associateWithTo = false;
            for (Object element$iv3 : $this$associateWithTo$iv) {
                KotlinSourceFile bl2 = (KotlinSourceFile)element$iv3;
                Object t3 = element$iv3;
                Map map = destination$iv;
                boolean bl22 = false;
                KotlinSourceFileMetadataNotExist kotlinSourceFileMetadataNotExist = KotlinSourceFileMetadataNotExist.INSTANCE;
                map.put(t3, kotlinSourceFileMetadataNotExist);
            }
            return destination$iv;
        }

        private static final Map<KotlinSourceFile, KotlinSourceFileExports> collectFilesToRebuildSignatures$lambda$1(Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileExports>> $filesToRebuild$delegate) {
            Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileExports>> lazy = $filesToRebuild$delegate;
            return (Map)lazy.getValue();
        }

        private static final Map collectFilesToRebuildSignatures$lambda$0(KotlinSourceFileMutableMap $libFilesToRebuild, String $libFile) {
            return $libFilesToRebuild.getOrPutFiles-5h9WozY($libFile);
        }

        private static final Map<KotlinSourceFile, EnumSet<DirtyFileState>> collectFilesToRebuildSignatures$lambda$3(Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>> $fileStats$delegate) {
            Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>> lazy = $fileStats$delegate;
            return (Map)lazy.getValue();
        }

        private static final Map collectFilesToRebuildSignatures$lambda$2(CacheUpdater this$0, String $libFile) {
            return this$0.dirtyFileStats.getOrPutFiles-5h9WozY($libFile);
        }

        private static final Map<KotlinSourceFile, KotlinSourceFileExports> collectFilesWithUpdatedStubbedSymbols$lambda$1(Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileExports>> $filesToRebuild$delegate) {
            Lazy<? extends Map<KotlinSourceFile, KotlinSourceFileExports>> lazy = $filesToRebuild$delegate;
            return (Map)lazy.getValue();
        }

        private static final Map collectFilesWithUpdatedStubbedSymbols$lambda$0(KotlinSourceFileMutableMap $libFiles, String $libFile) {
            return $libFiles.getOrPutFiles-5h9WozY($libFile);
        }

        private static final Map<KotlinSourceFile, EnumSet<DirtyFileState>> collectFilesWithUpdatedStubbedSymbols$lambda$3(Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>> $fileStats$delegate) {
            Lazy<? extends Map<KotlinSourceFile, EnumSet<DirtyFileState>>> lazy = $fileStats$delegate;
            return (Map)lazy.getValue();
        }

        private static final Map collectFilesWithUpdatedStubbedSymbols$lambda$2(CacheUpdater this$0, String $libFile) {
            return this$0.dirtyFileStats.getOrPutFiles-5h9WozY($libFile);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BU\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012$\u0010\b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J'\u0010\u0017\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n0\tH\u00c6\u0003J]\u0010\u0018\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00032&\b\u0002\u0010\b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n0\tH\u00c6\u0001J\u0014\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u0007H\u00d6\u0081\u0004R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R/\u0010\b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater$FragmentGenerators;", "", "incrementalCacheArtifacts", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryFile;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheArtifact;", "moduleNames", "", "generators", "", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IrICProgramFragments;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/List;)V", "getIncrementalCacheArtifacts", "()Ljava/util/Map;", "getModuleNames", "getGenerators", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.js"})
    private static final class FragmentGenerators {
        @NotNull
        private final Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCacheArtifacts;
        @NotNull
        private final Map<KotlinLibraryFile, String> moduleNames;
        @NotNull
        private final List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> generators;

        public FragmentGenerators(@NotNull Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCacheArtifacts, @NotNull Map<KotlinLibraryFile, String> moduleNames, @NotNull List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> generators) {
            Intrinsics.checkNotNullParameter(incrementalCacheArtifacts, (String)"incrementalCacheArtifacts");
            Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
            Intrinsics.checkNotNullParameter(generators, (String)"generators");
            this.incrementalCacheArtifacts = incrementalCacheArtifacts;
            this.moduleNames = moduleNames;
            this.generators = generators;
        }

        @NotNull
        public final Map<KotlinLibraryFile, IncrementalCacheArtifact> getIncrementalCacheArtifacts() {
            return this.incrementalCacheArtifacts;
        }

        @NotNull
        public final Map<KotlinLibraryFile, String> getModuleNames() {
            return this.moduleNames;
        }

        @NotNull
        public final List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> getGenerators() {
            return this.generators;
        }

        @NotNull
        public final Map<KotlinLibraryFile, IncrementalCacheArtifact> component1() {
            return this.incrementalCacheArtifacts;
        }

        @NotNull
        public final Map<KotlinLibraryFile, String> component2() {
            return this.moduleNames;
        }

        @NotNull
        public final List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> component3() {
            return this.generators;
        }

        @NotNull
        public final FragmentGenerators copy(@NotNull Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCacheArtifacts, @NotNull Map<KotlinLibraryFile, String> moduleNames, @NotNull List<Triple<KotlinLibraryFile, KotlinSourceFile, Function0<IrICProgramFragments>>> generators) {
            Intrinsics.checkNotNullParameter(incrementalCacheArtifacts, (String)"incrementalCacheArtifacts");
            Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
            Intrinsics.checkNotNullParameter(generators, (String)"generators");
            return new FragmentGenerators(incrementalCacheArtifacts, moduleNames, generators);
        }

        public static /* synthetic */ FragmentGenerators copy$default(FragmentGenerators fragmentGenerators, Map map, Map map2, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                map = fragmentGenerators.incrementalCacheArtifacts;
            }
            if ((n2 & 2) != 0) {
                map2 = fragmentGenerators.moduleNames;
            }
            if ((n2 & 4) != 0) {
                list = fragmentGenerators.generators;
            }
            return fragmentGenerators.copy(map, map2, list);
        }

        @NotNull
        public String toString() {
            return "FragmentGenerators(incrementalCacheArtifacts=" + this.incrementalCacheArtifacts + ", moduleNames=" + this.moduleNames + ", generators=" + this.generators + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.incrementalCacheArtifacts).hashCode();
            result2 = result2 * 31 + ((Object)this.moduleNames).hashCode();
            result2 = result2 * 31 + ((Object)this.generators).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FragmentGenerators)) {
                return false;
            }
            FragmentGenerators fragmentGenerators = (FragmentGenerators)other;
            if (!Intrinsics.areEqual(this.incrementalCacheArtifacts, fragmentGenerators.incrementalCacheArtifacts)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.moduleNames, fragmentGenerators.moduleNames)) {
                return false;
            }
            return Intrinsics.areEqual(this.generators, fragmentGenerators.generators);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BE\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u001b\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\fH\u00c6\u0003JO\u0010\u001a\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00032\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater$IrForDirtyFilesAndCompiler;", "", "incrementalCacheArtifacts", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinLibraryFile;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheArtifact;", "loadedIr", "Lorg/jetbrains/kotlin/ir/backend/js/ic/LoadedJsIr;", "dirtyFiles", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/KotlinSourceFile;", "irCompiler", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IrCompilerICInterface;", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/ir/backend/js/ic/LoadedJsIr;Ljava/util/Map;Lorg/jetbrains/kotlin/ir/backend/js/ic/IrCompilerICInterface;)V", "getIncrementalCacheArtifacts", "()Ljava/util/Map;", "getLoadedIr", "()Lorg/jetbrains/kotlin/ir/backend/js/ic/LoadedJsIr;", "getDirtyFiles", "getIrCompiler", "()Lorg/jetbrains/kotlin/ir/backend/js/ic/IrCompilerICInterface;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    private static final class IrForDirtyFilesAndCompiler {
        @NotNull
        private final Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCacheArtifacts;
        @NotNull
        private final LoadedJsIr loadedIr;
        @NotNull
        private final Map<KotlinLibraryFile, Set<KotlinSourceFile>> dirtyFiles;
        @NotNull
        private final IrCompilerICInterface irCompiler;

        public IrForDirtyFilesAndCompiler(@NotNull Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCacheArtifacts, @NotNull LoadedJsIr loadedIr, @NotNull Map<KotlinLibraryFile, ? extends Set<KotlinSourceFile>> dirtyFiles, @NotNull IrCompilerICInterface irCompiler) {
            Intrinsics.checkNotNullParameter(incrementalCacheArtifacts, (String)"incrementalCacheArtifacts");
            Intrinsics.checkNotNullParameter((Object)loadedIr, (String)"loadedIr");
            Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
            Intrinsics.checkNotNullParameter((Object)irCompiler, (String)"irCompiler");
            this.incrementalCacheArtifacts = incrementalCacheArtifacts;
            this.loadedIr = loadedIr;
            this.dirtyFiles = dirtyFiles;
            this.irCompiler = irCompiler;
        }

        @NotNull
        public final Map<KotlinLibraryFile, IncrementalCacheArtifact> getIncrementalCacheArtifacts() {
            return this.incrementalCacheArtifacts;
        }

        @NotNull
        public final LoadedJsIr getLoadedIr() {
            return this.loadedIr;
        }

        @NotNull
        public final Map<KotlinLibraryFile, Set<KotlinSourceFile>> getDirtyFiles() {
            return this.dirtyFiles;
        }

        @NotNull
        public final IrCompilerICInterface getIrCompiler() {
            return this.irCompiler;
        }

        @NotNull
        public final Map<KotlinLibraryFile, IncrementalCacheArtifact> component1() {
            return this.incrementalCacheArtifacts;
        }

        @NotNull
        public final LoadedJsIr component2() {
            return this.loadedIr;
        }

        @NotNull
        public final Map<KotlinLibraryFile, Set<KotlinSourceFile>> component3() {
            return this.dirtyFiles;
        }

        @NotNull
        public final IrCompilerICInterface component4() {
            return this.irCompiler;
        }

        @NotNull
        public final IrForDirtyFilesAndCompiler copy(@NotNull Map<KotlinLibraryFile, IncrementalCacheArtifact> incrementalCacheArtifacts, @NotNull LoadedJsIr loadedIr, @NotNull Map<KotlinLibraryFile, ? extends Set<KotlinSourceFile>> dirtyFiles, @NotNull IrCompilerICInterface irCompiler) {
            Intrinsics.checkNotNullParameter(incrementalCacheArtifacts, (String)"incrementalCacheArtifacts");
            Intrinsics.checkNotNullParameter((Object)loadedIr, (String)"loadedIr");
            Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
            Intrinsics.checkNotNullParameter((Object)irCompiler, (String)"irCompiler");
            return new IrForDirtyFilesAndCompiler(incrementalCacheArtifacts, loadedIr, dirtyFiles, irCompiler);
        }

        public static /* synthetic */ IrForDirtyFilesAndCompiler copy$default(IrForDirtyFilesAndCompiler irForDirtyFilesAndCompiler, Map map, LoadedJsIr loadedJsIr, Map map2, IrCompilerICInterface irCompilerICInterface, int n2, Object object) {
            if ((n2 & 1) != 0) {
                map = irForDirtyFilesAndCompiler.incrementalCacheArtifacts;
            }
            if ((n2 & 2) != 0) {
                loadedJsIr = irForDirtyFilesAndCompiler.loadedIr;
            }
            if ((n2 & 4) != 0) {
                map2 = irForDirtyFilesAndCompiler.dirtyFiles;
            }
            if ((n2 & 8) != 0) {
                irCompilerICInterface = irForDirtyFilesAndCompiler.irCompiler;
            }
            return irForDirtyFilesAndCompiler.copy(map, loadedJsIr, map2, irCompilerICInterface);
        }

        @NotNull
        public String toString() {
            return "IrForDirtyFilesAndCompiler(incrementalCacheArtifacts=" + this.incrementalCacheArtifacts + ", loadedIr=" + this.loadedIr + ", dirtyFiles=" + this.dirtyFiles + ", irCompiler=" + this.irCompiler + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.incrementalCacheArtifacts).hashCode();
            result2 = result2 * 31 + this.loadedIr.hashCode();
            result2 = result2 * 31 + ((Object)this.dirtyFiles).hashCode();
            result2 = result2 * 31 + this.irCompiler.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IrForDirtyFilesAndCompiler)) {
                return false;
            }
            IrForDirtyFilesAndCompiler irForDirtyFilesAndCompiler = (IrForDirtyFilesAndCompiler)other;
            if (!Intrinsics.areEqual(this.incrementalCacheArtifacts, irForDirtyFilesAndCompiler.incrementalCacheArtifacts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.loadedIr, (Object)irForDirtyFilesAndCompiler.loadedIr)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dirtyFiles, irForDirtyFilesAndCompiler.dirtyFiles)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.irCompiler, (Object)irForDirtyFilesAndCompiler.irCompiler);
        }
    }
}

