/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.incremental.components.ICFileMappingTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0016J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0016J\u0014\u0010\u001a\u001a\u00020\u00132\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/IncrementalPassThroughLookupTrackerComponent;", "Lorg/jetbrains/kotlin/fir/FirLookupTrackerComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "fileMappingTracker", "Lorg/jetbrains/kotlin/incremental/components/ICFileMappingTracker;", "sourceToFilePath", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/KtSourceElement;", "", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/incremental/components/LookupTracker;Lorg/jetbrains/kotlin/incremental/components/ICFileMappingTracker;Lkotlin/jvm/functions/Function1;)V", "requiresPosition", "", "sourceToFilePathsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "recordLookup", "", "name", "inScopes", "", "source", "fileSource", "inScope", "recordDirtyDeclaration", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nIncrementalPassThroughLookupTrackerComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalPassThroughLookupTrackerComponent.kt\norg/jetbrains/kotlin/fir/IncrementalPassThroughLookupTrackerComponent\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n72#2,2:65\n1#3:67\n1#3:68\n*S KotlinDebug\n*F\n+ 1 IncrementalPassThroughLookupTrackerComponent.kt\norg/jetbrains/kotlin/fir/IncrementalPassThroughLookupTrackerComponent\n*L\n38#1:65,2\n38#1:67\n*E\n"})
public final class IncrementalPassThroughLookupTrackerComponent
extends FirLookupTrackerComponent {
    @NotNull
    private final FirSession session;
    @NotNull
    private final LookupTracker lookupTracker;
    @Nullable
    private final ICFileMappingTracker fileMappingTracker;
    @NotNull
    private final Function1<KtSourceElement, String> sourceToFilePath;
    private final boolean requiresPosition;
    @NotNull
    private final ConcurrentHashMap<KtSourceElement, String> sourceToFilePathsCache;

    public IncrementalPassThroughLookupTrackerComponent(@NotNull FirSession session, @NotNull LookupTracker lookupTracker, @Nullable ICFileMappingTracker fileMappingTracker, @NotNull Function1<? super KtSourceElement, String> sourceToFilePath) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter(sourceToFilePath, (String)"sourceToFilePath");
        this.session = session;
        this.lookupTracker = lookupTracker;
        this.fileMappingTracker = fileMappingTracker;
        this.sourceToFilePath = sourceToFilePath;
        this.requiresPosition = this.lookupTracker.getRequiresPosition();
        this.sourceToFilePathsCache = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void recordLookup(@NotNull String name2, @NotNull Iterable<String> inScopes, @Nullable KtSourceElement source, @Nullable KtSourceElement fileSource) {
        Position position;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(inScopes, (String)"inScopes");
        KtSourceElement ktSourceElement = fileSource;
        if (ktSourceElement == null) {
            KtPsiSourceElement ktPsiSourceElement = source instanceof KtPsiSourceElement ? (KtPsiSourceElement)source : null;
            if (ktPsiSourceElement != null) {
                ktSourceElement = ktPsiSourceElement;
            } else {
                return;
            }
        }
        KtSourceElement definedSource = ktSourceElement;
        ConcurrentMap concurrentMap = this.sourceToFilePathsCache;
        KtSourceElement key$iv = definedSource;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            String string = (String)this.sourceToFilePath.invoke((Object)definedSource);
            if (string == null) {
                return;
            }
            String default$iv = string;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        String path = (String)object;
        if (this.requiresPosition && source != null && source instanceof KtPsiSourceElement) {
            PsiDiagnosticUtils.LineAndColumn it = DiagnosticUtils.getLineAndColumnInPsiFile(((KtPsiSourceElement)source).getPsi().getContainingFile(), ((KtPsiSourceElement)source).getPsi().getTextRange());
            boolean bl = false;
            position = new Position(it.getLine(), it.getColumn());
        } else {
            position = Position.Companion.getNO_POSITION();
        }
        Position position2 = position;
        for (String scope2 : inScopes) {
            Intrinsics.checkNotNull((Object)path);
            this.lookupTracker.record(path, position2, scope2, ScopeKind.PACKAGE, name2);
        }
    }

    @Override
    public void recordLookup(@NotNull String name2, @NotNull String inScope, @Nullable KtSourceElement source, @Nullable KtSourceElement fileSource) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inScope, (String)"inScope");
        this.recordLookup(name2, (Iterable<String>)new SmartList<String>(inScope), source, fileSource);
    }

    @Override
    public void recordDirtyDeclaration(@NotNull FirBasedSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        if (this.fileMappingTracker == null) {
            return;
        }
        FirFile firFile = FirProviderUtilsKt.getContainingFile(FirProviderKt.getFirProvider(this.session), symbol);
        if (firFile == null) {
            return;
        }
        FirFile containingFile = firFile;
        Object object = containingFile.getSourceFile();
        if (object == null || (object = object.getPath()) == null) {
            return;
        }
        Object it = object;
        boolean bl = false;
        File sourceFile = new File((String)it);
        this.fileMappingTracker.recordSourceReferencedByCompilerPlugin(sourceFile);
    }
}

