/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.internal.IdeaModuleSupport;
import org.gradle.plugins.ide.idea.internal.IdeaProjectInternal;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.IdeaModelBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.IdeaModelParameter;
import org.gradle.plugins.ide.internal.tooling.IdeaModuleBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaJavaLanguageSettings;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaLanguageLevel;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaModule;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaProject;
import org.gradle.plugins.ide.internal.tooling.idea.IsolatedIdeaModuleInternal;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.internal.IntermediateToolingModelProvider;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class IsolatedProjectsSafeIdeaModelBuilder
implements IdeaModelBuilderInternal,
ParameterizedToolingModelBuilder<IdeaModelParameter> {
    private static final String MODEL_NAME = IdeaProject.class.getName();
    private final IntermediateToolingModelProvider intermediateToolingModelProvider;
    private final GradleProjectBuilderInternal gradleProjectBuilder;

    public IsolatedProjectsSafeIdeaModelBuilder(IntermediateToolingModelProvider intermediateToolingModelProvider, GradleProjectBuilderInternal gradleProjectBuilder) {
        this.intermediateToolingModelProvider = intermediateToolingModelProvider;
        this.gradleProjectBuilder = gradleProjectBuilder;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(MODEL_NAME);
    }

    public Class<IdeaModelParameter> getParameterType() {
        return IdeaModelParameter.class;
    }

    public Object buildAll(String modelName, IdeaModelParameter parameter, Project project) {
        return this.buildForRoot(project, parameter.getOfflineDependencyResolution());
    }

    public DefaultIdeaProject buildAll(String modelName, Project project) {
        return this.buildForRoot(project, false);
    }

    @Override
    public DefaultIdeaProject buildForRoot(Project project, boolean offlineDependencyResolution) {
        IsolatedProjectsSafeIdeaModelBuilder.requireRootProject(project);
        ProjectState rootProjectState = ((ProjectInternal)project).getOwner();
        BuildState owningBuild = rootProjectState.getOwner();
        this.applyIdeaPluginToBuildTree(owningBuild);
        IdeaModelParameter parameter = IsolatedProjectsSafeIdeaModelBuilder.createParameter(offlineDependencyResolution);
        return this.createIdeaProjectTreeForRootProject(project, parameter);
    }

    private static void requireRootProject(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new IllegalArgumentException(String.format("%s can only be requested on the root project, got %s", MODEL_NAME, project));
        }
    }

    private void applyIdeaPluginToBuildTree(BuildState build) {
        this.applyIdeaPluginRecursively(build, new ArrayList<BuildState>());
    }

    private void applyIdeaPluginRecursively(BuildState build, List<BuildState> alreadyProcessed) {
        ProjectState rootProject = build.getProjects().getRootProject();
        this.intermediateToolingModelProvider.applyPlugin(rootProject, IsolatedProjectsSafeIdeaModelBuilder.getProjectsInBuild(build), IdeaPlugin.class);
        for (IncludedBuildInternal reference : build.getMutableModel().includedBuilds()) {
            BuildState childBuild = reference.getTarget();
            if (!(childBuild instanceof IncludedBuildState) || alreadyProcessed.contains(childBuild)) continue;
            alreadyProcessed.add(childBuild);
            this.applyIdeaPluginRecursively(childBuild, alreadyProcessed);
        }
    }

    private DefaultIdeaProject createIdeaProjectTreeForRootProject(Project rootProject, IdeaModelParameter parameter) {
        rootProject.getPluginManager().apply(IdeaPlugin.class);
        IdeaModel ideaModelExt = ((IdeaPlugin)rootProject.getPlugins().getPlugin(IdeaPlugin.class)).getModel();
        IdeaProjectInternal ideaProjectExt = (IdeaProjectInternal)ideaModelExt.getProject();
        ProjectState rootProjectState = ((ProjectInternal)rootProject).getOwner();
        List<ProjectState> projectsInBuild = IsolatedProjectsSafeIdeaModelBuilder.getProjectsInBuild(rootProjectState.getOwner());
        List<IsolatedIdeaModuleInternal> allIsolatedIdeaModules = this.getIsolatedIdeaModules(rootProjectState, projectsInBuild, parameter);
        IdeaLanguageLevel languageLevel = IsolatedProjectsSafeIdeaModelBuilder.resolveRootLanguageLevel(ideaProjectExt, allIsolatedIdeaModules);
        JavaVersion targetBytecodeVersion = IsolatedProjectsSafeIdeaModelBuilder.resolveRootTargetBytecodeVersion(ideaProjectExt, allIsolatedIdeaModules);
        DefaultIdeaProject out = IsolatedProjectsSafeIdeaModelBuilder.buildWithoutChildren(ideaProjectExt, languageLevel, targetBytecodeVersion);
        DefaultGradleProject rootGradleProject = this.gradleProjectBuilder.buildForRoot(rootProject);
        IdeaModuleBuilder ideaModuleBuilder = new IdeaModuleBuilder(rootGradleProject, languageLevel, targetBytecodeVersion);
        List ideaModules = Streams.zip(projectsInBuild.stream(), allIsolatedIdeaModules.stream(), (project, isolatedIdeaModule) -> {
            DefaultIdeaModule ideaModuleForProject = ideaModuleBuilder.buildWithoutParent(project, isolatedIdeaModule);
            ideaModuleForProject.setParent(out);
            return ideaModuleForProject;
        }).collect(Collectors.toList());
        out.setChildren(ideaModules);
        return out;
    }

    private static List<ProjectState> getProjectsInBuild(BuildState build) {
        return ImmutableList.copyOf((Collection)build.getProjects().getAllProjects());
    }

    private static DefaultIdeaProject buildWithoutChildren(IdeaProjectInternal ideaProjectExt, IdeaLanguageLevel languageLevel, JavaVersion targetBytecodeVersion) {
        return new DefaultIdeaProject().setName(ideaProjectExt.getName()).setJdkName(ideaProjectExt.getJdkName()).setLanguageLevel((org.gradle.tooling.model.idea.IdeaLanguageLevel)new DefaultIdeaLanguageLevel(languageLevel.getLevel())).setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(IdeaModuleBuilderSupport.convertToJavaVersion(languageLevel)).setTargetBytecodeVersion(targetBytecodeVersion).setJdk(DefaultInstalledJdk.current()));
    }

    private static IdeaLanguageLevel resolveRootLanguageLevel(IdeaProjectInternal ideaProjectExt, List<IsolatedIdeaModuleInternal> isolatedModules) {
        IdeaLanguageLevel explicitLanguageLevel = ideaProjectExt.getRawLanguageLevel();
        if (explicitLanguageLevel != null) {
            return explicitLanguageLevel;
        }
        JavaVersion maxCompatibility = IsolatedProjectsSafeIdeaModelBuilder.getMaxCompatibility(isolatedModules, IsolatedIdeaModuleInternal::getJavaSourceCompatibility);
        return new IdeaLanguageLevel((Object)maxCompatibility);
    }

    private static JavaVersion resolveRootTargetBytecodeVersion(IdeaProjectInternal ideaProjectExt, List<IsolatedIdeaModuleInternal> isolatedModules) {
        JavaVersion explicitTargetBytecodeVersion = ideaProjectExt.getRawTargetBytecodeVersion();
        if (explicitTargetBytecodeVersion != null) {
            return explicitTargetBytecodeVersion;
        }
        return IsolatedProjectsSafeIdeaModelBuilder.getMaxCompatibility(isolatedModules, IsolatedIdeaModuleInternal::getJavaTargetCompatibility);
    }

    private List<IsolatedIdeaModuleInternal> getIsolatedIdeaModules(ProjectState rootProject, List<ProjectState> projectsInBuild, IdeaModelParameter parameter) {
        return this.intermediateToolingModelProvider.getModels(rootProject, projectsInBuild, IsolatedIdeaModuleInternal.class, (Object)parameter);
    }

    private static JavaVersion getMaxCompatibility(List<IsolatedIdeaModuleInternal> isolatedIdeaModules, Function<IsolatedIdeaModuleInternal, JavaVersion> getCompatibilty) {
        return isolatedIdeaModules.stream().map(getCompatibilty).filter(Objects::nonNull).max(Enum::compareTo).orElse(IdeaModuleSupport.FALLBACK_MODULE_JAVA_COMPATIBILITY_VERSION);
    }

    private static IdeaModelParameter createParameter(boolean offlineDependencyResolution) {
        return () -> offlineDependencyResolution;
    }

    private static class IdeaModuleBuilder {
        private final DefaultGradleProject rootGradleProject;
        private final IdeaLanguageLevel ideaProjectLanguageLevel;
        private final JavaVersion ideaProjectTargetBytecodeVersion;

        private IdeaModuleBuilder(DefaultGradleProject rootGradleProject, IdeaLanguageLevel ideaProjectLanguageLevel, JavaVersion ideaProjectTargetBytecodeVersion) {
            this.rootGradleProject = rootGradleProject;
            this.ideaProjectLanguageLevel = ideaProjectLanguageLevel;
            this.ideaProjectTargetBytecodeVersion = ideaProjectTargetBytecodeVersion;
        }

        private DefaultIdeaModule buildWithoutParent(ProjectState project, IsolatedIdeaModuleInternal isolatedIdeaModule) {
            boolean javaExtensionAvailableOnModule;
            DefaultIdeaModule model = new DefaultIdeaModule().setName(isolatedIdeaModule.getName()).setGradleProject(this.rootGradleProject.findByPath(project.getIdentity().getProjectPath().asString())).setContentRoots(Collections.singletonList(isolatedIdeaModule.getContentRoot())).setJdkName(isolatedIdeaModule.getJdkName()).setCompilerOutput((IdeaCompilerOutput)isolatedIdeaModule.getCompilerOutput());
            boolean bl = javaExtensionAvailableOnModule = isolatedIdeaModule.getJavaSourceCompatibility() != null || isolatedIdeaModule.getJavaTargetCompatibility() != null;
            if (javaExtensionAvailableOnModule) {
                IdeaLanguageLevel languageLevel = IdeaModuleBuilder.resolveLanguageLevel(isolatedIdeaModule);
                IdeaLanguageLevel moduleLanguageLevelOverride = IdeaModuleBuilder.takeIfDifferent(this.ideaProjectLanguageLevel, languageLevel);
                JavaVersion targetBytecodeVersion = IdeaModuleBuilder.resolveTargetBytecodeVersion(isolatedIdeaModule);
                JavaVersion moduleTargetBytecodeVersionOverride = IdeaModuleBuilder.takeIfDifferent(this.ideaProjectTargetBytecodeVersion, targetBytecodeVersion);
                model.setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(IdeaModuleBuilderSupport.convertToJavaVersion(moduleLanguageLevelOverride)).setTargetBytecodeVersion(moduleTargetBytecodeVersionOverride));
            }
            model.setDependencies(isolatedIdeaModule.getDependencies());
            return model;
        }

        private static @Nullable JavaVersion resolveTargetBytecodeVersion(IsolatedIdeaModuleInternal isolatedIdeaModule) {
            JavaVersion targetBytecodeVersionConvention = isolatedIdeaModule.getJavaTargetCompatibility();
            JavaVersion explicitTargetBytecodeVersion = isolatedIdeaModule.getExplicitTargetBytecodeVersion();
            return IdeaModuleBuilder.getPropertyValue(explicitTargetBytecodeVersion, targetBytecodeVersionConvention);
        }

        private static IdeaLanguageLevel resolveLanguageLevel(IsolatedIdeaModuleInternal isolatedIdeaModule) {
            JavaVersion languageLevelConvention = isolatedIdeaModule.getJavaSourceCompatibility();
            IdeaLanguageLevel explicitLanguageLevel = isolatedIdeaModule.getExplicitSourceLanguageLevel();
            return IdeaModuleBuilder.getPropertyValue(explicitLanguageLevel, new IdeaLanguageLevel((Object)languageLevelConvention));
        }

        private static <T> @Nullable T takeIfDifferent(T commonValue, @Nullable T value) {
            return commonValue.equals(value) ? null : (T)value;
        }

        private static <T> @Nullable T getPropertyValue(@Nullable T value, @Nullable T convention) {
            return value != null ? value : convention;
        }
    }
}

