/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.AbstractIntersection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.Intersection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeAnyOf;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeNothing;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleSetExclude;
import org.gradle.internal.collect.PersistentSet;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class Intersections {
    private final ExcludeFactory factory;
    private final List<Intersection<? extends ExcludeSpec, ? extends ExcludeSpec>> intersections = new ArrayList<Intersection<? extends ExcludeSpec, ? extends ExcludeSpec>>();

    public Intersections(ExcludeFactory factory) {
        this.factory = factory;
        this.intersections.add(new IntersectAnyWithAny());
        this.intersections.add(new IntersectAnyWithBaseSpec());
        this.intersections.add(new IntersectGroupWithGroup());
        this.intersections.add(new IntersectGroupWithModuleId());
        this.intersections.add(new IntersectGroupWithGroupSet());
        this.intersections.add(new IntersectGroupWithModuleIdSet());
        this.intersections.add(new IntersectGroupWithModule());
        this.intersections.add(new IntersectGroupWithModuleSet());
        this.intersections.add(new IntersectGroupSetWithGroupSet());
        this.intersections.add(new IntersectGroupSetWithModuleId());
        this.intersections.add(new IntersectGroupSetWithModuleIdSet());
        this.intersections.add(new IntersectModuleWithModule());
        this.intersections.add(new IntersectModuleWithModuleId());
        this.intersections.add(new IntersectModuleWithModuleSet());
        this.intersections.add(new IntersectModuleWithModuleIdSet());
        this.intersections.add(new IntersectModuleWithGroupSet());
        this.intersections.add(new IntersectModuleIdWithModuleId());
        this.intersections.add(new IntersectModuleIdWithModuleIdSet());
        this.intersections.add(new IntersectModuleIdWithModuleSet());
        this.intersections.add(new IntersectModuleIdSetWithModuleIdSet());
        this.intersections.add(new IntersectModuleIdSetWithModuleSet());
        this.intersections.add(new IntersectModuleSetWithModuleSet());
        this.intersections.add(new IntersectModuleSetWithGroupSet());
    }

    @Nullable ExcludeSpec tryIntersect(ExcludeSpec left, ExcludeSpec right) {
        if (left.equals(right)) {
            return left;
        }
        return this.intersections.stream().filter(i -> i.applies(left, right)).findFirst().map(i -> i.intersect(left, right, this.factory)).orElse(null);
    }

    private final class IntersectAnyWithAny
    extends AbstractIntersection<ExcludeAnyOf, ExcludeAnyOf> {
        public IntersectAnyWithAny() {
            super(ExcludeAnyOf.class, ExcludeAnyOf.class);
        }

        @Override
        public ExcludeSpec doIntersect(ExcludeAnyOf left, ExcludeAnyOf right, ExcludeFactory factory) {
            PersistentSet<ExcludeSpec> rightComponents;
            PersistentSet<ExcludeSpec> leftComponents = left.getComponents();
            PersistentSet common = leftComponents.intersect(rightComponents = right.getComponents());
            if (!common.isEmpty()) {
                ExcludeSpec alpha = factory.fromUnion((PersistentSet<ExcludeSpec>)common);
                if (leftComponents.equals((Object)common) || rightComponents.equals((Object)common)) {
                    return alpha;
                }
                PersistentSet remainderLeft = leftComponents.except(common);
                PersistentSet remainderRight = rightComponents.except(common);
                ExcludeSpec unionLeft = factory.fromUnion((PersistentSet<ExcludeSpec>)remainderLeft);
                ExcludeSpec unionRight = factory.fromUnion((PersistentSet<ExcludeSpec>)remainderRight);
                ExcludeSpec beta = factory.allOf(unionLeft, unionRight);
                return factory.anyOf(alpha, beta);
            }
            PersistentSet intersections = PersistentSet.of();
            for (ExcludeSpec leftSpec : leftComponents) {
                for (ExcludeSpec rightSpec : rightComponents) {
                    ExcludeSpec merged = Intersections.this.tryIntersect(leftSpec, rightSpec);
                    if (merged == null) {
                        merged = factory.allOf(leftSpec, rightSpec);
                    }
                    if (merged instanceof ExcludeNothing) continue;
                    intersections = intersections.plus((Object)merged);
                }
            }
            return factory.fromUnion((PersistentSet<ExcludeSpec>)intersections);
        }
    }

    private final class IntersectAnyWithBaseSpec
    extends AbstractIntersection<ExcludeAnyOf, ExcludeSpec> {
        private IntersectAnyWithBaseSpec() {
            super(ExcludeAnyOf.class, ExcludeSpec.class);
        }

        @Override
        public @Nullable ExcludeSpec doIntersect(ExcludeAnyOf left, ExcludeSpec right, ExcludeFactory factory) {
            ExcludeSpec[] excludeSpecs = (ExcludeSpec[])left.getComponents().toArray((Object[])new ExcludeSpec[0]);
            ExcludeSpec[] intersections = null;
            for (int i = 0; i < excludeSpecs.length; ++i) {
                ExcludeSpec excludeSpec = Intersections.this.tryIntersect(excludeSpecs[i], right);
                if (excludeSpec == null) continue;
                if (intersections == null) {
                    intersections = new ExcludeSpec[excludeSpecs.length];
                }
                intersections[i] = excludeSpec;
            }
            if (intersections != null) {
                PersistentSet simplified = PersistentSet.of();
                for (int i = 0; i < intersections.length; ++i) {
                    void intersection = intersections[i];
                    if (intersection instanceof ExcludeNothing) continue;
                    simplified = intersection != null ? simplified.plus((Object)intersection) : simplified.plus((Object)factory.allOf(excludeSpecs[i], right));
                }
                return factory.fromUnion((PersistentSet<ExcludeSpec>)simplified);
            }
            return null;
        }

        @Override
        public boolean applies(ExcludeSpec left, ExcludeSpec right) {
            return left instanceof ExcludeAnyOf && !(right instanceof ExcludeAnyOf) || right instanceof ExcludeAnyOf && !(left instanceof ExcludeAnyOf);
        }
    }

    private static final class IntersectGroupWithGroup
    extends AbstractIntersection<GroupExclude, GroupExclude> {
        private IntersectGroupWithGroup() {
            super(GroupExclude.class, GroupExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupExclude left, GroupExclude right, ExcludeFactory factory) {
            return factory.nothing();
        }
    }

    private static final class IntersectGroupWithModuleId
    extends AbstractIntersection<GroupExclude, ModuleIdExclude> {
        private IntersectGroupWithModuleId() {
            super(GroupExclude.class, ModuleIdExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupExclude left, ModuleIdExclude right, ExcludeFactory factory) {
            String group = left.getGroup();
            if (right.getModuleId().getGroup().equals(group)) {
                return right;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectGroupWithGroupSet
    extends AbstractIntersection<GroupExclude, GroupSetExclude> {
        private IntersectGroupWithGroupSet() {
            super(GroupExclude.class, GroupSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupExclude left, GroupSetExclude right, ExcludeFactory factory) {
            String group = left.getGroup();
            if (right.getGroups().anyMatch(g -> g.equals(group))) {
                return left;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectGroupWithModuleIdSet
    extends AbstractIntersection<GroupExclude, ModuleIdSetExclude> {
        private IntersectGroupWithModuleIdSet() {
            super(GroupExclude.class, ModuleIdSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupExclude left, ModuleIdSetExclude right, ExcludeFactory factory) {
            String group = left.getGroup();
            PersistentSet moduleIds = right.getModuleIds().filter(id -> id.getGroup().equals(group));
            return factory.fromModuleIds((PersistentSet<ModuleIdentifier>)moduleIds);
        }
    }

    private static final class IntersectGroupWithModule
    extends AbstractIntersection<GroupExclude, ModuleExclude> {
        private IntersectGroupWithModule() {
            super(GroupExclude.class, ModuleExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupExclude left, ModuleExclude right, ExcludeFactory factory) {
            return factory.moduleId(DefaultModuleIdentifier.newId(left.getGroup(), right.getModule()));
        }
    }

    private static final class IntersectGroupWithModuleSet
    extends AbstractIntersection<GroupExclude, ModuleSetExclude> {
        private IntersectGroupWithModuleSet() {
            super(GroupExclude.class, ModuleSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupExclude left, ModuleSetExclude right, ExcludeFactory factory) {
            return factory.moduleIdSet((PersistentSet<ModuleIdentifier>)right.getModules().map(module -> DefaultModuleIdentifier.newId(left.getGroup(), module)));
        }
    }

    private static final class IntersectGroupSetWithGroupSet
    extends AbstractIntersection<GroupSetExclude, GroupSetExclude> {
        private IntersectGroupSetWithGroupSet() {
            super(GroupSetExclude.class, GroupSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupSetExclude left, GroupSetExclude right, ExcludeFactory factory) {
            PersistentSet<String> groups = left.getGroups();
            PersistentSet common = right.getGroups().intersect(groups);
            return factory.fromGroups((PersistentSet<String>)common);
        }
    }

    private static final class IntersectGroupSetWithModuleId
    extends AbstractIntersection<GroupSetExclude, ModuleIdExclude> {
        private IntersectGroupSetWithModuleId() {
            super(GroupSetExclude.class, ModuleIdExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupSetExclude left, ModuleIdExclude right, ExcludeFactory factory) {
            PersistentSet<String> groups = left.getGroups();
            if (groups.contains((Object)right.getModuleId().getGroup())) {
                return right;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectGroupSetWithModuleIdSet
    extends AbstractIntersection<GroupSetExclude, ModuleIdSetExclude> {
        private IntersectGroupSetWithModuleIdSet() {
            super(GroupSetExclude.class, ModuleIdSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(GroupSetExclude left, ModuleIdSetExclude right, ExcludeFactory factory) {
            PersistentSet<String> groups = left.getGroups();
            PersistentSet filtered = right.getModuleIds().filter(id -> groups.contains((Object)id.getGroup()));
            return factory.fromModuleIds((PersistentSet<ModuleIdentifier>)filtered);
        }
    }

    private static final class IntersectModuleWithModule
    extends AbstractIntersection<ModuleExclude, ModuleExclude> {
        private IntersectModuleWithModule() {
            super(ModuleExclude.class, ModuleExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleExclude left, ModuleExclude right, ExcludeFactory factory) {
            String module = left.getModule();
            if (right.getModule().equals(module)) {
                return left;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectModuleWithModuleId
    extends AbstractIntersection<ModuleExclude, ModuleIdExclude> {
        private IntersectModuleWithModuleId() {
            super(ModuleExclude.class, ModuleIdExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleExclude left, ModuleIdExclude right, ExcludeFactory factory) {
            String module = left.getModule();
            if (right.getModuleId().getName().equals(module)) {
                return right;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectModuleWithModuleSet
    extends AbstractIntersection<ModuleExclude, ModuleSetExclude> {
        private IntersectModuleWithModuleSet() {
            super(ModuleExclude.class, ModuleSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleExclude left, ModuleSetExclude right, ExcludeFactory factory) {
            String module = left.getModule();
            if (right.getModules().anyMatch(g -> g.equals(module))) {
                return left;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectModuleWithModuleIdSet
    extends AbstractIntersection<ModuleExclude, ModuleIdSetExclude> {
        private IntersectModuleWithModuleIdSet() {
            super(ModuleExclude.class, ModuleIdSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleExclude left, ModuleIdSetExclude right, ExcludeFactory factory) {
            String module = left.getModule();
            PersistentSet common = right.getModuleIds().filter(id -> id.getName().equals(module));
            return factory.fromModuleIds((PersistentSet<ModuleIdentifier>)common);
        }
    }

    private static final class IntersectModuleWithGroupSet
    extends AbstractIntersection<ModuleExclude, GroupSetExclude> {
        private IntersectModuleWithGroupSet() {
            super(ModuleExclude.class, GroupSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleExclude left, GroupSetExclude right, ExcludeFactory factory) {
            return factory.moduleIdSet((PersistentSet<ModuleIdentifier>)right.getGroups().map(group -> DefaultModuleIdentifier.newId(group, left.getModule())));
        }
    }

    private static final class IntersectModuleIdWithModuleId
    extends AbstractIntersection<ModuleIdExclude, ModuleIdExclude> {
        private IntersectModuleIdWithModuleId() {
            super(ModuleIdExclude.class, ModuleIdExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleIdExclude left, ModuleIdExclude right, ExcludeFactory factory) {
            if (left.equals(right)) {
                return left;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectModuleIdWithModuleIdSet
    extends AbstractIntersection<ModuleIdExclude, ModuleIdSetExclude> {
        private IntersectModuleIdWithModuleIdSet() {
            super(ModuleIdExclude.class, ModuleIdSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleIdExclude left, ModuleIdSetExclude right, ExcludeFactory factory) {
            PersistentSet<ModuleIdentifier> rightModuleIds = right.getModuleIds();
            if (rightModuleIds.contains((Object)left.getModuleId())) {
                return left;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectModuleIdWithModuleSet
    extends AbstractIntersection<ModuleIdExclude, ModuleSetExclude> {
        private IntersectModuleIdWithModuleSet() {
            super(ModuleIdExclude.class, ModuleSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleIdExclude left, ModuleSetExclude right, ExcludeFactory factory) {
            if (right.getModules().contains((Object)left.getModuleId().getName())) {
                return left;
            }
            return factory.nothing();
        }
    }

    private static final class IntersectModuleIdSetWithModuleIdSet
    extends AbstractIntersection<ModuleIdSetExclude, ModuleIdSetExclude> {
        private IntersectModuleIdSetWithModuleIdSet() {
            super(ModuleIdSetExclude.class, ModuleIdSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleIdSetExclude left, ModuleIdSetExclude right, ExcludeFactory factory) {
            PersistentSet<ModuleIdentifier> moduleIds = left.getModuleIds();
            PersistentSet common = right.getModuleIds().intersect(moduleIds);
            return factory.fromModuleIds((PersistentSet<ModuleIdentifier>)common);
        }
    }

    private static final class IntersectModuleIdSetWithModuleSet
    extends AbstractIntersection<ModuleIdSetExclude, ModuleSetExclude> {
        private IntersectModuleIdSetWithModuleSet() {
            super(ModuleIdSetExclude.class, ModuleSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleIdSetExclude left, ModuleSetExclude right, ExcludeFactory factory) {
            PersistentSet<String> modules;
            PersistentSet<ModuleIdentifier> moduleIds = left.getModuleIds();
            PersistentSet identifiers = moduleIds.filter(arg_0 -> IntersectModuleIdSetWithModuleSet.lambda$doIntersect$0(modules = right.getModules(), arg_0));
            if (identifiers.isEmpty()) {
                return factory.nothing();
            }
            if (identifiers.size() == 1) {
                return factory.moduleId((ModuleIdentifier)identifiers.iterator().next());
            }
            return factory.moduleIdSet((PersistentSet<ModuleIdentifier>)identifiers);
        }

        private static /* synthetic */ boolean lambda$doIntersect$0(PersistentSet modules, ModuleIdentifier e) {
            return modules.contains((Object)e.getName());
        }
    }

    private static final class IntersectModuleSetWithModuleSet
    extends AbstractIntersection<ModuleSetExclude, ModuleSetExclude> {
        private IntersectModuleSetWithModuleSet() {
            super(ModuleSetExclude.class, ModuleSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleSetExclude left, ModuleSetExclude right, ExcludeFactory factory) {
            PersistentSet modules = left.getModules().intersect(right.getModules());
            if (modules.isEmpty()) {
                return factory.nothing();
            }
            if (modules.size() == 1) {
                return factory.module((String)modules.iterator().next());
            }
            return factory.moduleSet((PersistentSet<String>)modules);
        }
    }

    private static final class IntersectModuleSetWithGroupSet
    extends AbstractIntersection<ModuleSetExclude, GroupSetExclude> {
        private IntersectModuleSetWithGroupSet() {
            super(ModuleSetExclude.class, GroupSetExclude.class);
        }

        @Override
        public ExcludeSpec doIntersect(ModuleSetExclude left, GroupSetExclude right, ExcludeFactory factory) {
            return factory.moduleIdSet((PersistentSet<ModuleIdentifier>)right.getGroups().flatMap(group -> left.getModules().map(module -> DefaultModuleIdentifier.newId(group, module))));
        }
    }
}

