/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.internal.component.resolution.failure.SelectionReasonAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.ConflictingConstraintsException;
import org.gradle.internal.component.resolution.failure.type.ModuleRejectedFailure;
import org.gradle.util.internal.VersionNumber;

public abstract class ModuleRejectedIncompatibleConstraintsFailureDescriber
extends AbstractResolutionFailureDescriber<ModuleRejectedFailure> {
    private static final String DEPENDENCY_INSIGHT_TASK_NAME = "dependencyInsight";
    private static final String DEBUGGING_WITH_DEPENDENCY_INSIGHT_PREFIX = "Debugging using the dependencyInsight report is described in more detail at: ";
    private static final String DEBUGGING_WITH_DEPENDENCY_INSIGHT_ID = "viewing_debugging_dependencies";
    private static final String DEBUGGING_WITH_DEPENDENCY_INSIGHT_SECTION = "sec:identifying-reason-dependency-selection";

    @Override
    public boolean canDescribeFailure(ModuleRejectedFailure failure) {
        List<SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason> versionsByReason = ModuleRejectedIncompatibleConstraintsFailureDescriber.findConflictingConstraints(failure);
        int uniqueVersions = versionsByReason.stream().map(SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason::getRequestedVersion).collect(Collectors.toSet()).size();
        return uniqueVersions > 1;
    }

    private static List<SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason> findConflictingConstraints(ModuleRejectedFailure failure) {
        return failure.getAssessedSelection().getReasons().stream().filter(reason -> reason.getCauses().contains(ComponentSelectionCause.CONSTRAINT) && reason.getRequestedVersion() != null).collect(Collectors.toList());
    }

    public ConflictingConstraintsException describeFailure(ModuleRejectedFailure failure) {
        return new ConflictingConstraintsException(ModuleRejectedIncompatibleConstraintsFailureDescriber.summarizeFailure(failure), failure, this.buildResolutions(failure));
    }

    private List<String> buildResolutions(ModuleRejectedFailure failure) {
        ArrayList<String> resolutions = new ArrayList<String>(failure.getResolutions().size() + 1);
        resolutions.addAll(failure.getResolutions());
        resolutions.add(DEBUGGING_WITH_DEPENDENCY_INSIGHT_PREFIX + this.getDocumentationRegistry().getDocumentationFor(DEBUGGING_WITH_DEPENDENCY_INSIGHT_ID, DEBUGGING_WITH_DEPENDENCY_INSIGHT_SECTION) + ".");
        return resolutions;
    }

    private static String summarizeFailure(ModuleRejectedFailure failure) {
        HashMultimap conflictingVersionsWithExplanations = HashMultimap.create();
        ModuleRejectedIncompatibleConstraintsFailureDescriber.findConflictingConstraints(failure).forEach(arg_0 -> ModuleRejectedIncompatibleConstraintsFailureDescriber.lambda$summarizeFailure$1((Multimap)conflictingVersionsWithExplanations, arg_0));
        StringBuilder sb = new StringBuilder("Component is the target of multiple version constraints with conflicting requirements:\n");
        conflictingVersionsWithExplanations.keySet().stream().sorted().forEach(arg_0 -> ModuleRejectedIncompatibleConstraintsFailureDescriber.lambda$summarizeFailure$2((Multimap)conflictingVersionsWithExplanations, sb, arg_0));
        return sb.toString();
    }

    private static Collection<String> explainReason(SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason reason) {
        String requestedVersion = reason.getRequestedVersion();
        assert (requestedVersion != null);
        if (reason.isFromLock()) {
            return Collections.singleton(requestedVersion + " - from lock file");
        }
        ImmutableList<ImmutableList<String>> paths = reason.getSegmentedSelectionPaths();
        ImmutableSet.Builder result = ImmutableSet.builderWithExpectedSize((int)paths.size());
        for (List path : paths) {
            int pathLength = path.size();
            if (pathLength == 1) {
                result.add((Object)requestedVersion);
                continue;
            }
            if (pathLength == 2) {
                result.add((Object)(requestedVersion + " - directly in " + (String)path.get(1)));
                continue;
            }
            if (pathLength <= 2) continue;
            result.add((Object)(requestedVersion + " - transitively via " + (String)path.get(1)));
        }
        return result.build();
    }

    private static /* synthetic */ void lambda$summarizeFailure$2(Multimap conflictingVersionsWithExplanations, StringBuilder sb, VersionNumber version) {
        List explanations = conflictingVersionsWithExplanations.get((Object)version).stream().sorted().collect(Collectors.toList());
        sb.append((String)explanations.get(0));
        int numOtherPaths = explanations.size() - 1;
        if (numOtherPaths > 0) {
            sb.append(" (").append(numOtherPaths).append(" other path");
            if (numOtherPaths > 1) {
                sb.append("s");
            }
            sb.append(" to this version)");
        }
        sb.append("\n");
    }

    private static /* synthetic */ void lambda$summarizeFailure$1(Multimap conflictingVersionsWithExplanations, SelectionReasonAssessor.AssessedSelection.AssessedSelectionReason v) {
        VersionNumber version = VersionNumber.parse((String)v.getRequestedVersion());
        Collection<String> explanations = ModuleRejectedIncompatibleConstraintsFailureDescriber.explainReason(v);
        conflictingVersionsWithExplanations.putAll((Object)version, explanations);
    }
}

