plugins {
    id("gradlebuild.distribution.api-java")
}

description = "Gradle plugin development plugins"

dependencies {
    api(projects.baseServices)
    api(projects.core)
    api(projects.coreApi)
    api(projects.daemonServerWorker)
    api(projects.files)
    api(projects.logging)
    api(projects.modelReflect)
    api(projects.platformJvm)
    api(projects.problemsApi)
    api(projects.resources)
    api(projects.stdlibJavaExtensions)
    api(projects.toolchainsJvmShared)
    api(projects.workers)

    api(libs.groovy)
    api(libs.gson)
    api(libs.jspecify)
    api(libs.inject)

    implementation(projects.buildProcessServices)
    implementation(projects.classloaders)
    implementation(projects.serviceLookup)
    implementation(projects.serviceProvider)
    implementation(projects.serviceRegistryBuilder)
    implementation(projects.buildOption)
    implementation(projects.dependencyManagement)
    implementation(projects.execution)
    implementation(projects.fileOperations)
    implementation(projects.hashing)
    implementation(projects.ivy)
    implementation(projects.jvmServices)
    implementation(projects.languageJava)
    implementation(projects.languageJvm)
    implementation(projects.loggingApi)
    implementation(projects.maven)
    implementation(projects.messaging)
    implementation(projects.modelCore)
    implementation(projects.modelGroovy)
    implementation(projects.pluginsGroovy)
    implementation(projects.pluginsJava)
    implementation(projects.pluginsJavaBase)
    implementation(projects.pluginsJavaLibrary)
    implementation(projects.pluginsJvmTestSuite)
    implementation(projects.pluginUse)
    implementation(projects.publish)
    implementation(projects.testingJvm)
    implementation(projects.toolchainsJvm)

    implementation(libs.asm)
    implementation(libs.guava)

    testImplementation(projects.fileCollections)
    testImplementation(projects.enterpriseOperations)

    testImplementation(testFixtures(projects.core))
    testImplementation(testFixtures(projects.logging))

    integTestImplementation(projects.baseServicesGroovy)

    integTestImplementation(testFixtures(projects.modelReflect))
    integTestImplementation(testFixtures(projects.toolingApi))

    integTestImplementation(libs.groovyTest)
    integTestImplementation(libs.jetbrainsAnnotations)

    integTestLocalRepository(projects.toolingApi) {
        because("Required by GradleImplDepsCompatibilityIntegrationTest")
    }

    testRuntimeOnly(projects.distributionsJvm) {
        because("ProjectBuilder tests load services from a Gradle distribution.")
    }
    integTestDistributionRuntimeOnly(projects.distributionsJvm)
    crossVersionTestDistributionRuntimeOnly(projects.distributionsJvm)

    testFixturesImplementation(projects.modelCore)
    testFixturesImplementation(projects.logging)
    testFixturesImplementation(libs.gson)
    testFixturesImplementation(projects.baseServices)
}

strictCompile {
    ignoreDeprecations()
}
tasks.isolatedProjectsIntegTest {
    enabled = false
}
