/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.Nullable;

public class DefaultProblemId
extends ProblemId
implements Serializable {
    private final String name;
    private final String displayName;
    private final ProblemGroup parent;

    public DefaultProblemId(String name, String displayName, ProblemGroup parent) {
        DefaultProblemId.validateFields(name, displayName, parent);
        this.name = TextUtil.replaceLineSeparatorsOf((String)name, (String)"");
        this.displayName = TextUtil.replaceLineSeparatorsOf((String)displayName, (String)"");
        this.parent = parent;
    }

    private static void validateFields(String name, String displayName, ProblemGroup parent) {
        if (TextUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("Problem id name must not be blank");
        }
        if (TextUtil.isBlank((String)displayName)) {
            throw new IllegalArgumentException("Problem id displayName must not be blank");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Problem id parent must not be null");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ProblemGroup getGroup() {
        return this.parent;
    }

    public String toString() {
        return DefaultProblemId.groupPath(this.getGroup()) + this.getName();
    }

    static String groupPath(@Nullable ProblemGroup group) {
        if (group == null) {
            return "";
        }
        ProblemGroup parent = group.getParent();
        return DefaultProblemId.groupPath(parent) + group.getName() + ":";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass().isAssignableFrom(ProblemId.class)) {
            return false;
        }
        ProblemId that = (ProblemId)o;
        if (!this.name.equals(that.getName())) {
            return false;
        }
        return this.parent.equals(that.getGroup());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.parent});
    }
}

