/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint;

import java.util.function.Predicate;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public enum DirectorySensitivity {
    DEFAULT(snapshot -> true),
    IGNORE_DIRECTORIES(snapshot -> snapshot.getType() != FileType.Directory);

    private final Predicate<FileSystemLocationSnapshot> fingerprintCheck;

    private DirectorySensitivity(Predicate<FileSystemLocationSnapshot> fingerprintCheck) {
        this.fingerprintCheck = fingerprintCheck;
    }

    public boolean shouldFingerprint(FileSystemLocationSnapshot snapshot) {
        return this.fingerprintCheck.test(snapshot);
    }
}

