/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.util.internal.TextUtil;

public abstract class JvmGradlePluginProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;
    private final TemplateLibraryVersionProvider libraryVersionProvider;

    public JvmGradlePluginProjectInitDescriptor(DocumentationRegistry documentationRegistry, TemplateLibraryVersionProvider libraryVersionProvider) {
        this.documentationRegistry = documentationRegistry;
        this.libraryVersionProvider = libraryVersionProvider;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.GRADLE_PLUGIN;
    }

    @Override
    public boolean supportsPackage() {
        return true;
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        BuildScriptBuilder.Expression functionalTestSourceSet;
        buildScriptBuilder.repositories().mavenCentral("Use Maven Central for resolving dependencies.");
        String pluginId = settings.getPackageName() + ".greeting";
        String pluginClassName = StringUtils.capitalize((String)TextUtil.toCamelCase((CharSequence)settings.getProjectName())) + "Plugin";
        buildScriptBuilder.fileComment("This generated file contains a sample Gradle plugin project to get you started.").fileComment(this.documentationRegistry.getDocumentationRecommendationFor("details on writing Custom Plugins", "custom_plugins"));
        buildScriptBuilder.plugin("Apply the Java Gradle plugin development plugin to add support for developing Gradle plugins", "java-gradle-plugin");
        buildScriptBuilder.block(null, "gradlePlugin", (Action<? super ScriptBlockBuilder>)((Action)b -> b.containerElement("Define the plugin", "plugins", "greeting", null, (Action<? super ScriptBlockBuilder>)((Action)g -> {
            g.propertyAssignment(null, "id", pluginId, true);
            g.propertyAssignment(null, "implementationClass", this.withPackage(settings, pluginClassName), true);
        }))));
        if (settings.isUseTestSuites()) {
            this.configureDefaultTestSuite(buildScriptBuilder, settings.getTestFramework(), this.libraryVersionProvider);
            this.addTestSuite("functionalTest", buildScriptBuilder, settings.getTestFramework(), this.libraryVersionProvider);
            functionalTestSourceSet = buildScriptBuilder.containerElementExpression("sourceSets", "functionalTest");
        } else {
            functionalTestSourceSet = buildScriptBuilder.createContainerElement("Add a source set for the functional test suite", "sourceSets", "functionalTest", "functionalTestSourceSet");
            BuildScriptBuilder.Expression functionalTestImplementation = buildScriptBuilder.containerElementExpression("configurations", "functionalTestImplementation");
            BuildScriptBuilder.Expression testImplementation = buildScriptBuilder.containerElementExpression("configurations", "testImplementation");
            buildScriptBuilder.methodInvocation(null, functionalTestImplementation, "extendsFrom", testImplementation);
            BuildScriptBuilder.Expression functionalTestRuntimeOnly = buildScriptBuilder.containerElementExpression("configurations", "functionalTestRuntimeOnly");
            BuildScriptBuilder.Expression testRuntimeOnly = buildScriptBuilder.containerElementExpression("configurations", "testRuntimeOnly");
            buildScriptBuilder.methodInvocation(null, functionalTestRuntimeOnly, "extendsFrom", testRuntimeOnly);
            BuildScriptBuilder.TaskRegistration functionalTest = buildScriptBuilder.taskRegistration("Add a task to run the functional tests", "functionalTest", "Test", (Action<? super ScriptBlockBuilder>)((Action)b -> {
                b.propertyAssignment(null, "testClassesDirs", buildScriptBuilder.propertyExpression(functionalTestSourceSet, "output.classesDirs"), true);
                b.propertyAssignment(null, "classpath", buildScriptBuilder.propertyExpression(functionalTestSourceSet, "runtimeClasspath"), true);
                b.methodInvocation(null, "useJUnitPlatform", new Object[0]);
            }));
            buildScriptBuilder.taskMethodInvocation("Run the functional tests as part of `check`", "check", "Task", "dependsOn", functionalTest);
            buildScriptBuilder.taskMethodInvocation("Use JUnit Jupiter for unit tests.", "test", "Test", "useJUnitPlatform", new Object[0]);
        }
        buildScriptBuilder.methodInvocation(null, "gradlePlugin.testSourceSets.add", functionalTestSourceSet);
    }

    @Override
    public void generateConventionPluginBuildScript(String conventionPluginName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }

    @Override
    public void generateSources(InitSettings settings, TemplateFactory templateFactory) {
        String pluginId = settings.getPackageName() + ".greeting";
        String pluginClassName = StringUtils.capitalize((String)TextUtil.toCamelCase((CharSequence)settings.getProjectName())) + "Plugin";
        String testClassName = pluginClassName + "Test";
        String functionalTestClassName = pluginClassName + "FunctionalTest";
        TemplateOperation sourceTemplate = this.sourceTemplate(settings, templateFactory, pluginId, pluginClassName);
        TemplateOperation testTemplate = this.testTemplate(settings, templateFactory, pluginId, testClassName);
        TemplateOperation functionalTestTemplate = this.functionalTestTemplate(settings, templateFactory, pluginId, functionalTestClassName);
        templateFactory.whenNoSourcesAvailable(sourceTemplate, testTemplate, functionalTestTemplate).generate();
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return Optional.of(this.documentationRegistry.getDocumentationRecommendationFor("information", "custom_plugins"));
    }

    protected abstract TemplateOperation sourceTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);

    protected abstract TemplateOperation testTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);

    protected abstract TemplateOperation functionalTestTemplate(InitSettings var1, TemplateFactory var2, String var3, String var4);
}

