/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import org.gradle.api.logging.configuration.ConsoleUnicodeSupport;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.jspecify.annotations.NullMarked;

@NullMarked
abstract class UnicodeProxyConsoleMetaData
implements ConsoleMetaData {
    private final ConsoleMetaData metaData;

    public UnicodeProxyConsoleMetaData(ConsoleMetaData metaData) {
        this.metaData = metaData;
    }

    public boolean isStdOutATerminal() {
        return this.metaData.isStdOutATerminal();
    }

    public boolean isStdErrATerminal() {
        return this.metaData.isStdErrATerminal();
    }

    public int getCols() {
        return this.metaData.getCols();
    }

    public int getRows() {
        return this.metaData.getRows();
    }

    public boolean isWrapStreams() {
        return this.metaData.isWrapStreams();
    }

    public static ConsoleMetaData create(ConsoleMetaData metaData, ConsoleUnicodeSupport consoleUnicodeSupport) {
        switch (consoleUnicodeSupport) {
            case Auto: {
                return metaData;
            }
            case Disable: {
                return new FixedUnicodeSupport(metaData, false);
            }
        }
        return new FixedUnicodeSupport(metaData, true);
    }

    public boolean supportsTaskbarProgress() {
        return this.metaData.supportsTaskbarProgress();
    }

    private static final class FixedUnicodeSupport
    extends UnicodeProxyConsoleMetaData {
        private final boolean supportsUnicode;

        FixedUnicodeSupport(ConsoleMetaData metaData, boolean supportsUnicode) {
            super(metaData);
            this.supportsUnicode = supportsUnicode;
        }

        public boolean supportsUnicode() {
            return this.supportsUnicode;
        }
    }
}

