/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import org.gradle.api.internal.classpath.RuntimeApiInfo;
import org.gradle.api.internal.runtimeshaded.ImplementationDependencyRelocator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarCreator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.cache.internal.GeneratedGradleJarCache;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceScope(value={Scope.Build.class})
public class RuntimeShadedJarFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeShadedJarFactory.class);
    private final GeneratedGradleJarCache cache;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final BuildOperationRunner buildOperationRunner;
    private final RuntimeApiInfo runtimeApiInfo;

    public RuntimeShadedJarFactory(GeneratedGradleJarCache cache, ProgressLoggerFactory progressLoggerFactory, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, BuildOperationRunner buildOperationRunner, RuntimeApiInfo runtimeApiInfo) {
        this.cache = cache;
        this.progressLoggerFactory = progressLoggerFactory;
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.buildOperationRunner = buildOperationRunner;
        this.runtimeApiInfo = runtimeApiInfo;
    }

    public File get(final RuntimeShadedJarType type, Collection<? extends File> classpath) {
        File jarFile = this.cache.get(type.getIdentifier(), file -> this.buildOperationRunner.run(new RunnableBuildOperation(){
            final /* synthetic */ File val$file;
            final /* synthetic */ Collection val$classpath;
            {
                this.val$file = file;
                this.val$classpath = collection;
            }

            public void run(BuildOperationContext context) {
                URL resource = RuntimeShadedJarFactory.this.getPackageListUrl(type);
                RuntimeShadedJarCreator creator = new RuntimeShadedJarCreator(RuntimeShadedJarFactory.this.progressLoggerFactory, new ImplementationDependencyRelocator(resource), RuntimeShadedJarFactory.this.classpathWalker, RuntimeShadedJarFactory.this.classpathBuilder);
                creator.create(type, this.val$file, this.val$classpath);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Generate " + type.getDisplayName())).progressDisplayName("Generating " + type.getDisplayName());
            }
        }));
        LOGGER.debug("Using Gradle runtime shaded JAR file: {}", (Object)jarFile);
        return jarFile;
    }

    private URL getPackageListUrl(RuntimeShadedJarType type) {
        switch (type) {
            case API: {
                return this.runtimeApiInfo.getRelocatedApiPackagesResource();
            }
            case TEST_KIT: {
                return RuntimeShadedJarFactory.class.getResource(type.getIdentifier() + "-relocated.txt");
            }
        }
        throw new IllegalArgumentException("Unsupported runtime shaded jar type: " + (Object)((Object)type));
    }
}

