/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Map;
import org.gradle.api.internal.tasks.testing.operations.ExecuteTestBuildOperationType;
import org.gradle.api.tasks.testing.TestFileAttachmentDataEvent;
import org.gradle.api.tasks.testing.TestKeyValueDataEvent;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.internal.Cast;
import org.gradle.internal.build.event.types.DefaultTestFileAttachmentMetadataEvent;
import org.gradle.internal.build.event.types.DefaultTestKeyValueDataMetadataEvent;
import org.gradle.internal.build.event.types.DefaultTestMetadataDescriptor;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestMetadataDescriptor;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;
import org.jspecify.annotations.NullMarked;

@NullMarked
class ClientForwardingTestMetadataOperationListener
implements BuildOperationListener {
    private final ProgressEventConsumer eventConsumer;
    private final BuildOperationIdFactory idFactory;

    ClientForwardingTestMetadataOperationListener(ProgressEventConsumer eventConsumer, BuildOperationIdFactory idFactory) {
        this.eventConsumer = eventConsumer;
        this.idFactory = idFactory;
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
    }

    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
        Object details = progressEvent.getDetails();
        if (details instanceof ExecuteTestBuildOperationType.Metadata) {
            ExecuteTestBuildOperationType.Metadata dataEvent = (ExecuteTestBuildOperationType.Metadata)details;
            DefaultTestMetadataDescriptor descriptor = new DefaultTestMetadataDescriptor(new OperationIdentifier(this.idFactory.nextId()), buildOperationId);
            TestMetadataEvent data = dataEvent.getMetadata();
            if (data instanceof TestKeyValueDataEvent) {
                TestKeyValueDataEvent keyValueData = (TestKeyValueDataEvent)data;
                this.eventConsumer.progress((InternalProgressEvent)new DefaultTestKeyValueDataMetadataEvent(progressEvent.getTime(), (InternalTestMetadataDescriptor)descriptor, (Map)Cast.uncheckedNonnullCast((Object)keyValueData.getValues())));
            } else if (data instanceof TestFileAttachmentDataEvent) {
                TestFileAttachmentDataEvent fileAttachment = (TestFileAttachmentDataEvent)data;
                this.eventConsumer.progress((InternalProgressEvent)new DefaultTestFileAttachmentMetadataEvent(progressEvent.getTime(), (InternalTestMetadataDescriptor)descriptor, fileAttachment.getPath().toFile(), fileAttachment.getMediaType()));
            } else {
                throw new IllegalStateException("Unexpected test metadata event type: " + data.getClass());
            }
        }
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
    }
}

