/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.BuildGenerator;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.VersionCatalogDependencyRegistry;
import org.gradle.buildinit.plugins.internal.VersionCatalogGenerator;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;

public abstract class AbstractBuildGenerator
implements BuildGenerator {
    private final BuildContentGenerator generator;
    private final List<? extends BuildContentGenerator> generators;

    public AbstractBuildGenerator(BuildContentGenerator projectGenerator, List<? extends BuildContentGenerator> generators) {
        this.generators = generators;
        this.generator = projectGenerator;
    }

    @Override
    public boolean supportsProjectName() {
        return true;
    }

    @Override
    public Set<BuildInitDsl> getDsls() {
        return new TreeSet<BuildInitDsl>(Arrays.asList(BuildInitDsl.values()));
    }

    @Override
    public void generate(InitSettings settings) {
        BuildContentGenerationContext buildContentGenerationContext = new BuildContentGenerationContext(new VersionCatalogDependencyRegistry(false));
        for (BuildContentGenerator buildContentGenerator : this.generators) {
            buildContentGenerator.generate(settings, buildContentGenerationContext);
        }
        this.generator.generate(settings, buildContentGenerationContext);
        VersionCatalogGenerator.create(settings.getTarget()).generate(buildContentGenerationContext, settings.isWithComments());
    }
}

