/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.kryo;

import com.esotericsoftware.kryo.io.Output;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.serialize.AbstractEncoder;
import org.gradle.internal.serialize.FlushableEncoder;
import org.gradle.internal.serialize.PositionAwareEncoder;
import org.jspecify.annotations.Nullable;

public class StringDeduplicatingKryoBackedEncoder
extends AbstractEncoder
implements PositionAwareEncoder,
FlushableEncoder,
Closeable {
    static final int NULL_STRING = 0;
    static final int NEW_STRING = 1;
    private Object2IntMap<String> strings;
    private final Output output;

    public StringDeduplicatingKryoBackedEncoder(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    public StringDeduplicatingKryoBackedEncoder(OutputStream outputStream, int bufferSize) {
        this.output = new Output(outputStream, bufferSize);
    }

    @Override
    public void writeByte(byte value) {
        this.output.writeByte(value);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int count) {
        this.output.writeBytes(bytes, offset, count);
    }

    @Override
    public void writeLong(long value) {
        this.output.writeLong(value);
    }

    @Override
    public void writeSmallLong(long value) {
        this.output.writeLong(value, true);
    }

    @Override
    public void writeInt(int value) {
        this.output.writeInt(value);
    }

    @Override
    public void writeSmallInt(int value) {
        this.output.writeInt(value, true);
    }

    @Override
    public void writeShort(short value) throws IOException {
        this.output.writeShort((int)value);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.output.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.output.writeDouble(value);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.output.writeBoolean(value);
    }

    @Override
    public void writeNullableString(@Nullable CharSequence value) {
        if (value == null) {
            this.writeStringIndex(0);
            return;
        }
        this.writeNonnullString(value);
    }

    @Override
    public void writeString(CharSequence value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot encode a null string.");
        }
        this.writeNonnullString(value);
    }

    private void writeNonnullString(CharSequence value) {
        String key = value.toString();
        if (this.strings == null) {
            this.strings = new Object2IntOpenHashMap(1024);
            this.writeNewString(key);
        } else {
            int index = this.strings.getOrDefault((Object)key, -1);
            if (index == -1) {
                this.writeNewString(key);
            } else {
                this.writeStringIndex(index);
            }
        }
    }

    private void writeNewString(String key) {
        int newIndex = this.strings.size() + 2;
        this.strings.put((Object)key, newIndex);
        this.writeStringIndex(1);
        this.output.writeString(key);
    }

    private void writeStringIndex(int index) {
        this.output.writeVarInt(index, true);
    }

    @Override
    public long getWritePosition() {
        return this.output.total();
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.output.close();
    }

    public void done() {
        this.strings = null;
    }
}

