/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.fir.modifier;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.lightTree.fir.modifier.ModifierFlag;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\u0006\u0010\u001a\u001a\u00020\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u0016J\u0006\u0010\u001d\u001a\u00020\u0016J\u0006\u0010\u001e\u001a\u00020\u0016J\u0006\u0010\u001f\u001a\u00020\u0016J\u0006\u0010 \u001a\u00020\u0016J\u0010\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0016J\u0006\u0010$\u001a\u00020\u0016J\u0006\u0010%\u001a\u00020\u0016J\u0006\u0010&\u001a\u00020\u0016J\u0006\u0010'\u001a\u00020\u0016J\u0006\u0010(\u001a\u00020\u0016J\u0006\u0010)\u001a\u00020\u0016J\u0006\u0010*\u001a\u00020\u0016J\u000e\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010/\u001a\u00020\u0016J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020\u0016J\u0006\u00103\u001a\u00020\u0016J\u0006\u00104\u001a\u00020\u0016J\u0006\u00105\u001a\u00020\u0016J\u0006\u00106\u001a\u00020\u0016J\u0006\u00107\u001a\u00020\u0016J\u0010\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020:H\u0004J\u0012\u0010;\u001a\u00020\u00132\b\u00109\u001a\u0004\u0018\u00010:H\u0004J\n\u0010<\u001a\u00020=H\u0096\u0080\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/ModifierList;", "", "modifiers", "", "<init>", "(J)V", "getModifiers", "()J", "setModifiers", "annotations", "", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "getAnnotations", "()Ljava/util/List;", "contextLists", "getContextLists", "setContextLists", "(Ljava/util/List;)V", "addModifier", "", "modifier", "isInClass", "", "isEnum", "isAnnotation", "isDataClass", "isInlineClass", "isValueClass", "isInner", "isCompanion", "isFunctionalInterface", "hasOverride", "hasLateinit", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "publicByDefault", "hasTailrec", "hasOperator", "hasInfix", "hasInline", "hasExternal", "hasSuspend", "isConst", "hasModality", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "getModality", "isClassOrObject", "getVariance", "Lorg/jetbrains/kotlin/types/Variance;", "hasVararg", "hasNoinline", "hasCrossinline", "hasExpect", "hasActual", "hasConst", "hasFlag", "flag", "Lorg/jetbrains/kotlin/fir/lightTree/fir/modifier/ModifierFlag;", "setFlag", "toString", "", "light-tree2fir"})
public class ModifierList {
    private long modifiers;
    @NotNull
    private final List<LighterASTNode> annotations;
    @NotNull
    private List<LighterASTNode> contextLists;

    public ModifierList(long modifiers) {
        this.modifiers = modifiers;
        this.annotations = new ArrayList();
        this.contextLists = new ArrayList();
    }

    public /* synthetic */ ModifierList(long l2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            l2 = ModifierFlag.NONE.getValue();
        }
        this(l2);
    }

    public final long getModifiers() {
        return this.modifiers;
    }

    public final void setModifiers(long l2) {
        this.modifiers = l2;
    }

    @NotNull
    public final List<LighterASTNode> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final List<LighterASTNode> getContextLists() {
        return this.contextLists;
    }

    public final void setContextLists(@NotNull List<LighterASTNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.contextLists = list;
    }

    public final void addModifier(@NotNull LighterASTNode modifier, boolean isInClass) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        IElementType tokenType = modifier.getTokenType();
        if (Intrinsics.areEqual((Object)tokenType, (Object)KtTokens.CONST_KEYWORD)) {
            this.setFlag(ModifierFlag.PROPERTY_CONST);
            this.setFlag(ModifierFlag.PARAMETER_CONST);
        } else if (Intrinsics.areEqual((Object)tokenType, (Object)KtTokens.INLINE_KEYWORD)) {
            this.setFlag(isInClass ? ModifierFlag.CLASS_INLINE : ModifierFlag.FUNCTION_INLINE);
        } else if (Intrinsics.areEqual((Object)tokenType, (Object)KtTokens.VALUE_KEYWORD)) {
            this.setFlag(ModifierFlag.CLASS_VALUE);
        } else {
            this.setFlag(ModifierFlag.Companion.getElementTypeToModifierFlagMap().get(tokenType));
        }
    }

    public static /* synthetic */ void addModifier$default(ModifierList modifierList2, LighterASTNode lighterASTNode, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addModifier");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        modifierList2.addModifier(lighterASTNode, bl);
    }

    public final boolean isEnum() {
        return this.hasFlag(ModifierFlag.CLASS_ENUM);
    }

    public final boolean isAnnotation() {
        return this.hasFlag(ModifierFlag.CLASS_ANNOTATION);
    }

    public final boolean isDataClass() {
        return this.hasFlag(ModifierFlag.CLASS_DATA);
    }

    public final boolean isInlineClass() {
        return this.hasFlag(ModifierFlag.CLASS_INLINE);
    }

    public final boolean isValueClass() {
        return this.hasFlag(ModifierFlag.CLASS_VALUE);
    }

    public final boolean isInner() {
        return this.hasFlag(ModifierFlag.CLASS_INNER);
    }

    public final boolean isCompanion() {
        return this.hasFlag(ModifierFlag.CLASS_COMPANION);
    }

    public final boolean isFunctionalInterface() {
        return this.hasFlag(ModifierFlag.CLASS_FUN);
    }

    public final boolean hasOverride() {
        return this.hasFlag(ModifierFlag.MEMBER_OVERRIDE);
    }

    public final boolean hasLateinit() {
        return this.hasFlag(ModifierFlag.MEMBER_LATEINIT);
    }

    @NotNull
    public final Visibility getVisibility(boolean publicByDefault) {
        return this.hasFlag(ModifierFlag.VISIBILITY_PRIVATE) ? (Visibility)Visibilities.Private.INSTANCE : (this.hasFlag(ModifierFlag.VISIBILITY_PUBLIC) ? (Visibility)Visibilities.Public.INSTANCE : (this.hasFlag(ModifierFlag.VISIBILITY_PROTECTED) ? (Visibility)Visibilities.Protected.INSTANCE : (this.hasFlag(ModifierFlag.VISIBILITY_INTERNAL) ? (Visibility)Visibilities.Internal.INSTANCE : (publicByDefault ? (Visibility)Visibilities.Public.INSTANCE : (Visibility)Visibilities.Unknown.INSTANCE))));
    }

    public static /* synthetic */ Visibility getVisibility$default(ModifierList modifierList2, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getVisibility");
        }
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return modifierList2.getVisibility(bl);
    }

    public final boolean hasTailrec() {
        return this.hasFlag(ModifierFlag.FUNCTION_TAILREC);
    }

    public final boolean hasOperator() {
        return this.hasFlag(ModifierFlag.FUNCTION_OPERATOR);
    }

    public final boolean hasInfix() {
        return this.hasFlag(ModifierFlag.FUNCTION_INFIX);
    }

    public final boolean hasInline() {
        return this.hasFlag(ModifierFlag.FUNCTION_INLINE);
    }

    public final boolean hasExternal() {
        return this.hasFlag(ModifierFlag.FUNCTION_EXTERNAL);
    }

    public final boolean hasSuspend() {
        return this.hasFlag(ModifierFlag.FUNCTION_SUSPEND);
    }

    public final boolean isConst() {
        return this.hasFlag(ModifierFlag.PROPERTY_CONST);
    }

    public final boolean hasModality(@NotNull Modality modality) {
        Intrinsics.checkNotNullParameter((Object)((Object)modality), (String)"modality");
        return modality == Modality.FINAL && this.hasFlag(ModifierFlag.INHERITANCE_FINAL) ? true : (modality == Modality.SEALED && this.hasFlag(ModifierFlag.INHERITANCE_SEALED) ? true : (modality == Modality.ABSTRACT && this.hasFlag(ModifierFlag.INHERITANCE_ABSTRACT) ? true : modality == Modality.OPEN && this.hasFlag(ModifierFlag.INHERITANCE_OPEN)));
    }

    @Nullable
    public final Modality getModality(boolean isClassOrObject) {
        return this.hasFlag(ModifierFlag.INHERITANCE_FINAL) ? Modality.FINAL : (this.hasFlag(ModifierFlag.INHERITANCE_SEALED) ? (isClassOrObject ? Modality.SEALED : null) : (this.hasFlag(ModifierFlag.INHERITANCE_ABSTRACT) ? Modality.ABSTRACT : (this.hasFlag(ModifierFlag.INHERITANCE_OPEN) ? Modality.OPEN : null)));
    }

    @NotNull
    public final Variance getVariance() {
        return this.hasFlag(ModifierFlag.VARIANCE_IN) ? Variance.IN_VARIANCE : (this.hasFlag(ModifierFlag.VARIANCE_OUT) ? Variance.OUT_VARIANCE : Variance.INVARIANT);
    }

    public final boolean hasVararg() {
        return this.hasFlag(ModifierFlag.PARAMETER_VARARG);
    }

    public final boolean hasNoinline() {
        return this.hasFlag(ModifierFlag.PARAMETER_NOINLINE);
    }

    public final boolean hasCrossinline() {
        return this.hasFlag(ModifierFlag.PARAMETER_CROSSINLINE);
    }

    public final boolean hasExpect() {
        return this.hasFlag(ModifierFlag.PLATFORM_EXPECT);
    }

    public final boolean hasActual() {
        return this.hasFlag(ModifierFlag.PLATFORM_ACTUAL);
    }

    public final boolean hasConst() {
        return this.hasFlag(ModifierFlag.PARAMETER_CONST);
    }

    protected final boolean hasFlag(@NotNull ModifierFlag flag) {
        Intrinsics.checkNotNullParameter((Object)((Object)flag), (String)"flag");
        return (this.modifiers & flag.getValue()) == flag.getValue();
    }

    protected final void setFlag(@Nullable ModifierFlag flag) {
        if (flag != null) {
            this.modifiers |= flag.getValue();
        }
    }

    @NotNull
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        boolean firstAppend = true;
        for (ModifierFlag value2 : ModifierFlag.getEntries()) {
            if (!this.hasFlag(value2) || value2 == ModifierFlag.NONE) continue;
            if (firstAppend) {
                firstAppend = false;
            } else {
                result2.append(" ");
            }
            result2.append(value2.name());
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public ModifierList() {
        this(0L, 1, null);
    }
}

