/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.isolated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.internal.Cast;
import org.gradle.internal.inspection.DefaultTypeParameterInspection;
import org.gradle.internal.inspection.TypeParameterInspection;
import org.gradle.internal.instantiation.managed.ManagedObjectRegistry;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.process.ExecOperations;
import org.jspecify.annotations.Nullable;

public class IsolationScheme<INTERFACE, PARAMS>
implements TypeParameterInspection<INTERFACE, PARAMS> {
    private final Class<INTERFACE> interfaceType;
    private final Class<? extends PARAMS> noParamsType;
    private final TypeParameterInspection<INTERFACE, PARAMS> typeParameterInspection;

    public IsolationScheme(Class<INTERFACE> interfaceType, Class<PARAMS> paramsType, Class<? extends PARAMS> noParamsType) {
        this.interfaceType = interfaceType;
        this.noParamsType = noParamsType;
        this.typeParameterInspection = new DefaultTypeParameterInspection<INTERFACE, PARAMS>(interfaceType, paramsType, noParamsType);
    }

    @Override
    public <T extends INTERFACE, P extends PARAMS> @Nullable Class<P> parameterTypeForOrNull(Class<T> implementationType) {
        return this.typeParameterInspection.parameterTypeForOrNull(implementationType);
    }

    @Override
    public <T extends INTERFACE, P extends PARAMS> @Nullable Class<P> parameterTypeForOrNull(Class<T> implementationType, int typeArgumentIndex) {
        return this.typeParameterInspection.parameterTypeForOrNull(implementationType, typeArgumentIndex);
    }

    @Override
    public <T extends INTERFACE, P extends PARAMS> Class<P> parameterTypeFor(Class<T> implementationType) {
        return this.typeParameterInspection.parameterTypeFor(implementationType);
    }

    @Override
    public <T extends INTERFACE, P extends PARAMS> Class<P> parameterTypeFor(Class<T> implementationType, int typeArgumentIndex) {
        return this.typeParameterInspection.parameterTypeFor(implementationType, typeArgumentIndex);
    }

    public ServiceLookup servicesForImplementation(@Nullable PARAMS params, ServiceLookup allServices, Collection<? extends Class<?>> additionalWhiteListedServices) {
        return new ServicesForIsolatedObject(this.interfaceType, this.noParamsType, params, allServices, additionalWhiteListedServices);
    }

    private static class ServicesForIsolatedObject
    implements ServiceLookup {
        private final Class<?> interfaceType;
        private final Class<?> noParamsType;
        private final Collection<? extends Class<?>> additionalWhiteListedServices;
        private final ServiceLookup allServices;
        private final @Nullable Object params;

        public ServicesForIsolatedObject(Class<?> interfaceType, Class<?> noParamsType, @Nullable Object params, ServiceLookup allServices, Collection<? extends Class<?>> additionalWhiteListedServices) {
            this.interfaceType = interfaceType;
            this.noParamsType = noParamsType;
            this.additionalWhiteListedServices = additionalWhiteListedServices;
            this.allServices = allServices;
            this.params = params;
        }

        public @Nullable Object find(Type serviceType) throws ServiceLookupException {
            if (serviceType instanceof Class) {
                Class serviceClass = (Class)Cast.uncheckedNonnullCast((Object)serviceType);
                if (serviceClass.isInstance(this.params)) {
                    return this.params;
                }
                if (serviceClass.isAssignableFrom(this.noParamsType)) {
                    throw new ServiceLookupException(String.format("Cannot query the parameters of an instance of %s that takes no parameters.", this.interfaceType.getSimpleName()));
                }
                if (serviceClass.isAssignableFrom(ExecOperations.class)) {
                    return this.allServices.find(ExecOperations.class);
                }
                if (serviceClass.isAssignableFrom(FileSystemOperations.class)) {
                    return this.allServices.find(FileSystemOperations.class);
                }
                if (serviceClass.isAssignableFrom(ArchiveOperations.class)) {
                    return this.allServices.find(ArchiveOperations.class);
                }
                if (serviceClass.isAssignableFrom(ObjectFactory.class)) {
                    return this.allServices.find(ObjectFactory.class);
                }
                if (serviceClass.isAssignableFrom(ProviderFactory.class)) {
                    return this.allServices.find(ProviderFactory.class);
                }
                if (serviceClass.isAssignableFrom(BuildServiceRegistry.class)) {
                    return this.allServices.find(BuildServiceRegistry.class);
                }
                if (serviceClass.isAssignableFrom(InternalProblems.class)) {
                    return this.allServices.find(InternalProblems.class);
                }
                if (serviceClass.isAssignableFrom(ManagedObjectRegistry.class)) {
                    return this.allServices.find(ManagedObjectRegistry.class);
                }
                for (Class<?> whiteListedService : this.additionalWhiteListedServices) {
                    if (!serviceClass.isAssignableFrom(whiteListedService)) continue;
                    return this.allServices.find(whiteListedService);
                }
            }
            return null;
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType);
            if (result == null) {
                return this.notFound(serviceType);
            }
            return result;
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            return this.notFound(serviceType);
        }

        private Object notFound(Type serviceType) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Services of type ");
            formatter.appendType(serviceType);
            formatter.append((CharSequence)" are not available for injection into instances of type ");
            formatter.appendType(this.interfaceType);
            formatter.append((CharSequence)".");
            throw new UnknownServiceException(serviceType, formatter.toString());
        }
    }
}

