/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.temp.DefaultTemporaryFileProvider;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.properties.GradlePropertiesController;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.ProjectDescriptorInternal;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.Pair;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildprocess.BuildProcessScopeServices;
import org.gradle.internal.buildtree.BuildActionModelRequirements;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildModelParametersFactory;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.RunTasksRequirements;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.problems.NoOpProblemDiagnosticsFactory;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.internal.time.Time;
import org.gradle.internal.work.ProjectParallelExecutionController;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.problems.buildtree.ProblemStream;
import org.gradle.testfixtures.internal.TestBuildScopeServices;
import org.gradle.testfixtures.internal.TestGlobalScopeServices;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class ProjectBuilderImpl {
    private static @Nullable ServiceRegistry globalServices;
    private static final Logger LOGGER;

    public Project createChildProject(String name, Project parent, @Nullable File projectDir) {
        ProjectInternal parentProject = (ProjectInternal)parent;
        ProjectDescriptorRegistry descriptorRegistry = (ProjectDescriptorRegistry)parentProject.getServices().get(ProjectDescriptorRegistry.class);
        ProjectDescriptorInternal parentDescriptor = descriptorRegistry.getProject(parentProject.getPath());
        projectDir = projectDir != null ? projectDir.getAbsoluteFile() : new File(parentProject.getProjectDir(), name);
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(parentDescriptor, name, projectDir, descriptorRegistry, (PathToFileResolver)parentProject.getServices().get(FileResolver.class));
        ProjectState projectState = ((ProjectStateRegistry)parentProject.getServices().get(ProjectStateRegistry.class)).registerProject((BuildState)parentProject.getServices().get(BuildState.class), (ProjectDescriptorInternal)projectDescriptor);
        projectState.createMutableModel(parentProject.getClassLoaderScope().createChild("project-" + name, null), parentProject.getBaseClassLoaderScope());
        ProjectInternal project = projectState.getMutableModel();
        ResourceLockCoordinationService coordinationService = (ResourceLockCoordinationService)project.getServices().get(ResourceLockCoordinationService.class);
        coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock((ResourceLock[])new ResourceLock[]{project.getOwner().getAccessLock()}));
        return project;
    }

    public ProjectInternal createProject(String name, @Nullable File inputProjectDir, @Nullable File gradleUserHomeDir) {
        UnsupportedJavaRuntimeException.assertCurrentProcessSupportsDaemonJavaVersion();
        int currentMajor = Integer.parseInt(JavaVersion.current().getMajorVersion());
        if (currentMajor < 17) {
            int currentMajorGradleVersion = GradleVersion.current().getMajorVersion();
            LOGGER.warn("Executing Gradle on JVM versions {} and lower has been deprecated. This will fail with an error in Gradle {}. Use JVM {} or greater to execute Gradle. Projects can continue to use older JVM versions via toolchains. Consult the upgrading guide for further information: {}", new Object[]{16, currentMajorGradleVersion + 1, 17, new DocumentationRegistry().getDocumentationFor("upgrading_version_" + currentMajorGradleVersion, "minimum_daemon_jvm_version")});
        }
        File projectDir = this.prepareProjectDir(inputProjectDir);
        File userHomeDir = gradleUserHomeDir == null ? new File(projectDir, "userHome") : FileUtils.canonicalize((File)gradleUserHomeDir);
        StartParameterInternal startParameter = new StartParameterInternal();
        startParameter.setGradleUserHomeDir(userHomeDir);
        startParameter.setCurrentDir(projectDir);
        startParameter.doNotSearchUpwards();
        NativeServices.NativeServicesMode nativeServicesMode = System.getProperty("org.gradle.native") != null ? NativeServices.NativeServicesMode.fromSystemProperties() : NativeServices.NativeServicesMode.DISABLED;
        NativeServices.initializeOnDaemon((File)userHomeDir, (NativeServices.NativeServicesMode)nativeServicesMode);
        ServiceRegistry globalServices = ProjectBuilderImpl.getGlobalServices();
        DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
        File userActionRootDir = ((BuildLayoutFactory)globalServices.get(BuildLayoutFactory.class)).getLayoutFor(startParameter.toBuildLayoutConfiguration()).getRootDirectory();
        CrossBuildSessionState crossBuildSessionState = new CrossBuildSessionState(globalServices, startParameter, userActionRootDir);
        GradleUserHomeScopeServiceRegistry userHomeServices = this.userHomeServicesOf(globalServices);
        BuildSessionState buildSessionState = new BuildSessionState(userHomeServices, crossBuildSessionState, startParameter, (BuildRequestMetaData)buildRequestMetaData, ClassPath.EMPTY, (BuildCancellationToken)new DefaultBuildCancellationToken(), buildRequestMetaData.getClient(), (BuildEventConsumer)new NoOpBuildEventConsumer());
        RunTasksRequirements buildActionRequirements = new RunTasksRequirements(startParameter);
        InternalOptions internalOptions = (InternalOptions)crossBuildSessionState.getServices().get(InternalOptions.class);
        ServiceRegistry buildSessionServices = buildSessionState.getServices();
        BuildModelParameters buildModelParameters = ((BuildModelParametersFactory)buildSessionServices.get(BuildModelParametersFactory.class)).parametersForRootBuildTree((BuildActionModelRequirements)buildActionRequirements, internalOptions);
        BuildInvocationScopeId buildInvocationScopeId = new BuildInvocationScopeId(UniqueId.generate());
        BuildTreeState buildTreeState = new BuildTreeState(buildSessionServices, (BuildActionModelRequirements)buildActionRequirements, buildModelParameters, buildInvocationScopeId);
        TestRootBuild build = new TestRootBuild(projectDir, startParameter, buildTreeState);
        CloseableServiceRegistry buildServices = build.getBuildServices();
        ((BuildStateRegistry)buildServices.get(BuildStateRegistry.class)).attachRootBuild((RootBuildState)build);
        DeprecationLogger.init((WarningMode)WarningMode.None, null, null, (ProblemStream)NoOpProblemDiagnosticsFactory.EMPTY_STREAM);
        ResourceLockCoordinationService coordinationService = (ResourceLockCoordinationService)buildServices.get(ResourceLockCoordinationService.class);
        WorkerLeaseService workerLeaseService = (WorkerLeaseService)buildServices.get(WorkerLeaseService.class);
        WorkerLeaseRegistry.WorkerLeaseCompletion workerLease = workerLeaseService.maybeStartWorker();
        ((ProjectParallelExecutionController)buildServices.get(ProjectParallelExecutionController.class)).startProjectExecution(false);
        GradleInternal gradle = build.getMutableModel();
        gradle.setIncludedBuilds(Collections.emptyList());
        GradlePropertiesController gradlePropertiesController = (GradlePropertiesController)buildServices.get(GradlePropertiesController.class);
        gradlePropertiesController.loadGradleProperties(build.getBuildIdentifier(), build.getBuildRootDir(), false);
        ProjectDescriptorRegistry projectDescriptorRegistry = (ProjectDescriptorRegistry)buildServices.get(ProjectDescriptorRegistry.class);
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(null, name, projectDir, projectDescriptorRegistry, (PathToFileResolver)buildServices.get(FileResolver.class));
        ClassLoaderScope baseScope = gradle.getClassLoaderScope();
        ClassLoaderScope rootProjectScope = baseScope.createChild("root-project", null);
        ProjectStateRegistry projectStateRegistry = (ProjectStateRegistry)buildServices.get(ProjectStateRegistry.class);
        ProjectState projectState = projectStateRegistry.registerProject((BuildState)build, (ProjectDescriptorInternal)projectDescriptor);
        projectState.createMutableModel(rootProjectScope, baseScope);
        ProjectInternal project = projectState.getMutableModel();
        gradle.setRootProject(project);
        gradle.setDefaultProject(project);
        coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock((ResourceLock[])new ResourceLock[]{project.getOwner().getAccessLock()}));
        Object[] objectArray = new Object[6];
        objectArray[0] = () -> ((WorkerLeaseService)workerLeaseService).runAsIsolatedTask();
        objectArray[1] = () -> ((WorkerLeaseRegistry.WorkerLeaseCompletion)workerLease).leaseFinish();
        objectArray[2] = buildServices;
        objectArray[3] = buildTreeState;
        objectArray[4] = buildSessionState;
        objectArray[5] = crossBuildSessionState;
        project.getExtensions().getExtraProperties().set("ProjectBuilder.stoppable", (Object)CompositeStoppable.stoppable((Object[])objectArray));
        return project;
    }

    public static void stop(Project rootProject) {
        ((Stoppable)rootProject.getExtensions().getExtraProperties().get("ProjectBuilder.stoppable")).stop();
    }

    private GradleUserHomeScopeServiceRegistry userHomeServicesOf(ServiceRegistry globalServices) {
        return (GradleUserHomeScopeServiceRegistry)globalServices.get(GradleUserHomeScopeServiceRegistry.class);
    }

    public static synchronized ServiceRegistry getGlobalServices() {
        if (globalServices == null) {
            globalServices = ProjectBuilderImpl.createGlobalServices();
            ((LegacyTypesSupport)globalServices.get(LegacyTypesSupport.class)).injectEmptyInterfacesIntoClassLoader(ProjectBuilderImpl.class.getClassLoader());
        }
        return globalServices;
    }

    private static ServiceRegistry createGlobalServices() {
        return ServiceRegistryBuilder.builder().displayName("global services").parent(LoggingServiceRegistry.newNestedLogging()).parent(NativeServices.getInstance()).provider((ServiceRegistrationProvider)new TestGlobalScopeServices()).provider((ServiceRegistrationProvider)new BuildProcessScopeServices()).build();
    }

    public File prepareProjectDir(@Nullable File projectDir) {
        if (projectDir != null) {
            return FileUtils.canonicalize((File)projectDir);
        }
        DefaultTemporaryFileProvider temporaryFileProvider = new DefaultTemporaryFileProvider(() -> {
            String rootTmpDir = SystemProperties.getInstance().getWorkerTmpDir();
            if (rootTmpDir == null) {
                String javaIoTmpDir;
                rootTmpDir = javaIoTmpDir = SystemProperties.getInstance().getJavaIoTmpDir();
            }
            return FileUtils.canonicalize((File)new File(rootTmpDir));
        });
        File tempDirectory = temporaryFileProvider.createTemporaryDirectory("gradle", "projectDir", new String[0]);
        tempDirectory.deleteOnExit();
        return tempDirectory;
    }

    static {
        LOGGER = Logging.getLogger(ProjectBuilderImpl.class);
    }

    private static class TestRootBuild
    extends AbstractBuildState
    implements RootBuildState {
        private final GradleInternal gradle;
        final CloseableServiceRegistry buildServices = this.getBuildServices();

        public TestRootBuild(File rootProjectDir, StartParameterInternal startParameter, BuildTreeState buildTreeState) {
            super(buildTreeState, BuildDefinition.fromStartParameter((StartParameterInternal)startParameter, (File)rootProjectDir, null), null);
            this.gradle = (GradleInternal)this.buildServices.get(GradleInternal.class);
        }

        protected ServiceRegistrationProvider prepareServicesProvider(BuildDefinition buildDefinition) {
            return new TestBuildScopeServices(buildDefinition, (BuildState)this);
        }

        public CloseableServiceRegistry getBuildServices() {
            return super.getBuildServices();
        }

        public void ensureProjectsLoaded() {
        }

        public void ensureProjectsConfigured() {
        }

        public Path getIdentityPath() {
            return Path.ROOT;
        }

        public boolean isImplicitBuild() {
            return false;
        }

        public StartParameterInternal getStartParameter() {
            throw new UnsupportedOperationException();
        }

        public <T> T run(Function<? super BuildTreeLifecycleController, T> action) {
            throw new UnsupportedOperationException();
        }

        public IncludedBuildInternal getModel() {
            throw new UnsupportedOperationException();
        }

        public Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getAvailableModules() {
            throw new UnsupportedOperationException();
        }

        public File getBuildRootDir() {
            return ((BuildDefinition)this.getBuildServices().get(BuildDefinition.class)).getBuildRootDir();
        }

        public GradleInternal getMutableModel() {
            return this.gradle;
        }
    }
}

