/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.internal.Cast;
import org.gradle.internal.MutableReference;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.jspecify.annotations.Nullable;

public class DefaultResourceLockCoordinationService
implements ResourceLockCoordinationService,
Closeable {
    private final Object lock = new Object();
    private final Set<Action<ResourceLock>> releaseHandlers = new LinkedHashSet<Action<ResourceLock>>();
    private @Nullable Thread currentOwner;
    private @Nullable DefaultResourceLockState currentState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.releaseHandlers.isEmpty()) {
                throw new IllegalStateException("Some lock release listeners have not been removed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assertHasStateLock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getCurrent() == null) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLockReleaseListener(Action<ResourceLock> listener) {
        Object object = this.lock;
        synchronized (object) {
            this.releaseHandlers.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLockReleaseListener(Action<ResourceLock> listener) {
        Object object = this.lock;
        synchronized (object) {
            this.releaseHandlers.remove(listener);
        }
    }

    @Override
    public void withStateLock(Runnable action) {
        this.withStateLock((ResourceLockState resourceLockState) -> {
            action.run();
            return ResourceLockState.Disposition.FINISHED;
        });
    }

    @Override
    public <T> T withStateLock(Supplier<T> action) {
        MutableReference<@Nullable T> result = MutableReference.empty();
        this.withStateLock((ResourceLockState resourceLockState) -> {
            result.set(action.get());
            return ResourceLockState.Disposition.FINISHED;
        });
        return (T)Cast.unsafeStripNullable(result.get());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean withStateLock(Function<ResourceLockState, ResourceLockState.Disposition> stateLockAction) {
        Object object = this.lock;
        synchronized (object) {
            DefaultResourceLockState resourceLockState = new DefaultResourceLockState();
            DefaultResourceLockState previous = this.startOperation(resourceLockState);
            try {
                block16: while (true) {
                    ResourceLockState.Disposition disposition = stateLockAction.apply(resourceLockState);
                    switch (disposition) {
                        case RETRY: {
                            resourceLockState.releaseLocks();
                            this.maybeNotifyStateChange(resourceLockState);
                            resourceLockState.reset();
                            this.finishOperation(previous);
                            try {
                                this.lock.wait();
                            }
                            catch (InterruptedException e) {
                                boolean bl = Thread.interrupted();
                            }
                            this.startOperation(resourceLockState);
                            continue block16;
                        }
                        case FINISHED: {
                            this.maybeNotifyStateChange(resourceLockState);
                            boolean bl = true;
                            return bl;
                        }
                        case FAILED: {
                            resourceLockState.releaseLocks();
                            boolean bl = false;
                            return bl;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled disposition type: " + disposition.name());
                        }
                    }
                    break;
                }
            }
            catch (Throwable t) {
                resourceLockState.releaseLocks();
                throw UncheckedException.throwAsUncheckedException((Throwable)t);
            }
            finally {
                this.finishOperation(previous);
            }
        }
    }

    private @Nullable DefaultResourceLockState startOperation(DefaultResourceLockState newState) {
        if (this.currentOwner == null) {
            this.currentOwner = Thread.currentThread();
        } else if (this.currentOwner != Thread.currentThread()) {
            throw new IllegalStateException("Another thread holds the state lock.");
        }
        DefaultResourceLockState previousState = this.currentState;
        this.currentState = newState;
        return previousState;
    }

    private void finishOperation(@Nullable DefaultResourceLockState previous) {
        if (this.currentOwner != Thread.currentThread()) {
            throw new IllegalStateException("Another thread holds the state lock.");
        }
        this.currentState = previous;
        if (this.currentState == null) {
            this.currentOwner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ResourceLockState getCurrent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentOwner != Thread.currentThread()) {
                return null;
            }
            return this.currentState;
        }
    }

    private void maybeNotifyStateChange(DefaultResourceLockState resourceLockState) {
        Collection<ResourceLock> unlockedResources = resourceLockState.getUnlockedResources();
        if (!unlockedResources.isEmpty()) {
            this.notifyStateChange();
            for (ResourceLock resource : unlockedResources) {
                for (Action<ResourceLock> releaseHandler : this.releaseHandlers) {
                    releaseHandler.execute(resource);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStateChange() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static Function<ResourceLockState, ResourceLockState.Disposition> lock(Iterable<? extends ResourceLock> resourceLocks) {
        return new AcquireLocks(resourceLocks, true);
    }

    public static Function<ResourceLockState, ResourceLockState.Disposition> lock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.lock(Arrays.asList(resourceLocks));
    }

    public static Function<ResourceLockState, ResourceLockState.Disposition> tryLock(Iterable<? extends ResourceLock> resourceLocks) {
        return new AcquireLocks(resourceLocks, false);
    }

    public static Function<ResourceLockState, ResourceLockState.Disposition> tryLock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.tryLock(Arrays.asList(resourceLocks));
    }

    public static Function<ResourceLockState, ResourceLockState.Disposition> unlock(Iterable<? extends ResourceLock> resourceLocks) {
        return new ReleaseLocks(resourceLocks);
    }

    public static Function<ResourceLockState, ResourceLockState.Disposition> unlock(ResourceLock ... resourceLocks) {
        return DefaultResourceLockCoordinationService.unlock(Arrays.asList(resourceLocks));
    }

    private static class DefaultResourceLockState
    implements ResourceLockState {
        private @Nullable Set<ResourceLock> lockedResources;
        private @Nullable Set<ResourceLock> unlockedResources;
        boolean rollback;

        private DefaultResourceLockState() {
        }

        @Override
        public void registerLocked(ResourceLock resourceLock) {
            if (!(this.rollback || this.unlockedResources != null && this.unlockedResources.remove(resourceLock))) {
                if (this.lockedResources == null) {
                    this.lockedResources = new HashSet<ResourceLock>();
                }
                this.lockedResources.add(resourceLock);
            }
        }

        @Override
        public void registerUnlocked(ResourceLock resourceLock) {
            if (!(this.rollback || this.lockedResources != null && this.lockedResources.remove(resourceLock))) {
                if (this.unlockedResources == null) {
                    this.unlockedResources = new HashSet<ResourceLock>();
                }
                this.unlockedResources.add(resourceLock);
            }
        }

        Collection<ResourceLock> getUnlockedResources() {
            return this.unlockedResources == null ? Collections.emptyList() : this.unlockedResources;
        }

        @Override
        public void releaseLocks() {
            if (this.lockedResources != null) {
                this.rollback = true;
                try {
                    for (ResourceLock resourceLock : this.lockedResources) {
                        resourceLock.unlock();
                    }
                    this.lockedResources.clear();
                }
                finally {
                    this.rollback = false;
                }
            }
        }

        public void reset() {
            if (this.lockedResources != null) {
                this.lockedResources.clear();
            }
            if (this.unlockedResources != null) {
                this.unlockedResources.clear();
            }
            this.rollback = false;
        }
    }

    private static class AcquireLocks
    implements Function<ResourceLockState, ResourceLockState.Disposition> {
        private final Iterable<? extends ResourceLock> resourceLocks;
        private final boolean blocking;

        AcquireLocks(Iterable<? extends ResourceLock> resourceLocks, boolean blocking) {
            this.resourceLocks = resourceLocks;
            this.blocking = blocking;
        }

        @Override
        public ResourceLockState.Disposition apply(ResourceLockState resourceLockState) {
            for (ResourceLock resourceLock : this.resourceLocks) {
                if (resourceLock.tryLock()) continue;
                return this.blocking ? ResourceLockState.Disposition.RETRY : ResourceLockState.Disposition.FAILED;
            }
            return ResourceLockState.Disposition.FINISHED;
        }
    }

    private static class ReleaseLocks
    implements Function<ResourceLockState, ResourceLockState.Disposition> {
        private final Iterable<? extends ResourceLock> resourceLocks;

        ReleaseLocks(Iterable<? extends ResourceLock> resourceLocks) {
            this.resourceLocks = resourceLocks;
        }

        @Override
        public ResourceLockState.Disposition apply(ResourceLockState resourceLockState) {
            for (ResourceLock resourceLock : this.resourceLocks) {
                resourceLock.unlock();
            }
            return ResourceLockState.Disposition.FINISHED;
        }
    }
}

